/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.refactoring;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.mtj.internal.core.Messages;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class BuildPropertiesChange
extends TextFileChange {
    private boolean changed;
    private String oldName;
    private String newName;

    public BuildPropertiesChange(IFile iFile, String string, String string2) {
        super(Messages.BuildPropertiesChange_changeMessage, iFile);
        this.oldName = string;
        this.newName = string2;
        NullProgressMonitor nullProgressMonitor = new NullProgressMonitor();
        try {
            TextEdit[] textEditArray;
            String string3 = this.getCurrentContent((IProgressMonitor)nullProgressMonitor);
            MultiTextEdit multiTextEdit = new MultiTextEdit();
            TextEdit[] textEditArray2 = textEditArray = this.createTextEdits(string3, (IProgressMonitor)nullProgressMonitor);
            int n = textEditArray.length;
            int n2 = 0;
            while (n2 < n) {
                TextEdit textEdit = textEditArray2[n2];
                multiTextEdit.addChild(textEdit);
                ++n2;
            }
            this.changed = textEditArray.length > 0;
            this.setEdit((TextEdit)multiTextEdit);
        }
        catch (CoreException coreException) {
            MTJLogger.log(4, coreException);
        }
    }

    public boolean hasPropertiesChanges() {
        return this.changed;
    }

    private TextEdit[] createTextEdits(String string, IProgressMonitor iProgressMonitor) {
        ArrayList<ReplaceEdit> arrayList = new ArrayList<ReplaceEdit>();
        Pattern pattern = Pattern.compile(this.oldName);
        Matcher matcher = pattern.matcher(string);
        while (matcher.find()) {
            int n = matcher.start();
            int n2 = matcher.end() - n;
            ReplaceEdit replaceEdit = new ReplaceEdit(n, n2, this.newName);
            arrayList.add(replaceEdit);
        }
        TextEdit[] textEditArray = new TextEdit[arrayList.size()];
        arrayList.toArray(textEditArray);
        return textEditArray;
    }
}

