/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.refactoring;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RenameParticipant;
import org.eclipse.mtj.internal.core.Messages;
import org.eclipse.mtj.internal.core.refactoring.BuildPropertiesChange;

public class BuildPropertiesPackageRenameParticipant
extends RenameParticipant {
    private IPackageFragment packageFragment;

    public RefactoringStatus checkConditions(IProgressMonitor iProgressMonitor, CheckConditionsContext checkConditionsContext) throws OperationCanceledException {
        return new RefactoringStatus();
    }

    public Change createChange(IProgressMonitor iProgressMonitor) throws CoreException, OperationCanceledException {
        CompositeChange compositeChange = new CompositeChange(Messages.BuildPropertiesPackageRenameParticipant_buildPropertiesChangeMessage);
        this.createBuildPropertiesChanges(compositeChange);
        return compositeChange.getChildren().length > 0 ? compositeChange : null;
    }

    private void createBuildPropertiesChanges(CompositeChange compositeChange) {
        if (this.packageFragment == null) {
            return;
        }
        IResource iResource = this.packageFragment.getResource();
        if (iResource != null) {
            BuildPropertiesChange buildPropertiesChange;
            String string = this.packageFragment.getElementName().replace(".", "/");
            String string2 = this.getArguments().getNewName().replace(".", "/");
            IPath iPath = iResource.getProjectRelativePath();
            Path path = new Path(iPath.toString().replace(string, string2));
            IFile iFile = iResource.getProject().getFile("build.properties");
            if (iFile.exists() && (buildPropertiesChange = new BuildPropertiesChange(iFile, iPath.toString(), path.toString())).hasPropertiesChanges()) {
                compositeChange.add((Change)buildPropertiesChange);
            }
        }
    }

    public String getName() {
        return Messages.BuildPropertiesPackageRenameParticipant_buildPropertiesPackageRenamePaticipant;
    }

    protected boolean initialize(Object object) {
        this.packageFragment = (IPackageFragment)object;
        return true;
    }
}

