/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.refactoring;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RenameParticipant;
import org.eclipse.mtj.internal.core.refactoring.JadLaunchConfigProjectRenameChange;
import org.eclipse.mtj.internal.core.refactoring.RefactoringMessages;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;

public class JadLaunchConfigProjectRenameParticipant
extends RenameParticipant {
    private IJavaProject fJavaProject;

    protected boolean initialize(Object object) {
        this.fJavaProject = (IJavaProject)object;
        return true;
    }

    public String getName() {
        return RefactoringMessages.JadLaunchConfigParticipant_name;
    }

    public RefactoringStatus checkConditions(IProgressMonitor iProgressMonitor, CheckConditionsContext checkConditionsContext) throws OperationCanceledException {
        return new RefactoringStatus();
    }

    public Change createChange(IProgressMonitor iProgressMonitor) throws CoreException, OperationCanceledException {
        ILaunchConfiguration[] iLaunchConfigurationArray;
        ArrayList<JadLaunchConfigProjectRenameChange> arrayList = new ArrayList<JadLaunchConfigProjectRenameChange>();
        ILaunchConfiguration[] iLaunchConfigurationArray2 = iLaunchConfigurationArray = this.getRelatedJadLaunchConfigs(this.fJavaProject.getElementName());
        int n = iLaunchConfigurationArray.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunchConfiguration iLaunchConfiguration = iLaunchConfigurationArray2[n2];
            arrayList.add(new JadLaunchConfigProjectRenameChange(iLaunchConfiguration, this.getArguments().getNewName()));
            ++n2;
        }
        int n3 = arrayList.size();
        if (n3 == 0) {
            return null;
        }
        if (n3 == 1) {
            return (Change)arrayList.get(0);
        }
        return new CompositeChange(RefactoringMessages.JadLaunchConfigCompositeChange_name, arrayList.toArray(new Change[arrayList.size()]));
    }

    private ILaunchConfiguration[] getRelatedJadLaunchConfigs(String string) {
        if (string == null || string.trim().length() == 0) {
            return new ILaunchConfiguration[0];
        }
        try {
            ILaunchConfiguration[] iLaunchConfigurationArray = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations(this.getEmulatorConfigType());
            ArrayList<ILaunchConfiguration> arrayList = new ArrayList<ILaunchConfiguration>();
            int n = 0;
            while (n < iLaunchConfigurationArray.length) {
                String string2 = iLaunchConfigurationArray[n].getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, null);
                boolean bl = iLaunchConfigurationArray[n].getAttribute("mtj.do_jad_launch", false);
                boolean bl2 = string.equals(string2);
                if (bl && bl2) {
                    arrayList.add(iLaunchConfigurationArray[n]);
                }
                ++n;
            }
            return arrayList.toArray(new ILaunchConfiguration[arrayList.size()]);
        }
        catch (CoreException coreException) {
            MTJLogger.log(4, coreException);
            return new ILaunchConfiguration[0];
        }
    }

    private ILaunchConfigurationType getEmulatorConfigType() {
        ILaunchManager iLaunchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType iLaunchConfigurationType = iLaunchManager.getLaunchConfigurationType("MTJ.emulatorLaunchConfigurationType");
        return iLaunchConfigurationType;
    }
}

