/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.refactoring;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MidLetsCollector {
    public static Set<IType> collectMidletsInPackage(IPackageFragment iPackageFragment, IProgressMonitor iProgressMonitor) {
        HashSet<IType> hashSet = new HashSet<IType>();
        List<IType> list = MidLetsCollector.collectMidletsInProject(iProgressMonitor, iPackageFragment.getJavaProject());
        for (IType iType : list) {
            if (!iType.getPackageFragment().equals(iPackageFragment)) continue;
            hashSet.add(iType);
        }
        return hashSet;
    }

    public static List<IType> collectMidletsInProject(IProgressMonitor iProgressMonitor, IJavaProject iJavaProject) {
        HashSet<IType> hashSet = new HashSet<IType>(5);
        try {
            IType iType = iJavaProject.findType("javax.microedition.midlet.MIDlet");
            ITypeHierarchy iTypeHierarchy = iType.newTypeHierarchy(iJavaProject, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
            IType[] iTypeArray = iTypeHierarchy.getAllSubtypes(iType);
            int n = iTypeArray.length;
            if (n != 0) {
                int n2 = 0;
                while (n2 < n) {
                    if (!iTypeArray[n2].isBinary()) {
                        hashSet.add(iTypeArray[n2]);
                    }
                    ++n2;
                }
            }
        }
        catch (JavaModelException javaModelException) {}
        iProgressMonitor.done();
        return new ArrayList<IType>(hashSet);
    }
}

