/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.sdk;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.core.persistence.PersistenceException;
import org.eclipse.mtj.core.sdk.ISDK;
import org.eclipse.mtj.core.sdk.device.IDevice;
import org.eclipse.mtj.core.sdk.device.IManagedDevice;
import org.eclipse.mtj.internal.core.Messages;
import org.eclipse.mtj.internal.core.persistence.PersistableUtilities;
import org.eclipse.mtj.internal.core.sdk.AbstractSDKProvider;
import org.eclipse.mtj.internal.core.sdk.device.DeviceRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportedSDKProvider
extends AbstractSDKProvider {
    private static ImportedSDKProvider instance = null;

    public static synchronized ImportedSDKProvider getInstance() {
        if (instance == null) {
            instance = new ImportedSDKProvider();
        }
        return instance;
    }

    private ImportedSDKProvider() {
        this.name = Messages.SdkProvider_ImportedSdkProviderName;
    }

    @Override
    public String getIdentifier() {
        return "MtjImportedSdkProviderId";
    }

    @Override
    public int getSDKCount() {
        return this.getSDKs().size();
    }

    @Override
    public List<ISDK> getSDKs() {
        List<IDevice> list;
        ArrayList<ISDK> arrayList = new ArrayList<ISDK>();
        try {
            list = DeviceRegistry.getInstance().getAllDevices();
        }
        catch (PersistenceException persistenceException) {
            persistenceException.printStackTrace();
            return arrayList;
        }
        for (IDevice iDevice : list) {
            ISDK iSDK;
            if (iDevice instanceof IManagedDevice || (iSDK = iDevice.getSDK()) == null || arrayList.contains(iSDK)) continue;
            arrayList.add(iSDK);
        }
        return arrayList;
    }

    public boolean removeDevice(IDevice iDevice) {
        try {
            MTJCore.getDeviceRegistry().removeDevice(iDevice);
        }
        catch (PersistenceException persistenceException) {
            persistenceException.printStackTrace();
            return false;
        }
        return true;
    }

    public IDevice duplicateDevice(IDevice iDevice, String string) {
        IDevice iDevice2 = null;
        try {
            iDevice2 = (IDevice)PersistableUtilities.clonePersistable(iDevice);
        }
        catch (PersistenceException persistenceException) {
            persistenceException.printStackTrace();
            return null;
        }
        iDevice2.setName(string);
        MTJCore.getDeviceRegistry().enableDeviceAddedEvent(true);
        try {
            MTJCore.getDeviceRegistry().addDevice(iDevice2);
            return iDevice2;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            MTJCore.getDeviceRegistry().enableDeviceAddedEvent(false);
            illegalArgumentException.printStackTrace();
        }
        catch (PersistenceException persistenceException) {
            MTJCore.getDeviceRegistry().enableDeviceAddedEvent(false);
            persistenceException.printStackTrace();
        }
        return null;
    }
}

