/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.sdk.device;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.core.persistence.IPersistable;
import org.eclipse.mtj.core.persistence.IPersistenceProvider;
import org.eclipse.mtj.core.persistence.PersistenceException;
import org.eclipse.mtj.core.sdk.device.IDevice;
import org.eclipse.mtj.internal.core.persistence.XMLPersistenceProvider;
import org.eclipse.mtj.internal.core.sdk.device.IDeviceMatchCache;
import org.eclipse.mtj.internal.core.util.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class DeviceMatchCache
implements IPersistable,
IDeviceMatchCache {
    private static final String ELEMENT_DEVICECACHE = "devicematchcache";
    private static final String DEVICECACHE_FILENAME = "devicematchcache.xml";
    private static Hashtable<String, String[]> deviceCache = null;
    private static IDeviceMatchCache instance = null;

    public static IDeviceMatchCache getInstance() {
        if (instance == null) {
            instance = new DeviceMatchCache();
        }
        return instance;
    }

    private File getComponentStoreFile() {
        IPath iPath = MTJCore.getMTJCore().getStateLocation();
        IPath iPath2 = iPath.append(DEVICECACHE_FILENAME);
        return iPath2.toFile();
    }

    private void loadCache() throws PersistenceException {
        File file = this.getComponentStoreFile();
        if (file.exists()) {
            try {
                Document document = XMLUtils.readDocument(file);
                if (document == null) {
                    return;
                }
                Element element = document.getDocumentElement();
                if (!element.getNodeName().equals(ELEMENT_DEVICECACHE)) {
                    return;
                }
                XMLPersistenceProvider xMLPersistenceProvider = new XMLPersistenceProvider(document);
                this.loadUsing(xMLPersistenceProvider);
            }
            catch (ParserConfigurationException parserConfigurationException) {
                throw new PersistenceException(parserConfigurationException.getMessage(), parserConfigurationException);
            }
            catch (SAXException sAXException) {
                throw new PersistenceException(sAXException.getMessage(), sAXException);
            }
            catch (IOException iOException) {
                throw new PersistenceException(iOException.getMessage(), iOException);
            }
        } else {
            deviceCache = new Hashtable();
        }
    }

    private void saveCache() throws PersistenceException {
        XMLPersistenceProvider xMLPersistenceProvider = new XMLPersistenceProvider(ELEMENT_DEVICECACHE);
        this.storeUsing(xMLPersistenceProvider);
        try {
            XMLUtils.writeDocument(this.getComponentStoreFile(), xMLPersistenceProvider.getDocument());
        }
        catch (TransformerException transformerException) {
            throw new PersistenceException(transformerException.getMessage(), transformerException);
        }
        catch (IOException iOException) {
            throw new PersistenceException(iOException.getMessage(), iOException);
        }
    }

    public String[] getValueFromCache(String string) {
        if (deviceCache == null) {
            try {
                this.loadCache();
            }
            catch (PersistenceException persistenceException) {
                persistenceException.printStackTrace();
                return null;
            }
        }
        if (deviceCache.containsKey(string)) {
            return deviceCache.get(string);
        }
        return null;
    }

    public String createKey(String string, String string2) {
        return new String(String.valueOf(string) + "/" + string2);
    }

    public void saveInCache(String string, String[] stringArray) {
        try {
            if (deviceCache == null) {
                this.loadCache();
            }
            deviceCache.put(string, stringArray);
            this.saveCache();
        }
        catch (PersistenceException persistenceException) {
            persistenceException.printStackTrace();
        }
    }

    public String[] createValue(IDevice iDevice) {
        return new String[]{iDevice.getSDKName(), iDevice.getName()};
    }

    public void loadUsing(IPersistenceProvider iPersistenceProvider) throws PersistenceException {
        int n = iPersistenceProvider.loadInteger("entries");
        deviceCache = new Hashtable(2 * n);
        int n2 = 0;
        while (n2 < n) {
            String string = iPersistenceProvider.loadString("key" + n2);
            String string2 = iPersistenceProvider.loadString("value" + n2);
            deviceCache.put(string, string2.split("/"));
            ++n2;
        }
    }

    public void storeUsing(IPersistenceProvider iPersistenceProvider) throws PersistenceException {
        iPersistenceProvider.storeInteger("entries", deviceCache.size());
        int n = 0;
        Enumeration<String> enumeration = deviceCache.keys();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            String[] stringArray = deviceCache.get(string);
            String string2 = String.valueOf(stringArray[0]) + "/" + stringArray[1];
            iPersistenceProvider.storeString("key" + n, string);
            iPersistenceProvider.storeString("value" + n, string2);
            ++n;
        }
    }
}

