/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.sdk.device;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.transform.TransformerException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.core.persistence.IPersistenceProvider;
import org.eclipse.mtj.core.persistence.PersistenceException;
import org.eclipse.mtj.core.sdk.device.IDevice;
import org.eclipse.mtj.core.sdk.device.ILibrary;
import org.eclipse.mtj.core.sdk.device.IManagedDevice;
import org.eclipse.mtj.internal.core.persistence.XMLPersistenceProvider;
import org.eclipse.mtj.internal.core.sdk.BasicSDK;
import org.eclipse.mtj.internal.core.sdk.device.DeviceRegistry;
import org.eclipse.mtj.internal.core.util.xml.XMLUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ImportedDeviceRegistry {
    private Map<String, Map<String, IDevice>> deviceGroupsMap;
    private Map<String, Map<String, IDevice>> invalidDeviceGroupsMap = new HashMap<String, Map<String, IDevice>>();

    ImportedDeviceRegistry() {
    }

    void addDevice(IDevice iDevice) throws IllegalArgumentException, PersistenceException {
        if (iDevice.getSDKName() == null || iDevice.getName() == null) {
            throw new IllegalArgumentException();
        }
        Map<String, IDevice> map = this.getDeviceGroupMap(iDevice.getSDKName(), true);
        map.put(iDevice.getName(), iDevice);
    }

    void clear() throws PersistenceException {
        this.getDeviceGroupsMap().clear();
    }

    List<IDevice> getAllDevices() throws PersistenceException {
        return this.getAllDevicesInternal(false, null);
    }

    IDevice getDevice(String string, String string2) throws PersistenceException {
        IDevice iDevice = null;
        Map<String, IDevice> map = this.getDeviceGroupMap(string, false);
        if (map != null) {
            iDevice = map.get(string2);
        }
        return iDevice;
    }

    int getDeviceCount() throws PersistenceException {
        int n = 0;
        for (Map<String, IDevice> map : this.getDeviceGroupsMap().values()) {
            n += map.size();
        }
        return n;
    }

    List<IDevice> getDevices(String string) throws PersistenceException {
        List<IDevice> list = this.getAllDevicesInternal(true, string);
        return list.isEmpty() ? null : list;
    }

    List<String> getSDKNames() throws PersistenceException {
        return new ArrayList<String>(this.getDeviceGroupsMap().keySet());
    }

    void load() throws PersistenceException {
        XMLPersistenceProvider xMLPersistenceProvider = DeviceRegistry.createPersistenceProvider();
        if (xMLPersistenceProvider != null) {
            this.loadUsing(xMLPersistenceProvider, false);
        }
    }

    /*
     * WARNING - void declaration
     */
    void loadUsing(IPersistenceProvider iPersistenceProvider, boolean bl) throws PersistenceException {
        this.getDeviceGroupsMap().clear();
        this.invalidDeviceGroupsMap.clear();
        int n = iPersistenceProvider.loadInteger("deviceCount");
        int n2 = 0;
        while (n2 < n) {
            IDevice iDevice = (IDevice)iPersistenceProvider.loadPersistable("device" + n2);
            List<ILibrary> list = iDevice.getClasspath().getEntries();
            boolean bl2 = true;
            for (ILibrary iLibrary : list) {
                File file = iLibrary.toFile();
                if (file.exists()) continue;
                bl2 = false;
                break;
            }
            if (!bl) {
                this.addDevice(iDevice);
                if (!bl2) {
                    void var8_12;
                    Map<String, IDevice> map = this.invalidDeviceGroupsMap.get(iDevice.getSDKName());
                    if (map == null) {
                        HashMap hashMap = new HashMap();
                        this.invalidDeviceGroupsMap.put(iDevice.getSDKName(), hashMap);
                    }
                    if (!var8_12.containsKey(iDevice.getName())) {
                        var8_12.put(iDevice.getName(), iDevice);
                    }
                }
            } else if (bl2) {
                this.addDevice(iDevice);
            }
            ++n2;
        }
    }

    synchronized void removeDevice(IDevice iDevice) throws PersistenceException {
        Object object;
        if (iDevice instanceof IManagedDevice) {
            return;
        }
        Map<String, IDevice> map = this.getDeviceGroupMap(iDevice.getSDKName(), false);
        if (map != null) {
            object = this.getDeviceKey(map, iDevice);
            if (object != null) {
                map.remove(object);
            }
            if (map.isEmpty()) {
                this.deviceGroupsMap.remove(iDevice.getSDKName());
            }
        }
        if ((object = iDevice.getSDK()) instanceof BasicSDK) {
            ((BasicSDK)object).deleteDevice(iDevice);
        }
    }

    private String getDeviceKey(Map<String, IDevice> map, IDevice iDevice) {
        String string = null;
        for (Map.Entry<String, IDevice> entry : map.entrySet()) {
            IDevice iDevice2 = entry.getValue();
            if (iDevice2 != iDevice) continue;
            string = entry.getKey();
            break;
        }
        return string;
    }

    void store() throws PersistenceException, TransformerException, IOException {
        XMLPersistenceProvider xMLPersistenceProvider = new XMLPersistenceProvider("deviceRegistry");
        this.storeUsing(xMLPersistenceProvider);
        XMLUtils.writeDocument(this.getComponentStoreFile(), xMLPersistenceProvider.getDocument());
    }

    void storeUsing(IPersistenceProvider iPersistenceProvider) throws PersistenceException {
        List<IDevice> list = this.getAllDevices();
        int n = 0;
        for (IDevice iDevice : list) {
            if (iDevice instanceof IManagedDevice) continue;
            iPersistenceProvider.storePersistable("device" + n++, iDevice);
        }
        iPersistenceProvider.storeInteger("deviceCount", n);
    }

    protected void createAndLoadDeviceGroups() throws PersistenceException {
        this.deviceGroupsMap = new HashMap<String, Map<String, IDevice>>();
        this.load();
    }

    private File getComponentStoreFile() {
        IPath iPath = MTJCore.getMTJCore().getStateLocation();
        IPath iPath2 = iPath.append("devices.xml");
        return iPath2.toFile();
    }

    protected Map<String, IDevice> getDeviceGroupMap(String string, boolean bl) throws PersistenceException {
        Map<String, Map<String, IDevice>> map = this.getDeviceGroupsMap();
        Map<String, IDevice> map2 = map.get(string);
        if (map2 == null && bl) {
            map2 = new HashMap<String, IDevice>();
            map.put(string, map2);
        }
        return map2;
    }

    private synchronized Map<String, Map<String, IDevice>> getDeviceGroupsMap() throws PersistenceException {
        if (this.deviceGroupsMap == null) {
            this.createAndLoadDeviceGroups();
        }
        return this.deviceGroupsMap;
    }

    List<String> getInvalidSDKNames() {
        return new ArrayList<String>(this.invalidDeviceGroupsMap.keySet());
    }

    private List<IDevice> getAllDevicesInternal(boolean bl, String string) throws PersistenceException {
        if (!bl && string != null) {
            throw new IllegalArgumentException("If filterByGroupName is false, groupName should be null");
        }
        if (bl && string == null) {
            throw new IllegalArgumentException("If filterByGroupName is true, groupName cannot be null");
        }
        ArrayList<IDevice> arrayList = new ArrayList<IDevice>();
        for (Map<String, IDevice> object : this.getDeviceGroupsMap().values()) {
            arrayList.addAll(object.values());
        }
        if (bl) {
            ArrayList<IDevice> arrayList2 = new ArrayList<IDevice>();
            for (IDevice iDevice : arrayList) {
                if (!iDevice.getSDKName().equals(string)) continue;
                arrayList2.add(iDevice);
            }
            return arrayList2;
        }
        return arrayList;
    }
}

