/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.statemachine;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.mtj.internal.core.Messages;
import org.eclipse.mtj.internal.core.statemachine.AbstractFinalState;
import org.eclipse.mtj.internal.core.statemachine.AbstractState;
import org.eclipse.mtj.internal.core.statemachine.AbstractStateMachineEvent;
import org.eclipse.mtj.internal.core.statemachine.StateMachineListener;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;

public class StateMachine {
    private List<StateMachineListener> listeners = new ArrayList<StateMachineListener>();
    private List<AbstractState> states = new ArrayList<AbstractState>();
    private AbstractState current;
    private boolean started;

    public synchronized void setInitialState(AbstractState abstractState) {
        if (abstractState == null) {
            throw new IllegalArgumentException(Messages.StateMachine_nullInitialState);
        }
        if (this.started) {
            throw new IllegalStateException(Messages.StateMachine_machineAlreadyStarted);
        }
        if (!this.states.contains(abstractState)) {
            throw new IllegalStateException(Messages.StateMachine_invalidInitialState);
        }
        this.current = abstractState;
    }

    public synchronized void start() {
        if (this.started) {
            throw new IllegalStateException(Messages.StateMachine_machineAlreadyStarted);
        }
        if (this.current == null) {
            throw new IllegalStateException(Messages.StateMachine_noInitialState);
        }
        this.started = true;
        for (StateMachineListener stateMachineListener : this.listeners) {
            try {
                stateMachineListener.started();
            }
            catch (Throwable throwable) {
                MTJLogger.log(2, throwable);
            }
        }
        this.current.onEnterState();
    }

    public synchronized void stop() {
        if (!this.started) {
            throw new IllegalStateException(Messages.StateMachine_machineNotYetStarted);
        }
        this.started = false;
        this.current.onExitState();
        for (StateMachineListener stateMachineListener : this.listeners) {
            try {
                stateMachineListener.stopped();
            }
            catch (Throwable throwable) {
                MTJLogger.log(2, throwable);
            }
        }
    }

    public synchronized void postEvent(AbstractStateMachineEvent abstractStateMachineEvent) {
        if (!this.started) {
            throw new IllegalStateException(Messages.StateMachine_machineNotYetStarted);
        }
        AbstractState abstractState = this.current.postEvent(abstractStateMachineEvent);
        if (abstractState != null) {
            this.current.onExitState();
            this.current = abstractState;
            this.current.onEnterState();
            if (this.current instanceof AbstractFinalState) {
                for (StateMachineListener stateMachineListener : this.listeners) {
                    try {
                        stateMachineListener.finished();
                    }
                    catch (Throwable throwable) {
                        MTJLogger.log(2, throwable);
                    }
                }
                this.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addState(AbstractState abstractState) {
        if (this.started) {
            throw new IllegalStateException(Messages.StateMachine_machineAlreadyStarted);
        }
        List<AbstractState> list = this.states;
        synchronized (list) {
            if (!this.states.contains(abstractState)) {
                this.states.add(abstractState);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeState(AbstractState abstractState) {
        if (this.started) {
            throw new IllegalStateException(Messages.StateMachine_machineAlreadyStarted);
        }
        List<AbstractState> list = this.states;
        synchronized (list) {
            this.states.remove(abstractState);
        }
    }

    public AbstractState[] getStates() {
        return this.states.toArray(new AbstractState[this.states.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStateMachineListener(StateMachineListener stateMachineListener) {
        List<StateMachineListener> list = this.listeners;
        synchronized (list) {
            if (!this.listeners.contains(stateMachineListener)) {
                this.listeners.add(stateMachineListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStateMachineListener(StateMachineListener stateMachineListener) {
        List<StateMachineListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(stateMachineListener);
        }
    }
}

