/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.toolkit.sdkprovidertestclamp;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.mtj.core.sdk.ISDKProvider;
import org.eclipse.mtj.core.sdk.ManagedSDK;
import org.eclipse.mtj.core.sdk.device.IDevice;
import org.eclipse.mtj.core.sdk.device.IManagedDevice;
import org.eclipse.mtj.toolkit.sdkprovidertestclamp.Device;
import org.eclipse.mtj.toolkit.sdkprovidertestclamp.Plugin;
import org.osgi.framework.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Sdk
extends ManagedSDK {
    private ISDKProvider provider;
    private String name;
    private String description;
    private String identifier;
    private Version version;
    private ArrayList<IManagedDevice> myDevices;

    public Sdk(ISDKProvider iSDKProvider, String string) {
        Properties properties = Plugin.getDefault().getProperties();
        this.provider = iSDKProvider;
        this.name = properties.getProperty(String.valueOf(string) + ".name");
        this.description = properties.getProperty(String.valueOf(string) + ".description");
        this.identifier = properties.getProperty(String.valueOf(string) + ".id");
        this.version = new Version(properties.getProperty(String.valueOf(string) + ".version"));
        String[] stringArray = properties.getProperty(String.valueOf(string) + ".devices").split(",");
        this.myDevices = new ArrayList(stringArray.length);
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string2 = stringArray2[n2];
            Device device = new Device(this, "device." + string2);
            this.myDevices.add(device);
            ++n2;
        }
    }

    protected List<IManagedDevice> getProvidedDeviceList() throws CoreException {
        return this.myDevices;
    }

    public ISDKProvider getSDKProvider() {
        return this.provider;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public Version getVersion() {
        return this.version;
    }

    public void deleteDuplicateDevice(IManagedDevice iManagedDevice) {
        if (iManagedDevice.isDuplicate()) {
            this.myDevices.remove(iManagedDevice);
        }
    }

    public IDevice duplicateDevice(IManagedDevice iManagedDevice, String string) {
        Device device = null;
        if (iManagedDevice instanceof Device) {
            try {
                device = (Device)((Device)iManagedDevice).clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                cloneNotSupportedException.printStackTrace();
                return null;
            }
        }
        device.setAsDuplicate();
        device.setName(string);
        this.myDevices.add(device);
        return device;
    }
}

