/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core.compiler.ast;

import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.Block;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ReturnStatement;
import org.eclipse.jdt.internal.compiler.ast.SingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.TryStatement;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.flow.ExceptionHandlingFlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.flow.UnconditionalFlowInfo;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.AbstractMethodMappingDeclaration;
import org.eclipse.objectteams.otdt.internal.core.compiler.statemachine.transformer.BaseScopeMarker;
import org.eclipse.objectteams.otdt.internal.core.compiler.statemachine.transformer.PredicateGenerator;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.AstGenerator;

public class GuardPredicateDeclaration
extends MethodDeclaration {
    public static final int UNKNOWN_PREDICATE = 0;
    public static final int TYPE_PREDICATE = 1;
    public static final int BINDING_PREDICATE = 2;
    public static final int METHOD_PREDICATE = 3;
    public int kind;
    public ReturnStatement returnStatement;
    public boolean isBasePredicate;

    public GuardPredicateDeclaration(CompilationResult compilationResult, char[] methodName, boolean isBasePredicate, int start, int end) {
        super(compilationResult);
        this.selector = methodName;
        this.isBasePredicate = isBasePredicate;
        this.sourceStart = start;
        this.sourceEnd = end;
        this.declarationSourceStart = start;
        this.declarationSourceEnd = end;
        this.isGenerated = true;
        this.isReusingSourceMethod = true;
        this.returnType = new SingleTypeReference(TypeConstants.BOOLEAN, ((long)start << 32) + (long)end);
    }

    public GuardPredicateDeclaration(CompilationResult compilationResult, char[] methodName, int kind, boolean typeIsRole, boolean isBasePredicate, int start, int end) {
        this(compilationResult, methodName, isBasePredicate, start, end);
        this.kind = kind;
        this.modifiers = 36;
        if (isBasePredicate && (typeIsRole || kind != 1)) {
            this.modifiers |= 8;
        }
    }

    public void updatePredicateExpression(Expression expression, int newDeclarationSourceEnd) {
        int s = expression.sourceStart;
        int e = expression.sourceEnd;
        AstGenerator gen = new AstGenerator(s, e);
        this.returnStatement = new ReturnStatement(expression, s, e);
        this.statements = new Statement[]{this.tryCatch(this.returnStatement, gen.qualifiedTypeReference(JAVA_LANG_THROWABLE), gen.returnStatement(gen.booleanLiteral(false)))};
        this.hasParsedStatements = true;
        this.bodyStart = s;
        this.bodyEnd = e;
        this.declarationSourceEnd = newDeclarationSourceEnd;
    }

    protected void linkPredicates() {
        if ((this.modifiers & 0x400) == 0) {
            PredicateGenerator.linkPredicates(this);
        }
    }

    public boolean isBasePredicate() {
        return this.isBasePredicate;
    }

    public Expression expression() {
        if (this.returnStatement == null) {
            return null;
        }
        return this.returnStatement.expression;
    }

    public boolean handleMissingSignature(String[] problemArguments, int start, int end) {
        if (this.scope == null) {
            return false;
        }
        TypeDeclaration enclosingType = this.scope.referenceType();
        if (enclosingType.callinCallouts == null) {
            return false;
        }
        AbstractMethodMappingDeclaration[] abstractMethodMappingDeclarationArray = enclosingType.callinCallouts;
        int n = enclosingType.callinCallouts.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractMethodMappingDeclaration mapping = abstractMethodMappingDeclarationArray[n2];
            if (mapping.isCallin() && !mapping.hasSignature) {
                this.scope.problemReporter().predicateHasNoArguments(problemArguments, start, end);
                return true;
            }
            ++n2;
        }
        return false;
    }

    Statement tryCatch(Statement tryStatement, TypeReference exceptionType, Statement catchStatement) {
        TryStatement result = new TryStatement(){

            protected ExceptionHandlingFlowContext createFlowContext(FlowContext flowContext, FlowInfo flowInfo) {
                return new ExceptionHandlingFlowContext(flowContext, this, Binding.NO_EXCEPTIONS, new int[0], null, this.scope, flowInfo){

                    public UnconditionalFlowInfo initsOnException(int index) {
                        return new UnconditionalFlowInfo();
                    }
                };
            }
        };
        result.sourceStart = this.sourceStart;
        result.sourceEnd = this.sourceEnd;
        AstGenerator gen = new AstGenerator(this.sourceStart, this.sourceEnd);
        result.tryBlock = gen.block(new Statement[]{tryStatement});
        result.catchArguments = new Argument[]{gen.argument("exc".toCharArray(), exceptionType)};
        result.catchBlocks = new Block[]{gen.block(new Statement[]{catchStatement})};
        return result;
    }

    public void resolveStatements() {
        if (this.returnStatement != null) {
            this.returnStatement.traverse(new BaseScopeMarker(), this.scope);
        }
        super.resolveStatements();
    }

    public StringBuffer printBody(int indent, StringBuffer output) {
        output.append(" {\n");
        this.returnStatement.printStatement(indent, output);
        output.append('\n');
        GuardPredicateDeclaration.printIndent(indent == 0 ? 0 : indent - 1, output).append('}');
        return output;
    }
}

