/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core.compiler.lookup;

import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.ITeamAnchor;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.TeamAnchor;

public class ProblemAnchorBinding
extends TeamAnchor {
    TeamAnchor closestMatch;
    int problemId;

    public ProblemAnchorBinding(TeamAnchor closestMatch, int problemId) {
        this.closestMatch = closestMatch;
        this.problemId = problemId;
    }

    @Override
    protected TeamAnchor getClone() {
        return new ProblemAnchorBinding(this.closestMatch, this.problemId);
    }

    @Override
    public int kind() {
        return this.closestMatch.kind();
    }

    @Override
    public char[] readableName() {
        return this.closestMatch.readableName();
    }

    @Override
    public char[] internalName() {
        return this.closestMatch.internalName();
    }

    @Override
    public boolean isBaseAnchor() {
        return this.closestMatch.isBaseAnchor();
    }

    @Override
    public boolean isFinal() {
        return this.closestMatch.isFinal();
    }

    @Override
    public int problemId() {
        return this.problemId;
    }

    public static boolean checkAnchor(Scope scope, ASTNode location, ITeamAnchor anchor, char[] typeName) {
        if (anchor == null) {
            return false;
        }
        if (!anchor.isValidBinding()) {
            switch (anchor.problemId()) {
                case 27: {
                    scope.problemReporter().anchorPathNotFinal(location, anchor, typeName);
                    break;
                }
                case 1: {
                    break;
                }
                default: {
                    scope.problemReporter().missingImplementation(location, "Unexpected type anchor problem " + anchor.problemId());
                }
            }
            return false;
        }
        return true;
    }
}

