/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core.compiler.statemachine.transformer;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.objectteams.otdt.core.compiler.IOTConstants;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.AbstractMethodMappingDeclaration;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.CallinMappingDeclaration;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.ParameterMapping;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.ResultReference;
import org.eclipse.objectteams.otdt.internal.core.compiler.statemachine.transformer.StackTransformStatementsVisitor;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.AstGenerator;

public class ReplaceResultReferenceVisitor
extends StackTransformStatementsVisitor
implements IOTConstants {
    private final AbstractMethodMappingDeclaration _methodMapping;
    private int _bindingDirection = 0;

    public ReplaceResultReferenceVisitor(AbstractMethodMappingDeclaration mapping) {
        this._methodMapping = mapping;
    }

    @Override
    public boolean visit(ParameterMapping mapping, BlockScope scope) {
        this._bindingDirection = mapping.direction;
        return true;
    }

    @Override
    public void endVisit(ParameterMapping mapping, BlockScope scope) {
        this._bindingDirection = 0;
        super.endVisit(mapping, scope);
    }

    @Override
    public boolean visit(SingleNameReference ref, BlockScope scope) {
        if (CharOperation.equals(ref.token, IOTConstants.RESULT)) {
            boolean isResultDir = false;
            if (this._methodMapping.isCallin()) {
                boolean bl = isResultDir = this._bindingDirection == 75;
                if (!isResultDir && ((CallinMappingDeclaration)this._methodMapping).callinModifier == 132) {
                    isResultDir = true;
                }
            } else {
                boolean bl = isResultDir = this._bindingDirection == 76;
            }
            if (isResultDir) {
                AstGenerator gen = new AstGenerator(ref.sourceStart, ref.sourceEnd);
                ResultReference resultRef = gen.resultReference(ref, this._methodMapping);
                this.enterExpression(ref, resultRef, ref);
            } else {
                scope.problemReporter().illegalDirectionForResult(ref, this._methodMapping.isCallout());
                return false;
            }
        }
        return true;
    }
}

