/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.predicates.provider;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.oomph.predicates.FilePredicate;
import org.eclipse.oomph.predicates.PredicatesPackage;
import org.eclipse.oomph.predicates.provider.Messages;
import org.eclipse.oomph.predicates.provider.PredicateItemProvider;
import org.eclipse.osgi.util.NLS;

public class FilePredicateItemProvider
extends PredicateItemProvider {
    public FilePredicateItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    @Override
    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addFilePatternPropertyDescriptor(object);
            this.addContentPatternPropertyDescriptor(object);
        }
        return this.itemPropertyDescriptors;
    }

    protected void addFilePatternPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_FilePredicate_filePattern_feature"), this.getString("_UI_FilePredicate_filePattern_description"), (EStructuralFeature)PredicatesPackage.Literals.FILE_PREDICATE__FILE_PATTERN, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addContentPatternPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_FilePredicate_contentPattern_feature"), this.getString("_UI_FilePredicate_contentPattern_description"), (EStructuralFeature)PredicatesPackage.Literals.FILE_PREDICATE__CONTENT_PATTERN, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    public Object getImage(Object object) {
        return this.overlayImage(object, this.getResourceLocator().getImage("full/obj16/FilePredicate"));
    }

    @Override
    protected boolean shouldComposeCreationImage() {
        return true;
    }

    @Override
    public String getText(Object object) {
        FilePredicate filePredicate = (FilePredicate)object;
        String label = filePredicate.getFilePattern();
        if (label == null || label.length() == 0) {
            return this.getString("_UI_FilePredicate_type");
        }
        label = NLS.bind((String)Messages.FilePredicateItemProvider_FileAt_label, (Object)label);
        String contentPattern = filePredicate.getContentPattern();
        if (contentPattern != null) {
            label = String.valueOf(label) + " " + NLS.bind((String)Messages.FilePredicateItemProvider_ContentLike_label, (Object)contentPattern);
        }
        return label;
    }

    @Override
    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(FilePredicate.class)) {
            case 1: 
            case 2: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), false, true));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    @Override
    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
    }
}

