/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.targlets.internal.core;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.BasicExtendedMetaData;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.emf.ecore.xmi.impl.XMLOptionsImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceImpl;
import org.eclipse.emf.ecore.xml.type.AnyType;
import org.eclipse.emf.ecore.xml.type.XMLTypeFactory;
import org.eclipse.equinox.internal.p2.engine.DownloadManager;
import org.eclipse.equinox.internal.p2.engine.InstallableUnitOperand;
import org.eclipse.equinox.internal.p2.engine.InstallableUnitPhase;
import org.eclipse.equinox.internal.p2.engine.Phase;
import org.eclipse.equinox.internal.p2.engine.PhaseSet;
import org.eclipse.equinox.internal.p2.engine.phases.Collect;
import org.eclipse.equinox.internal.p2.engine.phases.Install;
import org.eclipse.equinox.internal.p2.engine.phases.Property;
import org.eclipse.equinox.internal.p2.engine.phases.Uninstall;
import org.eclipse.equinox.internal.p2.metadata.IRequiredCapability;
import org.eclipse.equinox.internal.p2.metadata.InstallableUnit;
import org.eclipse.equinox.internal.p2.metadata.ResolvedInstallableUnit;
import org.eclipse.equinox.internal.p2.metadata.expression.LDAPFilter;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.engine.IPhaseSet;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.engine.ProvisioningContext;
import org.eclipse.equinox.p2.engine.spi.ProvisioningAction;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IInstallableUnitFragment;
import org.eclipse.equinox.p2.metadata.IInstallableUnitPatch;
import org.eclipse.equinox.p2.metadata.ILicense;
import org.eclipse.equinox.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.IRequirementChange;
import org.eclipse.equinox.p2.metadata.ITouchpointData;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.metadata.expression.ExpressionUtil;
import org.eclipse.equinox.p2.metadata.expression.IExpression;
import org.eclipse.equinox.p2.metadata.expression.IFilterExpression;
import org.eclipse.equinox.p2.metadata.expression.IMatchExpression;
import org.eclipse.equinox.p2.planner.IProfileChangeRequest;
import org.eclipse.equinox.p2.query.CollectionResult;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRequest;
import org.eclipse.equinox.p2.repository.artifact.IFileArtifactRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.spi.p2.publisher.PublisherHelper;
import org.eclipse.oomph.p2.P2Factory;
import org.eclipse.oomph.p2.Repository;
import org.eclipse.oomph.p2.Requirement;
import org.eclipse.oomph.p2.VersionSegment;
import org.eclipse.oomph.p2.core.BundlePool;
import org.eclipse.oomph.p2.core.P2Util;
import org.eclipse.oomph.p2.core.Profile;
import org.eclipse.oomph.p2.core.ProfileTransaction;
import org.eclipse.oomph.p2.internal.core.CacheUsageConfirmer;
import org.eclipse.oomph.p2.internal.core.CachingRepositoryManager;
import org.eclipse.oomph.resources.SourceLocator;
import org.eclipse.oomph.targlets.DropinLocation;
import org.eclipse.oomph.targlets.IUGenerator;
import org.eclipse.oomph.targlets.Targlet;
import org.eclipse.oomph.targlets.TargletFactory;
import org.eclipse.oomph.targlets.core.ITargletContainer;
import org.eclipse.oomph.targlets.core.ITargletContainerDescriptor;
import org.eclipse.oomph.targlets.core.TargletContainerEvent;
import org.eclipse.oomph.targlets.core.WorkspaceIUInfo;
import org.eclipse.oomph.targlets.internal.core.TargletContainerDescriptor;
import org.eclipse.oomph.targlets.internal.core.TargletContainerDescriptorManager;
import org.eclipse.oomph.targlets.internal.core.TargletContainerListenerRegistry;
import org.eclipse.oomph.targlets.internal.core.TargletsCorePlugin;
import org.eclipse.oomph.targlets.internal.core.WorkspaceIUAnalyzer;
import org.eclipse.oomph.util.HexUtil;
import org.eclipse.oomph.util.IOUtil;
import org.eclipse.oomph.util.ObjectUtil;
import org.eclipse.oomph.util.ReflectUtil;
import org.eclipse.oomph.util.StringUtil;
import org.eclipse.oomph.util.SubMonitor;
import org.eclipse.oomph.util.pde.TargetPlatformRunnable;
import org.eclipse.oomph.util.pde.TargetPlatformUtil;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.core.target.ITargetLocation;
import org.eclipse.pde.core.target.ITargetLocationFactory;
import org.eclipse.pde.core.target.ITargetPlatformService;
import org.eclipse.pde.core.target.TargetBundle;
import org.eclipse.pde.core.target.TargetFeature;
import org.eclipse.pde.internal.core.target.AbstractBundleContainer;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TargletContainer
extends AbstractBundleContainer
implements ITargletContainer {
    public static final String TYPE = "Targlet";
    public static final String IU_PROPERTY_SOURCE = "org.eclipse.oomph.targlet.source";
    private static final ThreadLocal<Boolean> FORCE_UPDATE = new ThreadLocal();
    private static final ThreadLocal<Boolean> MIRRORS = new ThreadLocal();
    private static final String A_PDE_TARGET_PLATFORM = "A.PDE.Target.Platform";
    private static final String A_PDE_TARGET_PLATFORM_LOWER_CASE = "A.PDE.Target.Platform".toLowerCase();
    private static final String FOLLOW_ARTIFACT_REPOSITORY_REFERENCES = "org.eclipse.equinox.p2.director.followArtifactRepositoryReferences";
    private static final byte[] BUFFER = new byte[8192];
    private static final String PROP_ARCH = "osgi.arch";
    private static final String PROP_OS = "osgi.os";
    private static final String PROP_WS = "osgi.ws";
    private String id;
    private ITargetDefinition targetDefinition;
    private final EList<Targlet> targlets = new BasicEList();

    public TargletContainer(String id) {
        this.id = id;
        try {
            CommonPlugin.loadClass((String)"org.eclipse.oomph.targlets.ui", (String)"org.eclipse.oomph.targlets.internal.ui.TargletsUIPlugin");
        }
        catch (Throwable throwable) {}
    }

    private TargletContainer(String id, Collection<? extends Targlet> targlets) {
        this(id);
        this.basicSetTarglets(targlets);
    }

    protected int getResolveBundlesWork() {
        return 999;
    }

    protected int getResolveFeaturesWork() {
        return 1;
    }

    public boolean isContentEqual(AbstractBundleContainer container) {
        if (container instanceof TargletContainer) {
            TargletContainer targletContainer = (TargletContainer)container;
            if (this.targlets.size() != targletContainer.targlets.size()) {
                return false;
            }
            for (Targlet targlet : targletContainer.targlets) {
                Targlet existingTarglet = this.getTarglet(targlet.getName());
                if (existingTarglet != null && EcoreUtil.equals((EObject)existingTarglet, (EObject)targlet)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public String getID() {
        return this.id;
    }

    @Override
    public void setID(String newID) throws CoreException {
        if (!ObjectUtil.equals((Object)newID, (Object)this.id)) {
            String oldID = this.id;
            this.id = newID;
            TargletContainerDescriptor descriptor = this.updateTargetDefinition();
            TargletContainerEvent.IDChangedEvent event = new TargletContainerEvent.IDChangedEvent(this, descriptor, oldID);
            TargletContainerListenerRegistry.INSTANCE.notifyListeners(event, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    private TargletContainerDescriptor updateTargetDefinition() throws CoreException {
        this.clearResolutionStatus();
        TargletContainerDescriptor descriptor = this.getDescriptor();
        if (descriptor != null) {
            descriptor.resetUpdateProblem();
        }
        if (this.targetDefinition != null) {
            TargetPlatformUtil.runWithTargetPlatformService((TargetPlatformRunnable)new TargetPlatformRunnable<Object>(){

                public Object run(ITargetPlatformService service) throws CoreException {
                    service.saveTargetDefinition(TargletContainer.this.targetDefinition);
                    return null;
                }
            });
        }
        return descriptor;
    }

    public String getType() {
        return TYPE;
    }

    @Override
    public TargletContainerDescriptor getDescriptor() {
        try {
            TargletContainerDescriptorManager manager = TargletContainerDescriptorManager.getInstance();
            return manager.getDescriptor(this.id, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception ex) {
            TargletsCorePlugin.INSTANCE.log(ex);
            return null;
        }
    }

    @Override
    public ITargetDefinition getTargetDefinition() {
        return this.targetDefinition;
    }

    @Override
    public Targlet getTarglet(String name) {
        int index = this.getTargletIndex(name);
        if (index != -1) {
            return TargletFactory.eINSTANCE.copyTarglet((Targlet)this.targlets.get(index));
        }
        return null;
    }

    @Override
    public int getTargletIndex(String name) {
        int i = 0;
        while (i < this.targlets.size()) {
            Targlet targlet = (Targlet)this.targlets.get(i);
            if (ObjectUtil.equals((Object)targlet.getName(), (Object)name)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public boolean hasTarglet(String name) {
        return this.getTargletIndex(name) != -1;
    }

    @Override
    public EList<Targlet> getTarglets() {
        return TargletFactory.eINSTANCE.copyTarglets(this.targlets);
    }

    @Override
    public void setTarglets(Collection<? extends Targlet> targlets) throws CoreException {
        this.basicSetTarglets(targlets);
        TargletContainerDescriptor descriptor = this.updateTargetDefinition();
        TargletContainerEvent.TargletsChangedEvent event = new TargletContainerEvent.TargletsChangedEvent(this, descriptor);
        TargletContainerListenerRegistry.INSTANCE.notifyListeners(event, (IProgressMonitor)new NullProgressMonitor());
    }

    private void basicSetTarglets(Collection<? extends Targlet> targlets) {
        HashSet<String> names = new HashSet<String>();
        for (Targlet targlet : targlets) {
            String name = targlet.getName();
            if (names.add(name)) continue;
            throw new IllegalArgumentException("Duplicate targlet name: " + name);
        }
        this.targlets.clear();
        this.targlets.addAll((Collection)TargletFactory.eINSTANCE.copyTarglets(targlets));
    }

    public String serialize() {
        try {
            return Persistence.toXML(this.id, this.targlets).toString();
        }
        catch (Exception ex) {
            TargletsCorePlugin.INSTANCE.log(ex);
            return null;
        }
    }

    @Override
    public boolean isIncludeSources() {
        for (Targlet targlet : this.targlets) {
            if (!targlet.isIncludeSources()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isIncludeAllPlatforms() {
        for (Targlet targlet : this.targlets) {
            if (!targlet.isIncludeAllPlatforms()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isIncludeAllRequirements() {
        for (Targlet targlet : this.targlets) {
            if (targlet.isIncludeAllRequirements()) continue;
            return false;
        }
        return true;
    }

    @Override
    public String getEnvironmentProperties() {
        StringBuilder builder = new StringBuilder();
        String ws = this.targetDefinition.getWS();
        if (ws == null) {
            ws = Platform.getWS();
        }
        builder.append(PROP_WS);
        builder.append("=");
        builder.append(ws);
        builder.append(",");
        String os = this.targetDefinition.getOS();
        if (os == null) {
            os = Platform.getOS();
        }
        builder.append(PROP_OS);
        builder.append("=");
        builder.append(os);
        builder.append(",");
        String arch = this.targetDefinition.getArch();
        if (arch == null) {
            arch = Platform.getOSArch();
        }
        builder.append(PROP_ARCH);
        builder.append("=");
        builder.append(arch);
        builder.append(",org.eclipse.swt.buildtime=true");
        return builder.toString();
    }

    @Override
    public String getNLProperty() {
        String nl = this.targetDefinition.getNL();
        if (nl == null) {
            nl = Platform.getNL();
        }
        return nl;
    }

    public String toString() {
        return "Targlet Container " + this.id;
    }

    public String getLocation(boolean resolve) throws CoreException {
        TargletContainerDescriptorManager manager = TargletContainerDescriptorManager.getInstance();
        TargletContainerDescriptor descriptor = manager.getDescriptor(this.id, (IProgressMonitor)new NullProgressMonitor());
        return descriptor.getInstallLocation().getAbsolutePath();
    }

    @Override
    public String getDigest() {
        String environmentProperties = this.getEnvironmentProperties();
        String nlProperty = this.getNLProperty();
        return TargletContainer.createDigest(this.id, environmentProperties, nlProperty, this.targlets);
    }

    protected void associateWithTarget(ITargetDefinition target) {
        super.associateWithTarget(target);
        this.targetDefinition = target;
    }

    protected TargetBundle[] resolveBundles(ITargetDefinition target, IProgressMonitor monitor) throws CoreException {
        this.resolveUnits(monitor);
        return this.fBundles;
    }

    protected TargetFeature[] resolveFeatures(ITargetDefinition target, IProgressMonitor monitor) throws CoreException {
        return this.fFeatures;
    }

    /*
     * Unable to fully structure code
     */
    private void resolveUnits(IProgressMonitor monitor) throws CoreException {
        try {
            progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100).detectCancelation();
            manager = TargletContainerDescriptorManager.getInstance();
            environmentProperties = this.getEnvironmentProperties();
            nlProperty = this.getNLProperty();
            digest = TargletContainer.createDigest(this.id, environmentProperties, nlProperty, this.targlets);
            descriptor = manager.getDescriptor(this.id, (IProgressMonitor)progress.newChild(4));
            progress.childDone();
            isDisplayThread = TargletContainer.isDisplayThread();
            profile = descriptor.getWorkingProfile();
            if (profile == null || !descriptor.getWorkingDigest().equals(digest) && !isDisplayThread && descriptor.getUpdateProblem() == null || TargletContainer.FORCE_UPDATE.get() == Boolean.TRUE) {
                try {
                    if (isDisplayThread) {
                        throw new CoreException(Status.CANCEL_STATUS);
                    }
                    newProfile = this.updateProfile(environmentProperties, nlProperty, digest, (IProgressMonitor)progress.newChild(86));
                    if (newProfile == null) ** GOTO lbl25
                    if (profile != null && !profile.getProfileId().equals(newProfile.getProfileId())) {
                        profile.delete();
                    }
                    profile = newProfile;
                }
                catch (CoreException ex) {
                    if (profile != null) ** GOTO lbl25
                    throw ex;
                }
            } else {
                progress.skipped(86);
            }
lbl25:
            // 4 sources

            this.generateUnits(descriptor, (IProfile)profile, (IProgressMonitor)progress.newChild(10));
            progress.done();
        }
        catch (Throwable t) {
            TargletsCorePlugin.INSTANCE.coreException(t);
        }
    }

    private void generateUnits(TargletContainerDescriptor descriptor, IProfile profile, IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100).detectCancelation();
        ArrayList<TargetBundle> bundles = new ArrayList<TargetBundle>();
        ArrayList<TargetFeature> features = new ArrayList<TargetFeature>();
        if (profile != null) {
            IQueryResult result = profile.query(QueryUtil.createIUAnyQuery(), (IProgressMonitor)progress.newChild(2));
            this.generateUnits(descriptor, result.toUnmodifiableSet(), bundles, features, (IProgressMonitor)progress.newChild(98));
        }
        for (Targlet targlet : this.targlets) {
            for (DropinLocation dropinLocation : targlet.getDropinLocations()) {
                this.analyzeDropinLocation(dropinLocation, bundles, features);
            }
        }
        this.fBundles = bundles.toArray(new TargetBundle[bundles.size()]);
        this.fFeatures = features.toArray(new TargetFeature[features.size()]);
        progress.done();
    }

    private void generateUnits(TargletContainerDescriptor descriptor, Set<IInstallableUnit> units, List<TargetBundle> bundles, List<TargetFeature> features, IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)units.size()).detectCancelation();
        IFileArtifactRepository cache = descriptor.getBundlePool().getFileArtifactRepository();
        for (IInstallableUnit unit : units) {
            if (TargletContainer.isOSGiBundle(unit)) {
                this.generateBundle(unit, cache, bundles);
            } else if (TargletContainer.isFeatureJar(unit)) {
                this.generateFeature(unit, cache, features);
            }
            progress.worked();
        }
        progress.done();
    }

    private void generateBundle(IInstallableUnit unit, IFileArtifactRepository repo, List<TargetBundle> bundles) throws CoreException {
        Collection artifacts = unit.getArtifacts();
        Iterator it = artifacts.iterator();
        while (it.hasNext()) {
            File file = repo.getArtifactFile((IArtifactKey)it.next());
            if (file == null) continue;
            this.addTargetBundle(file, bundles);
        }
    }

    private void generateFeature(IInstallableUnit unit, IFileArtifactRepository repo, List<TargetFeature> features) throws CoreException {
        Collection artifacts = unit.getArtifacts();
        Iterator it = artifacts.iterator();
        while (it.hasNext()) {
            File file = repo.getArtifactFile((IArtifactKey)it.next());
            if (file == null) continue;
            this.addTargetFeature(file, features);
        }
    }

    private void analyzeDropinLocation(DropinLocation dropinLocation, List<TargetBundle> bundles, List<TargetFeature> features) {
        File folder;
        String rootFolder = dropinLocation.getRootFolder();
        if (!StringUtil.isEmpty((String)rootFolder) && (folder = new File(rootFolder)).isDirectory()) {
            this.analyzeDropinLocation(folder, dropinLocation.isRecursive(), bundles, features);
        }
    }

    private void analyzeDropinLocation(File folder, boolean recursive, List<TargetBundle> bundles, List<TargetFeature> features) {
        File[] files = folder.listFiles();
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                block19: {
                    File file = fileArray[n2];
                    JarFile jarFile = null;
                    try {
                        try {
                            if (file.isFile()) {
                                if (file.getName().endsWith(".jar")) {
                                    jarFile = new JarFile(file);
                                    if (jarFile.getJarEntry("feature.xml") != null) {
                                        this.addTargetFeature(file, features);
                                    } else if (jarFile.getJarEntry("META-INF/MANIFEST.MF") != null) {
                                        this.addTargetBundle(file, bundles);
                                    }
                                }
                            } else if (file.isDirectory()) {
                                if (new File(file, "feature.xml").isFile()) {
                                    this.addTargetFeature(file, features);
                                } else if (new File(file, "META-INF/MANIFEST.MF").isFile()) {
                                    this.addTargetBundle(file, bundles);
                                } else if (recursive) {
                                    this.analyzeDropinLocation(file, true, bundles, features);
                                }
                            }
                        }
                        catch (Exception ex) {
                            TargletsCorePlugin.INSTANCE.log(ex, 2);
                            IOUtil.close(jarFile);
                            break block19;
                        }
                    }
                    catch (Throwable throwable) {
                        IOUtil.close(jarFile);
                        throw throwable;
                    }
                    IOUtil.close(jarFile);
                }
                ++n2;
            }
        }
    }

    private void addTargetBundle(File file, List<TargetBundle> bundles) throws CoreException {
        TargetBundle bundle = new TargetBundle(file);
        bundles.add(bundle);
    }

    private void addTargetFeature(File file, List<TargetFeature> features) throws CoreException {
        TargetFeature feature = new TargetFeature(file);
        features.add(feature);
    }

    @Override
    public void forceUpdate(boolean activateTargetDefinition, boolean mirrors, IProgressMonitor monitor) throws CoreException {
        try {
            FORCE_UPDATE.set(Boolean.TRUE);
            MIRRORS.set(mirrors ? Boolean.TRUE : false);
            ITargetLocation[] iTargetLocationArray = this.targetDefinition.getTargetLocations();
            int n = iTargetLocationArray.length;
            int n2 = 0;
            while (n2 < n) {
                ITargetLocation targetLocation = iTargetLocationArray[n2];
                if (targetLocation instanceof ITargletContainer) {
                    TargletContainer targletContainer = (TargletContainer)targetLocation;
                    targletContainer.clearResolutionStatus();
                }
                ++n2;
            }
            if (activateTargetDefinition || TargetPlatformUtil.isActiveTargetDefinition((ITargetDefinition)this.targetDefinition)) {
                TargetPlatformUtil.activateTargetDefinition((ITargetDefinition)this.targetDefinition, (IProgressMonitor)monitor);
            } else {
                this.targetDefinition.resolve(monitor);
            }
            TargletContainerDescriptorManager manager = TargletContainerDescriptorManager.getInstance();
            TargletContainerDescriptor descriptor = manager.getDescriptor(this.id, monitor);
            ITargletContainerDescriptor.UpdateProblem updateProblem = descriptor.getUpdateProblem();
            if (updateProblem != null) {
                TargletsCorePlugin.INSTANCE.coreException(new CoreException((IStatus)updateProblem));
            }
        }
        finally {
            MIRRORS.remove();
            FORCE_UPDATE.remove();
        }
    }

    @Override
    public IStatus updateProfile(IProgressMonitor monitor) {
        try {
            String environmentProperties = this.getEnvironmentProperties();
            String nlProperty = this.getNLProperty();
            String digest = TargletContainer.createDigest(this.id, environmentProperties, nlProperty, this.targlets);
            this.updateProfile(environmentProperties, nlProperty, digest, monitor);
            return Status.OK_STATUS;
        }
        catch (CoreException ex) {
            return ex.getStatus();
        }
    }

    /*
     * Unable to fully structure code
     */
    private Profile updateProfile(String environmentProperties, String nlProperty, String digest, IProgressMonitor monitor) throws CoreException {
        block18: {
            progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100).detectCancelation();
            manager = TargletContainerDescriptorManager.getInstance();
            descriptor = manager.getDescriptor(this.id, (IProgressMonitor)progress.newChild());
            profile = descriptor.startUpdateTransaction(environmentProperties, nlProperty, digest, (IProgressMonitor)progress.newChild());
            transaction = profile.change().setRemoveExistingInstallableUnits(true);
            transaction.setMirrors(TargletContainer.MIRRORS.get() == Boolean.TRUE);
            provisioningAgent = profile.getAgent().getProvisioningAgent();
            cacheUsageConfirmer = TargletsCorePlugin.INSTANCE.getCacheUsageConfirmer();
            oldCacheUsageConfirmer = (CacheUsageConfirmer)provisioningAgent.getService(CacheUsageConfirmer.SERVICE_NAME);
            garbageCollectorPreferences = ConfigurationScope.INSTANCE.getNode("org.eclipse.equinox.p2.garbagecollector");
            oldGCEnabled = garbageCollectorPreferences.get("gc_enabled", null);
            garbageCollectorPreferences.putBoolean("gc_enabled", false);
            originalBetterMirrorSelection = CachingRepositoryManager.enableBetterMirrorSelection();
            if (cacheUsageConfirmer != null) {
                provisioningAgent.registerService(CacheUsageConfirmer.SERVICE_NAME, (Object)cacheUsageConfirmer);
            }
            profileDefinition = transaction.getProfileDefinition();
            profileDefinition.setIncludeSourceBundles(this.isIncludeSources());
            rootRequirements = profileDefinition.getRequirements();
            rootRequirements.clear();
            repositories = profileDefinition.getRepositories();
            repositories.clear();
            workspaceIUAnalyzer = this.analyzeWorkspaceIUs((EList<Requirement>)rootRequirements, (EList<Repository>)repositories, progress);
            if (!rootRequirements.isEmpty()) break block18;
            descriptor.rollbackUpdateTransaction(null, (IProgressMonitor)new NullProgressMonitor());
            CachingRepositoryManager.setBetterMirrorSelection((boolean)originalBetterMirrorSelection);
            if (oldGCEnabled == null) {
                garbageCollectorPreferences.remove("gc_enabled");
            } else {
                garbageCollectorPreferences.put("gc_enabled", oldGCEnabled);
            }
            if (cacheUsageConfirmer != null && oldCacheUsageConfirmer != null) {
                provisioningAgent.registerService(CacheUsageConfirmer.SERVICE_NAME, (Object)oldCacheUsageConfirmer);
            }
            return null;
        }
        try {
            try {
                commitContext = new TargletCommitContext(profile, workspaceIUAnalyzer, this.isIncludeAllPlatforms(), this.isIncludeAllRequirements());
                transaction.commit((ProfileTransaction.CommitContext)commitContext, (IProgressMonitor)progress.newChild());
                requiredProjects = TargletContainer.getRequiredProjects((IProfile)profile, workspaceIUAnalyzer.getWorkspaceIUInfos(), (IProgressMonitor)progress.newChild());
                descriptor.commitUpdateTransaction(digest, requiredProjects.values(), (IProgressMonitor)progress.newChild());
                event = new TargletContainerEvent.ProfileUpdateSucceededEvent(this, descriptor, profile, commitContext.getArtificialRoot(), commitContext.getMetadataRepositories(), commitContext.getProvisioningPlan(), requiredProjects);
                TargletContainerListenerRegistry.INSTANCE.notifyListeners(event, (IProgressMonitor)progress.newChild());
                monitor.subTask("Targlet container profile update completed");
            }
            catch (Throwable t) {
                descriptor.rollbackUpdateTransaction(t, (IProgressMonitor)new NullProgressMonitor());
                updateProblem = descriptor.getUpdateProblem();
                if (updateProblem != null) {
                    event = new TargletContainerEvent.ProfileUpdateFailedEvent(this, descriptor, updateProblem);
                    TargletContainerListenerRegistry.INSTANCE.notifyListeners(event, (IProgressMonitor)new NullProgressMonitor());
                }
                TargletsCorePlugin.INSTANCE.coreException(t);
                CachingRepositoryManager.setBetterMirrorSelection((boolean)originalBetterMirrorSelection);
                if (oldGCEnabled == null) {
                    garbageCollectorPreferences.remove("gc_enabled");
                } else {
                    garbageCollectorPreferences.put("gc_enabled", oldGCEnabled);
                }
                if (cacheUsageConfirmer == null || oldCacheUsageConfirmer == null) ** GOTO lbl79
                provisioningAgent.registerService(CacheUsageConfirmer.SERVICE_NAME, (Object)oldCacheUsageConfirmer);
            }
        }
        catch (Throwable var23_24) {
            CachingRepositoryManager.setBetterMirrorSelection((boolean)originalBetterMirrorSelection);
            if (oldGCEnabled == null) {
                garbageCollectorPreferences.remove("gc_enabled");
            } else {
                garbageCollectorPreferences.put("gc_enabled", oldGCEnabled);
            }
            if (cacheUsageConfirmer != null && oldCacheUsageConfirmer != null) {
                provisioningAgent.registerService(CacheUsageConfirmer.SERVICE_NAME, (Object)oldCacheUsageConfirmer);
            }
            throw var23_24;
        }
        CachingRepositoryManager.setBetterMirrorSelection((boolean)originalBetterMirrorSelection);
        if (oldGCEnabled == null) {
            garbageCollectorPreferences.remove("gc_enabled");
        } else {
            garbageCollectorPreferences.put("gc_enabled", oldGCEnabled);
        }
        if (cacheUsageConfirmer != null && oldCacheUsageConfirmer != null) {
            provisioningAgent.registerService(CacheUsageConfirmer.SERVICE_NAME, (Object)oldCacheUsageConfirmer);
        }
lbl79:
        // 5 sources

        progress.done();
        return profile;
    }

    private WorkspaceIUAnalyzer analyzeWorkspaceIUs(EList<Requirement> rootRequirements, EList<Repository> repositories, SubMonitor progress) throws CoreException {
        WorkspaceIUAnalyzer workspaceIUAnalyzer = new WorkspaceIUAnalyzer();
        for (Targlet targlet : this.targlets) {
            EList<IUGenerator> effectiveIUGenerators = TargletContainer.effectiveIUGenerators(targlet);
            BasicEList ius = new BasicEList();
            for (SourceLocator sourceLocator : targlet.getSourceLocators()) {
                ius.addAll(workspaceIUAnalyzer.analyze(sourceLocator, effectiveIUGenerators, (IProgressMonitor)progress.newChild()));
            }
            for (Requirement requirement : EcoreUtil.copyAll((Collection)targlet.getRequirements())) {
                String namespace = requirement.getNamespace();
                String name = requirement.getName();
                if (StringUtil.isEmpty((String)namespace) || StringUtil.isEmpty((String)name) || requirement.getVersionRange() == null) continue;
                if ("*".equals(name) && "org.eclipse.equinox.p2.iu".equals(namespace)) {
                    Map<IInstallableUnit, WorkspaceIUInfo> workspaceIUInfos = workspaceIUAnalyzer.getWorkspaceIUInfos();
                    HashMap<WorkspaceIUInfo, IMatchExpression> filters = new HashMap<WorkspaceIUInfo, IMatchExpression>();
                    for (IInstallableUnit iu : ius) {
                        IMatchExpression filter = iu.getFilter();
                        if (filter == null) continue;
                        WorkspaceIUInfo workspaceIUInfo = workspaceIUInfos.get(iu);
                        filters.put(workspaceIUInfo, filter);
                    }
                    for (IInstallableUnit iu : ius) {
                        if ("true".equalsIgnoreCase(iu.getProperty("org.eclipse.equinox.p2.type.category"))) continue;
                        Requirement expandedRequirement = P2Factory.eINSTANCE.createRequirement(iu.getId(), requirement.getVersionRange(), requirement.isOptional(), requirement.isGreedy());
                        IMatchExpression filter = (IMatchExpression)filters.get(workspaceIUInfos.get(iu));
                        if (filter != null) {
                            expandedRequirement.setMatchExpression(filter);
                        }
                        rootRequirements.add((Object)expandedRequirement);
                    }
                    continue;
                }
                rootRequirements.add((Object)requirement);
            }
            for (Repository repository : EcoreUtil.copyAll((Collection)targlet.getActiveRepositories())) {
                if (StringUtil.isEmpty((String)repository.getURL())) continue;
                repositories.add((Object)repository);
            }
        }
        workspaceIUAnalyzer.adjustOmniRootRequirements(rootRequirements);
        IStatus status = workspaceIUAnalyzer.getStatus();
        TargletsCorePlugin.INSTANCE.coreException(status);
        return workspaceIUAnalyzer;
    }

    private static EList<IUGenerator> effectiveIUGenerators(Targlet targlet) {
        EList effectiveInstallableUnitGenerators = targlet.getInstallableUnitGenerators();
        if (effectiveInstallableUnitGenerators.isEmpty()) {
            effectiveInstallableUnitGenerators = IUGenerator.DEFAULTS;
        }
        return effectiveInstallableUnitGenerators;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String createDigest(String id, String environmentProperties, String nlProperty, EList<Targlet> targlets) {
        String string;
        FilterInputStream stream = null;
        try {
            Writer writer = Persistence.toXML(id, targlets);
            writer.write("\n<!-- Environment Properties: ");
            writer.write(environmentProperties);
            writer.write(" -->");
            writer.write("\n<!-- NL Property: ");
            writer.write(nlProperty);
            writer.write(" -->\n");
            final MessageDigest digest = MessageDigest.getInstance("SHA-1");
            stream = new FilterInputStream(new ByteArrayInputStream(writer.toString().getBytes("UTF-8"))){

                public int read() throws IOException {
                    int ch;
                    block4: while (true) {
                        ch = super.read();
                        switch (ch) {
                            case -1: {
                                return -1;
                            }
                            case 10: 
                            case 13: {
                                continue block4;
                            }
                        }
                        break;
                    }
                    digest.update((byte)ch);
                    return ch;
                }

                public int read(byte[] b, int off, int len) throws IOException {
                    int read = super.read(b, off, len);
                    if (read == -1) {
                        return -1;
                    }
                    int i = off;
                    while (i < off + read) {
                        byte c = b[i];
                        if (c == 10 || c == 13) {
                            if (i + 1 < off + read) {
                                System.arraycopy(b, i + 1, b, i, read - i - 1);
                                --i;
                            }
                            --read;
                        }
                        ++i;
                    }
                    digest.update(b, off, read);
                    return read;
                }
            };
            byte[] byArray = BUFFER;
            synchronized (BUFFER) {
                while (((InputStream)stream).read(BUFFER) != -1) {
                }
                // ** MonitorExit[var7_9] (shouldn't be in output)
                string = HexUtil.bytesToHex((byte[])digest.digest());
            }
        }
        catch (RuntimeException ex) {
            try {
                throw ex;
                catch (Exception ex2) {
                    throw new RuntimeException(ex2);
                }
            }
            catch (Throwable throwable) {
                IOUtil.close(stream);
                throw throwable;
            }
        }
        {
            IOUtil.close((Closeable)stream);
            return string;
        }
    }

    private static boolean isOSGiBundle(IInstallableUnit unit) {
        return TargletContainer.providesNamespace(unit, "osgi.bundle");
    }

    private static boolean isFeatureJar(IInstallableUnit unit) {
        return TargletContainer.providesNamespace(unit, "org.eclipse.update.feature");
    }

    private static boolean isDisplayThread() {
        try {
            Class displayClass = CommonPlugin.loadClass((String)"org.eclipse.swt", (String)"org.eclipse.swt.widgets.Display");
            Method getCurrentMethod = ReflectUtil.getMethod((Class)displayClass, (String)"getCurrent", (Class[])new Class[0]);
            return ReflectUtil.invokeMethod((Method)getCurrentMethod, null, (Object[])new Object[0]) != null;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private static boolean providesNamespace(IInstallableUnit unit, String namespace) {
        for (IProvidedCapability providedCapability : unit.getProvidedCapabilities()) {
            if (!namespace.equals(providedCapability.getNamespace())) continue;
            return true;
        }
        return false;
    }

    private static Map<IInstallableUnit, WorkspaceIUInfo> getRequiredProjects(IProfile profile, Map<IInstallableUnit, WorkspaceIUInfo> allProjects, IProgressMonitor monitor) {
        HashMap<WorkspaceIUInfo, IInstallableUnit> mainIUs = new HashMap<WorkspaceIUInfo, IInstallableUnit>();
        for (Map.Entry<IInstallableUnit, WorkspaceIUInfo> entry : allProjects.entrySet()) {
            IInstallableUnit iu = entry.getKey();
            if (!"true".equals(iu.getProperty("org.eclipse.oomph.targlet.workspace.main"))) continue;
            mainIUs.put(entry.getValue(), iu);
        }
        HashMap<IInstallableUnit, WorkspaceIUInfo> result = new HashMap<IInstallableUnit, WorkspaceIUInfo>();
        for (IInstallableUnit iu : P2Util.asIterable((IQueryResult)profile.query(QueryUtil.createIUAnyQuery(), monitor))) {
            IInstallableUnit mainIU;
            WorkspaceIUInfo info;
            if ("true".equals(iu.getProperty(IU_PROPERTY_SOURCE)) || (info = allProjects.get(iu)) == null || (mainIU = (IInstallableUnit)mainIUs.get(info)) == null) continue;
            result.put(mainIU, info);
        }
        return result;
    }

    /* synthetic */ TargletContainer(String string, Collection collection, TargletContainer targletContainer) {
        this(string, collection);
    }

    private static class IU {
        private final String id;
        private final Version version;

        public IU(IInstallableUnit iu) {
            this(iu.getId(), iu.getVersion());
        }

        public IU(String id, Version version) {
            this.id = id;
            this.version = P2Factory.eINSTANCE.createVersionRange(version, VersionSegment.MICRO).getMinimum();
        }

        public String getId() {
            return this.id;
        }

        public Version getVersion() {
            return this.version;
        }

        public int hashCode() {
            return this.id.hashCode();
        }

        public boolean equals(Object obj) {
            Version version;
            IU iu;
            return obj instanceof IU && this.id.equals((iu = (IU)obj).getId()) && (this.version.equals(version = iu.getVersion()) || Version.emptyVersion.equals(version) || Version.emptyVersion.equals(this.version));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Persistence
    implements ITargetLocationFactory {
        private static final Map<Object, Object> XML_OPTIONS;
        private static final BasicExtendedMetaData EXTENDED_META_DATA;
        private static final EStructuralFeature LOCATION_TYPE_FEATURE;
        private static final EStructuralFeature LOCATION_ID_FEATURE;
        private static final EStructuralFeature LOCATION_FEATURE;
        private static final EStructuralFeature TARGLET_FEATURE;
        private static final EClass DOCUMENT_ROOT_CLASS;

        static {
            EXTENDED_META_DATA = new BasicExtendedMetaData(){

                public EStructuralFeature getElement(EClass eClass, String namespace, String name) {
                    EStructuralFeature eStructuralFeature = super.getElement(eClass, namespace, name);
                    if (eStructuralFeature == null) {
                        eStructuralFeature = super.getElement(eClass, namespace, name.substring(0, name.length() - 1));
                    }
                    if (eStructuralFeature == null) {
                        eStructuralFeature = eClass.getEStructuralFeature(name);
                    }
                    return eStructuralFeature;
                }
            };
            LOCATION_TYPE_FEATURE = EXTENDED_META_DATA.demandFeature(null, "type", false);
            LOCATION_ID_FEATURE = EXTENDED_META_DATA.demandFeature(null, "id", false);
            LOCATION_FEATURE = EXTENDED_META_DATA.demandFeature(null, "location", true);
            TARGLET_FEATURE = EXTENDED_META_DATA.demandFeature(null, "targlet", true);
            DOCUMENT_ROOT_CLASS = LOCATION_FEATURE.getEContainingClass();
            XMLOptionsImpl xmlOptions = new XMLOptionsImpl();
            xmlOptions.setProcessAnyXML(true);
            xmlOptions.setProcessSchemaLocations(true);
            HashMap<String, Boolean> options = new HashMap<String, Boolean>();
            options.put("DECLARE_XML", Boolean.FALSE);
            options.put("EXTENDED_META_DATA", (Boolean)EXTENDED_META_DATA);
            options.put("LAX_FEATURE_PROCESSING", Boolean.TRUE);
            options.put("XML_OPTIONS", (Boolean)xmlOptions);
            XML_OPTIONS = Collections.unmodifiableMap(options);
        }

        public ITargletContainer getTargetLocation(String type, String serializedXML) throws CoreException {
            if (TargletContainer.TYPE.equals(type)) {
                return Persistence.fromXML(serializedXML);
            }
            return null;
        }

        public static ITargletContainer fromXML(String xml) throws CoreException {
            try {
                XMLResourceImpl resource = new XMLResourceImpl();
                resource.load(new InputSource(new StringReader(xml)), XML_OPTIONS);
                EObject documentRoot = (EObject)resource.getContents().get(0);
                AnyType location = (AnyType)documentRoot.eContents().get(0);
                String id = (String)location.eGet(LOCATION_ID_FEATURE);
                BasicEList targlets = new BasicEList();
                for (EObject eObject : location.eContents()) {
                    targlets.add((Object)((Targlet)eObject));
                }
                return new TargletContainer(id, (Collection)targlets, null);
            }
            catch (Exception ex) {
                TargletsCorePlugin.INSTANCE.coreException(ex);
                return null;
            }
        }

        public static Writer toXML(String id, List<Targlet> targlets) throws Exception {
            AnyType location = XMLTypeFactory.eINSTANCE.createAnyType();
            location.eSet(LOCATION_ID_FEATURE, (Object)id);
            location.eSet(LOCATION_TYPE_FEATURE, (Object)TargletContainer.TYPE);
            EObject documentRoot = EcoreUtil.create((EClass)DOCUMENT_ROOT_CLASS);
            documentRoot.eSet(LOCATION_FEATURE, (Object)location);
            FeatureMap targletFeatureMap = location.getAny();
            FeatureMapUtil.addText((FeatureMap)targletFeatureMap, (String)"\n  ");
            EList copy = TargletFactory.eINSTANCE.copyTarglets(targlets);
            for (Targlet targlet : copy) {
                targletFeatureMap.add(TARGLET_FEATURE, (Object)targlet);
            }
            StringWriter writer = new StringWriter();
            XMLResourceImpl resource = new XMLResourceImpl();
            resource.getContents().add((Object)documentRoot);
            resource.save((Writer)writer, XML_OPTIONS);
            return writer;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class TargletCommitContext
    extends ProfileTransaction.CommitContext {
        private static final Pattern OSGI_PROPERTY_FILTER = Pattern.compile("(!?)\\((osgi.arch|osgi.os|osgi.ws)=([^)]+)\\)");
        private static final String NATIVE_ARTIFACTS = "nativeArtifacts";
        private final Profile profile;
        private final WorkspaceIUAnalyzer workspaceIUAnalyzer;
        private IProvisioningPlan provisioningPlan;
        private IInstallableUnit artificialRoot;
        private List<IMetadataRepository> metadataRepositories;
        private boolean isIncludeAllPlatforms;
        private boolean isIncludeAllRequirements;

        public TargletCommitContext(Profile profile, WorkspaceIUAnalyzer workspaceIUAnalyzer, boolean isIncludeAllPlatforms, boolean isIncludeAllRequirements) {
            this.profile = profile;
            this.workspaceIUAnalyzer = workspaceIUAnalyzer;
            this.isIncludeAllPlatforms = isIncludeAllPlatforms;
            this.isIncludeAllRequirements = isIncludeAllRequirements;
        }

        public IProvisioningPlan getProvisioningPlan() {
            return this.provisioningPlan;
        }

        public final IInstallableUnit getArtificialRoot() {
            return this.artificialRoot;
        }

        public List<IMetadataRepository> getMetadataRepositories() {
            return this.metadataRepositories;
        }

        public ProvisioningContext createProvisioningContext(ProfileTransaction transaction, final IProfileChangeRequest profileChangeRequest) throws CoreException {
            IProvisioningAgent provisioningAgent = transaction.getProfile().getAgent().getProvisioningAgent();
            ProvisioningContext provisioningContext = new ProvisioningContext(provisioningAgent){
                private CollectionResult<IInstallableUnit> metadata;

                public IQueryable<IInstallableUnit> getMetadata(IProgressMonitor monitor) {
                    if (this.metadata == null) {
                        Map<IInstallableUnit, WorkspaceIUInfo> workspaceIUInfos = TargletCommitContext.this.workspaceIUAnalyzer.getWorkspaceIUInfos();
                        Map<String, Version> workspaceIUVersions = TargletCommitContext.this.workspaceIUAnalyzer.getIUVersions();
                        HashSet<IInstallableUnit> originalWorkspaceIUs = new HashSet<IInstallableUnit>(workspaceIUInfos.keySet());
                        LinkedHashSet<IInstallableUnit> ius = new LinkedHashSet<IInstallableUnit>();
                        HashMap<IU, IInstallableUnit> idToIUMap = new HashMap<IU, IInstallableUnit>();
                        this.generateWorkspaceSourceIUs(ius, workspaceIUVersions, idToIUMap, monitor);
                        ius.add(TargletCommitContext.createPDETargetPlatformIU());
                        IQueryResult metadataResult = super.getMetadata(monitor).query(QueryUtil.createIUAnyQuery(), monitor);
                        HashSet<IRequirement> licenseRequirements = new HashSet<IRequirement>();
                        HashSet<IRequirement> workspaceRequirements = new HashSet<IRequirement>();
                        HashSet binaryRequirements = new HashSet();
                        for (IInstallableUnit iu : P2Util.asIterable((IQueryResult)metadataResult)) {
                            TargletsCorePlugin.checkCancelation((IProgressMonitor)monitor);
                            binaryRequirements.addAll(iu.getRequirements());
                            ius.add(this.createGeneralizedIU(iu));
                            IInstallableUnit workspaceIU = (IInstallableUnit)idToIUMap.get(new IU(iu));
                            if (workspaceIU == null) {
                                workspaceIU = (IInstallableUnit)idToIUMap.get(new IU(iu.getId(), Version.emptyVersion));
                            }
                            if (workspaceIU == null) continue;
                            WorkspaceIUInfo info = workspaceIUInfos.get(workspaceIU);
                            workspaceIUInfos.put(iu, info);
                            if (workspaceIU.isSingleton() || "true".equals(workspaceIU.getProperty("org.eclipse.equinox.p2.type.group"))) {
                                ius.remove(workspaceIU);
                            }
                            block1: for (IRequirement workspaceRequirement : workspaceIU.getRequirements()) {
                                if (workspaceRequirement instanceof IRequiredCapability) {
                                    IInstallableUnit requiredWorkspaceIU;
                                    IRequiredCapability workspaceRequiredCapability = (IRequiredCapability)workspaceRequirement;
                                    String namespace = workspaceRequiredCapability.getNamespace();
                                    String name = workspaceRequiredCapability.getName();
                                    for (IRequirement requirement : iu.getRequirements()) {
                                        IRequiredCapability requiredCapability;
                                        if (requirement instanceof IRequiredCapability && namespace.equals((requiredCapability = (IRequiredCapability)requirement).getNamespace()) && name.equals(requiredCapability.getName())) continue block1;
                                    }
                                    if (("org.eclipse.equinox.p2.iu".equals(namespace) || "osgi.bundle".equals(namespace)) && (requiredWorkspaceIU = (IInstallableUnit)idToIUMap.get(new IU(name, Version.emptyVersion))) != null && (requiredWorkspaceIU.isSingleton() || "true".equals(requiredWorkspaceIU.getProperty("org.eclipse.equinox.p2.type.group")))) {
                                        workspaceRequirements.add(MetadataFactory.createRequirement((String)namespace, (String)name, (VersionRange)VersionRange.emptyRange, (IMatchExpression)workspaceRequiredCapability.getFilter(), (int)workspaceRequiredCapability.getMin(), (int)workspaceRequiredCapability.getMax(), (boolean)workspaceRequiredCapability.isGreedy()));
                                        continue;
                                    }
                                }
                                workspaceRequirements.add(workspaceRequirement);
                            }
                            String licenseFeatureID = workspaceIU.getProperty("org.eclipse.oomph.targlets.core.requiredLicenseFeatureID");
                            if (licenseFeatureID == null) continue;
                            VersionRange versionRange = new VersionRange(workspaceIU.getProperty("org.eclipse.oomph.targlets.core.requiredLicenseFeatureVersionRange"));
                            IRequirement requirement = MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)licenseFeatureID, (VersionRange)versionRange, null, (boolean)false, (boolean)false);
                            licenseRequirements.add(requirement);
                        }
                        if (!licenseRequirements.isEmpty()) {
                            MetadataFactory.InstallableUnitDescription requiredLicensesDescription = new MetadataFactory.InstallableUnitDescription();
                            requiredLicensesDescription.setId("required_licenses");
                            requiredLicensesDescription.setVersion(Version.createOSGi((int)1, (int)0, (int)0));
                            requiredLicensesDescription.setArtifacts(new IArtifactKey[0]);
                            requiredLicensesDescription.setProperty("org.eclipse.equinox.p2.type.group", Boolean.TRUE.toString());
                            requiredLicensesDescription.setCapabilities(new IProvidedCapability[]{MetadataFactory.createProvidedCapability((String)"org.eclipse.equinox.p2.iu", (String)requiredLicensesDescription.getId(), (Version)requiredLicensesDescription.getVersion())});
                            requiredLicensesDescription.addRequirements(licenseRequirements);
                            IInstallableUnit requiredLicensesIU = MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)requiredLicensesDescription);
                            ius.add(requiredLicensesIU);
                            profileChangeRequest.add(requiredLicensesIU);
                        }
                        workspaceRequirements.removeAll(binaryRequirements);
                        if (!workspaceRequirements.isEmpty()) {
                            MetadataFactory.InstallableUnitDescription workspaceRequirementsDescription = new MetadataFactory.InstallableUnitDescription();
                            workspaceRequirementsDescription.setId("workspace_requirements");
                            workspaceRequirementsDescription.setVersion(Version.createOSGi((int)1, (int)0, (int)0));
                            workspaceRequirementsDescription.setArtifacts(new IArtifactKey[0]);
                            workspaceRequirementsDescription.setProperty("org.eclipse.equinox.p2.type.group", Boolean.TRUE.toString());
                            workspaceRequirementsDescription.setCapabilities(new IProvidedCapability[]{MetadataFactory.createProvidedCapability((String)"org.eclipse.equinox.p2.iu", (String)workspaceRequirementsDescription.getId(), (Version)workspaceRequirementsDescription.getVersion())});
                            workspaceRequirementsDescription.addRequirements(workspaceRequirements);
                            IInstallableUnit workspaceRequirementsIU = MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)workspaceRequirementsDescription);
                            ius.add(workspaceRequirementsIU);
                            profileChangeRequest.add(workspaceRequirementsIU);
                        }
                        HashSet<IInstallableUnit> remainingWorkspaceIUs = new HashSet<IInstallableUnit>(ius);
                        remainingWorkspaceIUs.retainAll(originalWorkspaceIUs);
                        for (IInstallableUnit iu : remainingWorkspaceIUs) {
                            Collection requirements = iu.getRequirements();
                            int size = requirements.size();
                            IRequirement[] generalizedRequirements = requirements.toArray(new IRequirement[size]);
                            boolean needsGeneralization = false;
                            int i = 0;
                            while (i < size) {
                                IRequiredCapability workspaceRequiredCapability;
                                VersionRange versionRange;
                                IRequirement workspaceRequirement = generalizedRequirements[i];
                                if (workspaceRequirement instanceof IRequiredCapability && !VersionRange.emptyRange.equals((Object)(versionRange = (workspaceRequiredCapability = (IRequiredCapability)workspaceRequirement).getRange()))) {
                                    IInstallableUnit requiredWorkspaceIU;
                                    String namespace = workspaceRequiredCapability.getNamespace();
                                    String name = workspaceRequiredCapability.getName();
                                    if (("org.eclipse.equinox.p2.iu".equals(namespace) || "osgi.bundle".equals(namespace)) && (requiredWorkspaceIU = (IInstallableUnit)idToIUMap.get(new IU(name, Version.emptyVersion))) != null && !ius.contains(requiredWorkspaceIU) && (requiredWorkspaceIU.isSingleton() || "true".equals(requiredWorkspaceIU.getProperty("org.eclipse.equinox.p2.type.group")))) {
                                        needsGeneralization = true;
                                        generalizedRequirements[i] = MetadataFactory.createRequirement((String)namespace, (String)name, (VersionRange)VersionRange.emptyRange, (IMatchExpression)workspaceRequiredCapability.getFilter(), (int)workspaceRequiredCapability.getMin(), (int)workspaceRequiredCapability.getMax(), (boolean)workspaceRequiredCapability.isGreedy());
                                    }
                                }
                                ++i;
                            }
                            if (!needsGeneralization) continue;
                            ((InstallableUnit)iu).setRequiredCapabilities(generalizedRequirements);
                        }
                        this.metadata = new CollectionResult(ius);
                    }
                    return this.metadata;
                }

                private IInstallableUnit createGeneralizedIU(IInstallableUnit iu) {
                    MetadataFactory.InstallableUnitDescription description;
                    if (!TargletCommitContext.this.isIncludeAllPlatforms && TargletCommitContext.this.isIncludeAllRequirements) {
                        return iu;
                    }
                    IMatchExpression<IInstallableUnit> filter = iu.getFilter();
                    IMatchExpression<IInstallableUnit> generalizedFilter = TargletCommitContext.this.isIncludeAllPlatforms ? this.generalize(filter) : filter;
                    boolean needsGeneralization = filter != generalizedFilter;
                    Collection requirements = iu.getRequirements();
                    IRequirement[] generalizedRequirements = requirements.toArray(new IRequirement[requirements.size()]);
                    int i = 0;
                    while (i < generalizedRequirements.length) {
                        IMatchExpression<IInstallableUnit> generalizedRequirementFilter;
                        IRequirement requirement = generalizedRequirements[i];
                        IMatchExpression requirementFilter = requirement.getFilter();
                        IMatchExpression<IInstallableUnit> iMatchExpression = generalizedRequirementFilter = TargletCommitContext.this.isIncludeAllPlatforms ? this.generalize((IMatchExpression<IInstallableUnit>)requirementFilter) : filter;
                        if (requirementFilter != filter || !TargletCommitContext.this.isIncludeAllRequirements && requirement.getMin() != 0) {
                            IRequirement generalizedRequirement;
                            needsGeneralization = true;
                            generalizedRequirements[i] = generalizedRequirement = MetadataFactory.createRequirement((IMatchExpression)requirement.getMatches(), generalizedRequirementFilter, (int)0, (int)requirement.getMax(), (boolean)true, (String)requirement.getDescription());
                        }
                        ++i;
                    }
                    if (!needsGeneralization) {
                        return iu;
                    }
                    if (iu instanceof IInstallableUnitFragment) {
                        IInstallableUnitFragment installableUnitFragment = (IInstallableUnitFragment)iu;
                        MetadataFactory.InstallableUnitFragmentDescription fragmentDescription = new MetadataFactory.InstallableUnitFragmentDescription();
                        Collection host = installableUnitFragment.getHost();
                        fragmentDescription.setHost(host.toArray(new IRequirement[host.size()]));
                        description = fragmentDescription;
                    } else if (iu instanceof IInstallableUnitPatch) {
                        IInstallableUnitPatch installableUnitPatch = (IInstallableUnitPatch)iu;
                        MetadataFactory.InstallableUnitPatchDescription patchDescription = new MetadataFactory.InstallableUnitPatchDescription();
                        patchDescription.setApplicabilityScope(installableUnitPatch.getApplicabilityScope());
                        patchDescription.setLifeCycle(installableUnitPatch.getLifeCycle());
                        List requirementsChange = installableUnitPatch.getRequirementsChange();
                        patchDescription.setRequirementChanges(requirementsChange.toArray(new IRequirementChange[requirementsChange.size()]));
                        description = patchDescription;
                    } else {
                        description = new MetadataFactory.InstallableUnitDescription();
                    }
                    description.setId(iu.getId());
                    description.setVersion(iu.getVersion());
                    Collection artifacts = iu.getArtifacts();
                    description.setArtifacts(artifacts.toArray(new IArtifactKey[artifacts.size()]));
                    Collection providedCapabilities = iu.getProvidedCapabilities();
                    description.setCapabilities(providedCapabilities.toArray(new IProvidedCapability[providedCapabilities.size()]));
                    description.setCopyright(iu.getCopyright());
                    description.setFilter(generalizedFilter);
                    Collection licenses = iu.getLicenses();
                    description.setLicenses(licenses.toArray(new ILicense[licenses.size()]));
                    Collection metaRequirements = iu.getMetaRequirements();
                    description.setMetaRequirements(metaRequirements.toArray(new IRequirement[metaRequirements.size()]));
                    description.setRequirements(generalizedRequirements);
                    description.setSingleton(iu.isSingleton());
                    description.setTouchpointType(iu.getTouchpointType());
                    description.setUpdateDescriptor(iu.getUpdateDescriptor());
                    for (Map.Entry entry : iu.getProperties().entrySet()) {
                        description.setProperty((String)entry.getKey(), (String)entry.getValue());
                    }
                    for (ITouchpointData touchpointData : iu.getTouchpointData()) {
                        description.addTouchpointData(touchpointData);
                    }
                    return MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)description);
                }

                private IMatchExpression<IInstallableUnit> generalize(IMatchExpression<IInstallableUnit> filter) {
                    if (filter == null) {
                        return null;
                    }
                    Object[] generalizedParameters = null;
                    Object[] parameters = filter.getParameters();
                    int i = 0;
                    while (i < parameters.length) {
                        Object parameter = parameters[i];
                        if (parameter instanceof LDAPFilter) {
                            String value = parameter.toString();
                            Matcher matcher = OSGI_PROPERTY_FILTER.matcher(value);
                            if (matcher.find()) {
                                if (generalizedParameters == null) {
                                    generalizedParameters = new Object[parameters.length];
                                    System.arraycopy(parameters, 0, generalizedParameters, 0, parameters.length);
                                }
                                StringBuffer result = new StringBuffer();
                                if (matcher.group(1).length() == 0) {
                                    matcher.appendReplacement(result, "($2=*)");
                                } else {
                                    matcher.appendReplacement(result, "!($2=nothing)");
                                }
                                while (matcher.find()) {
                                    if (matcher.group(1).length() == 0) {
                                        matcher.appendReplacement(result, "($2=*)");
                                        continue;
                                    }
                                    matcher.appendReplacement(result, "!($2=nothing)");
                                }
                                matcher.appendTail(result);
                                IFilterExpression ldap = ExpressionUtil.parseLDAP((String)result.toString());
                                generalizedParameters[i] = ldap;
                            }
                        }
                        ++i;
                    }
                    if (generalizedParameters != null) {
                        IExpression expression = ExpressionUtil.parse((String)filter.toString());
                        return ExpressionUtil.getFactory().matchExpression(expression, generalizedParameters);
                    }
                    return filter;
                }

                private void generateWorkspaceSourceIUs(Set<IInstallableUnit> ius, Map<String, Version> ids, Map<IU, IInstallableUnit> idToIUMap, IProgressMonitor monitor) {
                    HashMap<IInstallableUnit, WorkspaceIUInfo> workspaceSourceIUInfos = new HashMap<IInstallableUnit, WorkspaceIUInfo>();
                    Map<IInstallableUnit, WorkspaceIUInfo> workspaceIUInfos = TargletCommitContext.this.workspaceIUAnalyzer.getWorkspaceIUInfos();
                    for (IInstallableUnit iu : workspaceIUInfos.keySet()) {
                        TargletsCorePlugin.checkCancelation((IProgressMonitor)monitor);
                        String id = iu.getId();
                        ius.add(this.createGeneralizedIU(iu));
                        idToIUMap.put(new IU(iu), iu);
                        if (id.endsWith(".plain.project")) continue;
                        String suffix = "";
                        if (id.endsWith(".feature.group")) {
                            id = id.substring(0, id.length() - ".feature.group".length());
                            suffix = ".feature.group";
                        }
                        MetadataFactory.InstallableUnitDescription description = new MetadataFactory.InstallableUnitDescription();
                        String workspaceSourceID = String.valueOf(id) + ".source" + suffix;
                        description.setId(workspaceSourceID);
                        Version version = iu.getVersion();
                        description.setVersion(version);
                        for (Map.Entry property : iu.getProperties().entrySet()) {
                            TargletsCorePlugin.checkCancelation((IProgressMonitor)monitor);
                            String key = (String)property.getKey();
                            if ("org.eclipse.oomph.targlet.workspace.main".equals(key)) continue;
                            String value = (String)property.getValue();
                            if ("org.eclipse.equinox.p2.name".equals(key)) {
                                value = "Source for " + value;
                            }
                            description.setProperty(key, value);
                        }
                        description.setTouchpointType(PublisherHelper.TOUCHPOINT_OSGI);
                        description.setProperty(TargletContainer.IU_PROPERTY_SOURCE, Boolean.TRUE.toString());
                        description.addProvidedCapabilities(Collections.singleton(MetadataFactory.createProvidedCapability((String)"org.eclipse.equinox.p2.iu", (String)description.getId(), (Version)description.getVersion())));
                        IInstallableUnit workspaceSourceIU = MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)description);
                        ius.add(workspaceSourceIU);
                        ids.put(workspaceSourceID, version);
                        idToIUMap.put(new IU(workspaceSourceIU), workspaceSourceIU);
                        WorkspaceIUInfo info = workspaceIUInfos.get(iu);
                        workspaceSourceIUInfos.put(workspaceSourceIU, info);
                    }
                    workspaceIUInfos.putAll(workspaceSourceIUInfos);
                }
            };
            provisioningContext.setProperty("org.eclipse.equinox.p2.director.followRepositoryReferences", Boolean.FALSE.toString());
            provisioningContext.setProperty(TargletContainer.FOLLOW_ARTIFACT_REPOSITORY_REFERENCES, Boolean.FALSE.toString());
            return provisioningContext;
        }

        public boolean handleProvisioningPlan(ProfileTransaction.CommitContext.ResolutionInfo info) throws CoreException {
            this.provisioningPlan = info.getProvisioningPlan();
            this.artificialRoot = info.getArtificialRoot();
            this.metadataRepositories = info.getMetadataRepositories();
            return true;
        }

        public IPhaseSet getPhaseSet(ProfileTransaction transaction) {
            ArrayList<Object> phases = new ArrayList<Object>(4);
            phases.add(new Collect(100));
            phases.add(new Property(1));
            phases.add(new Uninstall(50, true){

                protected List<ProvisioningAction> getActions(InstallableUnitOperand currentOperand) {
                    IInstallableUnit first = currentOperand.first();
                    if (first != null && "true".equals(first.getProperty("org.eclipse.oomph.targlet.workspace")) && first instanceof ResolvedInstallableUnit) {
                        return super.getActions(new InstallableUnitOperand((IInstallableUnit)new ResolvedInstallableUnit((IInstallableUnit)((ResolvedInstallableUnit)first).getMember("original")), null));
                    }
                    return super.getActions(currentOperand);
                }
            });
            phases.add(new Install(50){

                protected List<ProvisioningAction> getActions(InstallableUnitOperand currentOperand) {
                    IInstallableUnit second = currentOperand.second();
                    if (second != null && "true".equals(second.getProperty("org.eclipse.oomph.targlet.workspace")) && second instanceof ResolvedInstallableUnit) {
                        return super.getActions(new InstallableUnitOperand(null, (IInstallableUnit)new ResolvedInstallableUnit((IInstallableUnit)((ResolvedInstallableUnit)second).getMember("original"))));
                    }
                    return super.getActions(currentOperand);
                }
            });
            phases.add((Object)new CollectNativesPhase(this.profile.getBundlePool(), 100));
            return new PhaseSet(phases.toArray(new Phase[phases.size()]));
        }

        private static IInstallableUnit createPDETargetPlatformIU() {
            MetadataFactory.InstallableUnitDescription description = new MetadataFactory.InstallableUnitDescription();
            description.setId(A_PDE_TARGET_PLATFORM_LOWER_CASE);
            Version version = Version.createOSGi((int)1, (int)0, (int)0);
            description.setVersion(version);
            description.addProvidedCapabilities(Collections.singleton(MetadataFactory.createProvidedCapability((String)TargletContainer.A_PDE_TARGET_PLATFORM, (String)"Cannot be installed into the IDE", (Version)version)));
            description.setTouchpointType(PublisherHelper.TOUCHPOINT_OSGI);
            description.setArtifacts(new IArtifactKey[0]);
            return MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)description);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static final class CollectNativesAction
        extends ProvisioningAction {
            private static final String PARM_OPERAND = "operand";
            private final BundlePool bundlePool;

            public CollectNativesAction(BundlePool bundlePool) {
                this.bundlePool = bundlePool;
            }

            public IStatus execute(Map<String, Object> parameters) {
                InstallableUnitOperand operand = (InstallableUnitOperand)parameters.get(PARM_OPERAND);
                IInstallableUnit installableUnit = operand.second();
                if (installableUnit == null) {
                    return Status.OK_STATUS;
                }
                try {
                    Collection toDownload = installableUnit.getArtifacts();
                    if (toDownload == null) {
                        return Status.OK_STATUS;
                    }
                    List artifactRequests = (List)parameters.get(TargletCommitContext.NATIVE_ARTIFACTS);
                    IArtifactRepositoryManager manager = this.bundlePool.getAgent().getArtifactRepositoryManager();
                    IFileArtifactRepository fileArtifactRepository = this.bundlePool.getFileArtifactRepository();
                    for (IArtifactKey keyToDownload : toDownload) {
                        IArtifactRequest request = manager.createMirrorRequest(keyToDownload, (IArtifactRepository)fileArtifactRepository, null, null);
                        artifactRequests.add(request);
                    }
                }
                catch (Exception ex) {
                    return TargletsCorePlugin.INSTANCE.getStatus(ex);
                }
                return Status.OK_STATUS;
            }

            public IStatus undo(Map<String, Object> parameters) {
                return Status.OK_STATUS;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static final class CollectNativesPhase
        extends InstallableUnitPhase {
            private static final String NATIVE_TYPE = "org.eclipse.equinox.p2.native";
            private final BundlePool bundlePool;

            public CollectNativesPhase(BundlePool bundlePool, int weight) {
                super(TargletCommitContext.NATIVE_ARTIFACTS, weight);
                this.bundlePool = bundlePool;
            }

            protected List<ProvisioningAction> getActions(InstallableUnitOperand operand) {
                IInstallableUnit installableUnit = operand.second();
                if (installableUnit != null && installableUnit.getTouchpointType().getId().equals(NATIVE_TYPE)) {
                    ArrayList<ProvisioningAction> list = new ArrayList<ProvisioningAction>(1);
                    list.add(new CollectNativesAction(this.bundlePool));
                    return list;
                }
                return null;
            }

            protected IStatus initializePhase(IProgressMonitor monitor, IProfile profile, Map<String, Object> parameters) {
                parameters.put(TargletCommitContext.NATIVE_ARTIFACTS, new ArrayList());
                parameters.put("profile", profile);
                return null;
            }

            protected IStatus completePhase(IProgressMonitor monitor, IProfile profile, Map<String, Object> parameters) {
                List artifactRequests = (List)parameters.get(TargletCommitContext.NATIVE_ARTIFACTS);
                ProvisioningContext context = (ProvisioningContext)parameters.get("context");
                IProvisioningAgent agent = (IProvisioningAgent)parameters.get("agent");
                DownloadManager downloadManager = new DownloadManager(context, agent);
                Iterator it = artifactRequests.iterator();
                while (it.hasNext()) {
                    downloadManager.add((IArtifactRequest)it.next());
                }
                return downloadManager.start(monitor);
            }
        }
    }
}

