/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.pde.impl;

import java.lang.reflect.Method;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.oomph.setup.SetupTaskContext;
import org.eclipse.oomph.setup.log.ProgressLog;
import org.eclipse.oomph.setup.log.ProgressLogMonitor;
import org.eclipse.oomph.setup.pde.APIBaselineFromTargetTask;
import org.eclipse.oomph.setup.pde.PDEPackage;
import org.eclipse.oomph.setup.pde.impl.AbstractAPIBaselineTaskImpl;
import org.eclipse.oomph.setup.util.SetupUtil;
import org.eclipse.oomph.util.ReflectUtil;
import org.eclipse.oomph.util.StringUtil;
import org.eclipse.oomph.util.pde.TargetPlatformUtil;
import org.eclipse.pde.api.tools.internal.ApiBaselineManager;
import org.eclipse.pde.api.tools.internal.model.ApiModelFactory;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.IApiBaselineManager;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiBaseline;
import org.eclipse.pde.core.target.ITargetDefinition;

public class APIBaselineFromTargetTaskImpl
extends AbstractAPIBaselineTaskImpl
implements APIBaselineFromTargetTask {
    protected static final String TARGET_NAME_EDEFAULT = "";
    protected String targetName = "";
    private transient ITargetDefinition target;
    private transient IApiBaselineManager baselineManager;
    private transient String baselineName;
    private transient IApiBaseline baseline;
    private transient boolean wasActive;
    private transient boolean backupRequired;

    protected APIBaselineFromTargetTaskImpl() {
    }

    protected EClass eStaticClass() {
        return PDEPackage.Literals.API_BASELINE_FROM_TARGET_TASK;
    }

    public String getTargetName() {
        return this.targetName;
    }

    public void setTargetName(String newTargetName) {
        String oldTargetName = this.targetName;
        this.targetName = newTargetName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 12, (Object)oldTargetName, (Object)this.targetName));
        }
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 12: {
                return this.getTargetName();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 12: {
                this.setTargetName((String)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 12: {
                this.setTargetName(TARGET_NAME_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 12: {
                return TARGET_NAME_EDEFAULT == null ? this.targetName != null : !TARGET_NAME_EDEFAULT.equals(this.targetName);
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (targetName: ");
        result.append(this.targetName);
        result.append(')');
        return result.toString();
    }

    public boolean isNeeded(SetupTaskContext context) throws Exception {
        Method isDerivedFromTargetMethod;
        try {
            isDerivedFromTargetMethod = ApiModelFactory.class.getMethod("isDerivedFromTarget", IApiBaseline.class, ITargetDefinition.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return false;
        }
        ApiPlugin apiPlugin = ApiPlugin.getDefault();
        if (apiPlugin == null) {
            return false;
        }
        String name = this.getName();
        String targetName = this.getTargetName();
        if (name == null || targetName == null) {
            return false;
        }
        this.target = TargetPlatformUtil.getTargetDefinition((String)targetName);
        boolean hasTargetDefinitionUpdates = SetupUtil.getResolvingTargetDefinitions((SetupTaskContext)context).contains(targetName);
        if (this.target == null && !hasTargetDefinitionUpdates) {
            return false;
        }
        this.baselineManager = apiPlugin.getApiBaselineManager();
        this.baselineName = name;
        this.baseline = this.baselineManager.getApiBaseline(this.baselineName);
        if (this.baseline == null) {
            return true;
        }
        ((ApiBaselineManager)this.baselineManager).loadBaselineInfos(this.baseline);
        String location = this.baseline.getLocation();
        if (!StringUtil.isEmpty((String)location) && location.startsWith("target:") && location.indexOf(92) >= 0) {
            location = location.replace('\\', '/');
            this.baseline.setLocation(location);
        }
        this.wasActive = this.baselineManager.getDefaultApiBaseline() == this.baseline;
        boolean bl = this.backupRequired = (Boolean)ReflectUtil.invokeMethod((Method)isDerivedFromTargetMethod, null, (Object[])new Object[]{this.baseline, this.target}) == false;
        return this.backupRequired || this.target == null || !this.wasActive && this.isActivate() || hasTargetDefinitionUpdates;
    }

    public void perform(SetupTaskContext context) throws Exception {
        if (this.backupRequired) {
            String backupName = String.valueOf(this.baselineName) + " " + System.currentTimeMillis();
            context.log("Backing up existing baseline to " + backupName);
            this.baselineManager.removeApiBaseline(this.baselineName);
            this.baseline.setName(backupName);
            this.baselineManager.addApiBaseline(this.baseline);
            this.baseline = null;
        }
        if (this.baseline != null) {
            context.log("Removing existing baseline.");
            this.baselineManager.removeApiBaseline(this.baselineName);
            this.baseline = null;
        }
        String targetName = this.getTargetName();
        if (this.target == null) {
            this.target = TargetPlatformUtil.getTargetDefinition((String)targetName);
        }
        if (this.target == null) {
            context.log("Creating new empty baseline because target " + targetName + " was not found.", ProgressLog.Severity.WARNING);
            this.baseline = ApiModelFactory.newApiBaseline((String)this.baselineName);
            this.baselineManager.addApiBaseline(this.baseline);
        }
        if (this.baseline == null) {
            context.log("Creating new baseline from target " + targetName);
            ReflectUtil.invokeMethod((Method)ApiModelFactory.class.getMethod("newApiBaselineFromTarget", String.class, ITargetDefinition.class, IProgressMonitor.class), (Object)this.baselineName, (Object[])new Object[]{this.target, new ProgressLogMonitor((ProgressLog)context)});
            this.baselineManager.addApiBaseline(this.baseline);
        }
        if ((this.wasActive || this.isActivate()) && this.baselineManager.getDefaultApiBaseline() != this.baseline) {
            context.log("Activating baseline: " + this.baselineName);
            this.baselineManager.setDefaultApiBaseline(this.baselineName);
        }
    }
}

