/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.ImageList;
import org.eclipse.swt.internal.gtk.GDK;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkRGBA;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;

public class TreeItem
extends Item {
    Tree parent;
    Font font;
    Font[] cellFont;
    String[] strings;
    boolean cached;
    boolean grayed;
    boolean isExpanded;
    boolean updated;
    static final int EXPANDER_EXTRA_PADDING = 4;

    public TreeItem(Tree parent, int style) {
        this(TreeItem.checkNull(parent), 0, style, -1, true);
    }

    public TreeItem(Tree parent, int style, int index) {
        this(TreeItem.checkNull(parent), 0, style, TreeItem.checkIndex(index), true);
    }

    public TreeItem(TreeItem parentItem, int style) {
        this(TreeItem.checkNull((TreeItem)parentItem).parent, parentItem.handle, style, -1, true);
    }

    public TreeItem(TreeItem parentItem, int style, int index) {
        this(TreeItem.checkNull((TreeItem)parentItem).parent, parentItem.handle, style, TreeItem.checkIndex(index), true);
    }

    TreeItem(Tree parent, int parentIter, int style, int index, boolean create) {
        super(parent, style);
        this.parent = parent;
        if (create) {
            parent.createItem(this, parentIter, index);
        } else {
            this.handle = OS.g_malloc(GTK.GtkTreeIter_sizeof());
            GTK.gtk_tree_model_iter_nth_child(parent.modelHandle, this.handle, parentIter, index);
        }
    }

    static int checkIndex(int index) {
        if (index < 0) {
            SWT.error(6);
        }
        return index;
    }

    static TreeItem checkNull(TreeItem item) {
        if (item == null) {
            SWT.error(4);
        }
        return item;
    }

    static Tree checkNull(Tree control) {
        if (control == null) {
            SWT.error(4);
        }
        return control;
    }

    @Override
    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    Color _getBackground() {
        int[] ptr = new int[1];
        GTK.gtk_tree_model_get(this.parent.modelHandle, this.handle, 4, ptr, -1);
        if (ptr[0] == 0) {
            return this.parent.getBackground();
        }
        if (GTK.GTK3) {
            GdkRGBA gdkRGBA = new GdkRGBA();
            OS.memmove(gdkRGBA, ptr[0], GdkRGBA.sizeof);
            GDK.gdk_rgba_free(ptr[0]);
            return Color.gtk_new((Device)this.display, gdkRGBA);
        }
        GdkColor gdkColor = new GdkColor();
        OS.memmove(gdkColor, ptr[0], GdkColor.sizeof);
        GDK.gdk_color_free(ptr[0]);
        return Color.gtk_new((Device)this.display, gdkColor);
    }

    Color _getBackground(int index) {
        int count = Math.max(1, this.parent.columnCount);
        if (index < 0 || index > count - 1) {
            return this._getBackground();
        }
        int[] ptr = new int[1];
        int modelIndex = this.parent.columnCount == 0 ? 6 : this.parent.columns[index].modelIndex;
        GTK.gtk_tree_model_get(this.parent.modelHandle, this.handle, modelIndex + 3, ptr, -1);
        if (ptr[0] == 0) {
            return this._getBackground();
        }
        if (GTK.GTK3) {
            GdkRGBA gdkRGBA = new GdkRGBA();
            OS.memmove(gdkRGBA, ptr[0], GdkRGBA.sizeof);
            GDK.gdk_rgba_free(ptr[0]);
            return Color.gtk_new((Device)this.display, gdkRGBA);
        }
        GdkColor gdkColor = new GdkColor();
        OS.memmove(gdkColor, ptr[0], GdkColor.sizeof);
        GDK.gdk_color_free(ptr[0]);
        return Color.gtk_new((Device)this.display, gdkColor);
    }

    boolean _getChecked() {
        int[] ptr = new int[1];
        GTK.gtk_tree_model_get(this.parent.modelHandle, this.handle, 1, ptr, -1);
        return ptr[0] != 0;
    }

    Color _getForeground() {
        int[] ptr = new int[1];
        GTK.gtk_tree_model_get(this.parent.modelHandle, this.handle, 3, ptr, -1);
        if (ptr[0] == 0) {
            return this.parent.getForeground();
        }
        if (GTK.GTK3) {
            GdkRGBA gdkRGBA = new GdkRGBA();
            OS.memmove(gdkRGBA, ptr[0], GdkRGBA.sizeof);
            GDK.gdk_rgba_free(ptr[0]);
            return Color.gtk_new((Device)this.display, gdkRGBA);
        }
        GdkColor gdkColor = new GdkColor();
        OS.memmove(gdkColor, ptr[0], GdkColor.sizeof);
        GDK.gdk_color_free(ptr[0]);
        return Color.gtk_new((Device)this.display, gdkColor);
    }

    Color _getForeground(int index) {
        int count = Math.max(1, this.parent.columnCount);
        if (index < 0 || index > count - 1) {
            return this._getForeground();
        }
        int[] ptr = new int[1];
        int modelIndex = this.parent.columnCount == 0 ? 6 : this.parent.columns[index].modelIndex;
        GTK.gtk_tree_model_get(this.parent.modelHandle, this.handle, modelIndex + 2, ptr, -1);
        if (ptr[0] == 0) {
            return this._getForeground();
        }
        if (GTK.GTK3) {
            GdkRGBA gdkRGBA = new GdkRGBA();
            OS.memmove(gdkRGBA, ptr[0], GdkRGBA.sizeof);
            GDK.gdk_rgba_free(ptr[0]);
            return Color.gtk_new((Device)this.display, gdkRGBA);
        }
        GdkColor gdkColor = new GdkColor();
        OS.memmove(gdkColor, ptr[0], GdkColor.sizeof);
        GDK.gdk_color_free(ptr[0]);
        return Color.gtk_new((Device)this.display, gdkColor);
    }

    Image _getImage(int index) {
        int count = Math.max(1, this.parent.getColumnCount());
        if (index < 0 || index > count - 1) {
            return null;
        }
        int[] ptr = new int[1];
        int modelIndex = this.parent.columnCount == 0 ? 6 : this.parent.columns[index].modelIndex;
        GTK.gtk_tree_model_get(this.parent.modelHandle, this.handle, modelIndex + 0, ptr, -1);
        if (ptr[0] == 0) {
            return null;
        }
        ImageList imageList = this.parent.imageList;
        int imageIndex = imageList.indexOf(ptr[0]);
        OS.g_object_unref(ptr[0]);
        if (imageIndex == -1) {
            return null;
        }
        return imageList.get(imageIndex);
    }

    String _getText(int index) {
        int count = Math.max(1, this.parent.getColumnCount());
        if (index < 0 || index > count - 1) {
            return "";
        }
        int[] ptr = new int[1];
        int modelIndex = this.parent.columnCount == 0 ? 6 : this.parent.columns[index].modelIndex;
        GTK.gtk_tree_model_get(this.parent.modelHandle, this.handle, modelIndex + 1, ptr, -1);
        if (ptr[0] == 0) {
            return "";
        }
        int length = C.strlen(ptr[0]);
        byte[] buffer = new byte[length];
        C.memmove(buffer, ptr[0], length);
        OS.g_free(ptr[0]);
        return new String(Converter.mbcsToWcs(buffer));
    }

    void clear() {
        if (this.parent.currentItem == this) {
            return;
        }
        if (this.cached || (this.parent.style & 0x10000000) == 0) {
            int columnCount = GTK.gtk_tree_model_get_n_columns(this.parent.modelHandle);
            int i = 1;
            while (i < 3) {
                GTK.gtk_tree_store_set(this.parent.modelHandle, this.handle, i, 0, -1);
                ++i;
            }
            i = 3;
            while (i < columnCount) {
                GTK.gtk_tree_store_set(this.parent.modelHandle, this.handle, i, 0, -1);
                ++i;
            }
        }
        this.cached = false;
        this.font = null;
        this.strings = null;
        this.cellFont = null;
    }

    public void clear(int index, boolean all) {
        this.checkWidget();
        this.parent.clear(this.handle, index, all);
    }

    public void clearAll(boolean all) {
        this.checkWidget();
        this.parent.clearAll(all, this.handle);
    }

    @Override
    void destroyWidget() {
        this.parent.releaseItem(this, false);
        this.parent.destroyItem(this);
        this.releaseHandle();
    }

    public Color getBackground() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        return this._getBackground();
    }

    public Color getBackground(int index) {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        return this._getBackground(index);
    }

    public Rectangle getBounds(int index) {
        this.checkWidget();
        return DPIUtil.autoScaleDown(this.getBoundsInPixels(index));
    }

    Rectangle getBoundsInPixels(int index) {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        int parentHandle = this.parent.handle;
        int column = 0;
        column = index >= 0 && index < this.parent.columnCount ? this.parent.columns[index].handle : GTK.gtk_tree_view_get_column(parentHandle, index);
        if (column == 0) {
            return new Rectangle(0, 0, 0, 0);
        }
        int path = GTK.gtk_tree_model_get_path(this.parent.modelHandle, this.handle);
        GTK.gtk_widget_realize(parentHandle);
        GdkRectangle rect = new GdkRectangle();
        GTK.gtk_tree_view_get_cell_area(parentHandle, path, column, rect);
        if ((this.parent.getStyle() & 0x8000000) != 0) {
            rect.x = this.parent.getClientWidth() - rect.width - rect.x;
        }
        GTK.gtk_tree_path_free(path);
        if (index == 0 && (this.parent.style & 0x20) != 0) {
            int[] x = new int[1];
            int[] w = new int[1];
            this.gtk_tree_view_column_cell_get_position(column, this.parent.checkRenderer, x, w);
            rect.x += x[0] + w[0];
            rect.width -= x[0] + w[0];
        }
        int width = GTK.gtk_tree_view_column_get_visible(column) ? rect.width + 1 : 0;
        Rectangle r = new Rectangle(rect.x, rect.y, width, rect.height + 1);
        return r;
    }

    public Rectangle getBounds() {
        this.checkWidget();
        return DPIUtil.autoScaleDown(this.getBoundsInPixels());
    }

    Rectangle getBoundsInPixels() {
        int parentHandle;
        int column;
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        if ((column = GTK.gtk_tree_view_get_column(parentHandle = this.parent.handle, 0)) == 0) {
            return new Rectangle(0, 0, 0, 0);
        }
        int textRenderer = this.parent.getTextRenderer(column);
        int pixbufRenderer = this.parent.getPixbufRenderer(column);
        if (textRenderer == 0 || pixbufRenderer == 0) {
            return new Rectangle(0, 0, 0, 0);
        }
        int path = GTK.gtk_tree_model_get_path(this.parent.modelHandle, this.handle);
        GTK.gtk_widget_realize(parentHandle);
        boolean isExpander = GTK.gtk_tree_model_iter_n_children(this.parent.modelHandle, this.handle) > 0;
        boolean isExpanded = GTK.gtk_tree_view_row_expanded(parentHandle, path);
        GTK.gtk_tree_view_column_cell_set_cell_data(column, this.parent.modelHandle, this.handle, isExpander, isExpanded);
        GdkRectangle rect = new GdkRectangle();
        GTK.gtk_tree_view_get_cell_area(parentHandle, path, column, rect);
        if ((this.parent.getStyle() & 0x8000000) != 0) {
            rect.x = this.parent.getClientWidth() - rect.width - rect.x;
        }
        int right = rect.x + rect.width;
        int[] x = new int[1];
        int[] w = new int[1];
        this.parent.ignoreSize = true;
        this.gtk_cell_renderer_get_preferred_size(textRenderer, parentHandle, w, null);
        this.parent.ignoreSize = false;
        rect.width = w[0];
        int[] buffer = new int[1];
        GTK.gtk_tree_path_free(path);
        GTK.gtk_widget_style_get(parentHandle, OS.horizontal_separator, buffer, 0);
        int horizontalSeparator = buffer[0];
        rect.x += horizontalSeparator;
        this.gtk_tree_view_column_cell_get_position(column, textRenderer, x, null);
        rect.x += x[0];
        if (this.parent.columnCount > 0 && rect.x + rect.width > right) {
            rect.width = Math.max(0, right - rect.x);
        }
        int width = GTK.gtk_tree_view_column_get_visible(column) ? rect.width + 1 : 0;
        Rectangle r = new Rectangle(rect.x, rect.y, width, rect.height + 1);
        return r;
    }

    public boolean getChecked() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        if ((this.parent.style & 0x20) == 0) {
            return false;
        }
        return this._getChecked();
    }

    public boolean getExpanded() {
        this.checkWidget();
        int path = GTK.gtk_tree_model_get_path(this.parent.modelHandle, this.handle);
        boolean answer = GTK.gtk_tree_view_row_expanded(this.parent.handle, path);
        GTK.gtk_tree_path_free(path);
        return answer;
    }

    public Font getFont() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        return this.font != null ? this.font : this.parent.getFont();
    }

    public Font getFont(int index) {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        int count = Math.max(1, this.parent.columnCount);
        if (index < 0 || index > count - 1) {
            return this.getFont();
        }
        if (this.cellFont == null || this.cellFont[index] == null) {
            return this.getFont();
        }
        return this.cellFont[index];
    }

    public Color getForeground() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        return this._getForeground();
    }

    public Color getForeground(int index) {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        return this._getForeground(index);
    }

    public boolean getGrayed() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        if ((this.parent.style & 0x20) == 0) {
            return false;
        }
        return this.grayed;
    }

    @Override
    public Image getImage() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        return this.getImage(0);
    }

    public Image getImage(int index) {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        return this._getImage(index);
    }

    public Rectangle getImageBounds(int index) {
        this.checkWidget();
        return DPIUtil.autoScaleDown(this.getImageBoundsInPixels(index));
    }

    Rectangle getImageBoundsInPixels(int index) {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        int parentHandle = this.parent.handle;
        int column = 0;
        column = index >= 0 && index < this.parent.getColumnCount() ? this.parent.columns[index].handle : GTK.gtk_tree_view_get_column(parentHandle, index);
        if (column == 0) {
            return new Rectangle(0, 0, 0, 0);
        }
        int pixbufRenderer = this.parent.getPixbufRenderer(column);
        if (pixbufRenderer == 0) {
            return new Rectangle(0, 0, 0, 0);
        }
        GdkRectangle rect = new GdkRectangle();
        int path = GTK.gtk_tree_model_get_path(this.parent.modelHandle, this.handle);
        GTK.gtk_widget_realize(parentHandle);
        GTK.gtk_tree_view_get_cell_area(parentHandle, path, column, rect);
        if ((this.parent.getStyle() & 0x8000000) != 0) {
            rect.x = this.parent.getClientWidth() - rect.width - rect.x;
        }
        GTK.gtk_tree_path_free(path);
        int[] x = new int[1];
        int[] w = new int[1];
        this.gtk_tree_view_column_cell_get_position(column, pixbufRenderer, x, w);
        if (GTK.GTK3) {
            if (this.parent.pixbufSizeSet) {
                if (x[0] > 0) {
                    rect.x += x[0];
                }
            } else {
                int textRenderer = this.parent.getTextRenderer(column);
                if (textRenderer == 0) {
                    return new Rectangle(0, 0, 0, 0);
                }
                int[] xText = new int[1];
                int[] wText = new int[1];
                this.gtk_tree_view_column_cell_get_position(column, textRenderer, xText, wText);
                rect.x += xText[0];
            }
        } else {
            rect.x += x[0];
        }
        rect.width = w[0];
        int width = GTK.gtk_tree_view_column_get_visible(column) ? rect.width : 0;
        return new Rectangle(rect.x, rect.y, width, rect.height + 1);
    }

    public int getItemCount() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        return GTK.gtk_tree_model_iter_n_children(this.parent.modelHandle, this.handle);
    }

    public TreeItem getItem(int index) {
        int itemCount;
        this.checkWidget();
        if (index < 0) {
            this.error(6);
        }
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        if (index >= (itemCount = GTK.gtk_tree_model_iter_n_children(this.parent.modelHandle, this.handle))) {
            this.error(6);
        }
        return this.parent._getItem(this.handle, index);
    }

    public TreeItem[] getItems() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        return this.parent.getItems(this.handle);
    }

    @Override
    String getNameText() {
        if ((this.parent.style & 0x10000000) != 0 && !this.cached) {
            return "*virtual*";
        }
        return super.getNameText();
    }

    public Tree getParent() {
        this.checkWidget();
        return this.parent;
    }

    public TreeItem getParentItem() {
        this.checkWidget();
        int path = GTK.gtk_tree_model_get_path(this.parent.modelHandle, this.handle);
        TreeItem item = null;
        int depth = GTK.gtk_tree_path_get_depth(path);
        if (depth > 1) {
            GTK.gtk_tree_path_up(path);
            int iter = OS.g_malloc(GTK.GtkTreeIter_sizeof());
            if (GTK.gtk_tree_model_get_iter(this.parent.modelHandle, iter, path)) {
                item = this.parent._getItem(iter);
            }
            OS.g_free(iter);
        }
        GTK.gtk_tree_path_free(path);
        return item;
    }

    @Override
    public String getText() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        return this.getText(0);
    }

    public String getText(int index) {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        if (this.strings != null && index >= 0 && index < this.strings.length) {
            String string = this.strings[index];
            return string != null ? string : "";
        }
        return this._getText(index);
    }

    public Rectangle getTextBounds(int index) {
        this.checkWidget();
        return DPIUtil.autoScaleDown(this.getTextBoundsInPixels(index));
    }

    Rectangle getTextBoundsInPixels(int index) {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        int count = Math.max(1, this.parent.getColumnCount());
        if (index < 0 || index > count - 1) {
            return new Rectangle(0, 0, 0, 0);
        }
        int parentHandle = this.parent.handle;
        int column = 0;
        column = index >= 0 && index < this.parent.columnCount ? this.parent.columns[index].handle : GTK.gtk_tree_view_get_column(parentHandle, index);
        if (column == 0) {
            return new Rectangle(0, 0, 0, 0);
        }
        int textRenderer = this.parent.getTextRenderer(column);
        int pixbufRenderer = this.parent.getPixbufRenderer(column);
        if (textRenderer == 0 || pixbufRenderer == 0) {
            return new Rectangle(0, 0, 0, 0);
        }
        int path = GTK.gtk_tree_model_get_path(this.parent.modelHandle, this.handle);
        GTK.gtk_widget_realize(parentHandle);
        boolean isExpander = GTK.gtk_tree_model_iter_n_children(this.parent.modelHandle, this.handle) > 0;
        boolean isExpanded = GTK.gtk_tree_view_row_expanded(parentHandle, path);
        GTK.gtk_tree_view_column_cell_set_cell_data(column, this.parent.modelHandle, this.handle, isExpander, isExpanded);
        GdkRectangle rect = new GdkRectangle();
        GTK.gtk_tree_view_get_cell_area(parentHandle, path, column, rect);
        if ((this.parent.getStyle() & 0x8000000) != 0) {
            rect.x = this.parent.getClientWidth() - rect.width - rect.x;
        }
        int right = rect.x + rect.width;
        int[] x = new int[1];
        int[] w = new int[1];
        this.parent.ignoreSize = true;
        this.gtk_cell_renderer_get_preferred_size(textRenderer, parentHandle, w, null);
        this.parent.ignoreSize = false;
        int[] buffer = new int[1];
        GTK.gtk_tree_path_free(path);
        GTK.gtk_widget_style_get(parentHandle, OS.horizontal_separator, buffer, 0);
        int horizontalSeparator = buffer[0];
        rect.x += horizontalSeparator;
        this.gtk_tree_view_column_cell_get_position(column, textRenderer, x, null);
        if (GTK.GTK3) {
            Image image = this._getImage(index);
            int imageWidth = 0;
            if (image != null) {
                imageWidth = DPIUtil.useCairoAutoScale() ? image.getBounds().width : image.getBoundsInPixels().width;
            }
            rect.x = x[0] < imageWidth ? (rect.x += imageWidth) : (rect.x += x[0]);
        } else {
            rect.x += x[0];
        }
        if (this.parent.columnCount > 0 && rect.x + rect.width > right) {
            rect.width = Math.max(0, right - rect.x);
        }
        int width = GTK.gtk_tree_view_column_get_visible(column) ? rect.width + 1 : 0;
        return new Rectangle(rect.x, rect.y, width, rect.height + 1);
    }

    public int indexOf(TreeItem item) {
        int indices;
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        if (item.isDisposed()) {
            this.error(5);
        }
        int index = -1;
        boolean isParent = false;
        int currentPath = GTK.gtk_tree_model_get_path(this.parent.modelHandle, this.handle);
        int parentPath = GTK.gtk_tree_model_get_path(this.parent.modelHandle, item.handle);
        int depth = GTK.gtk_tree_path_get_depth(parentPath);
        if (depth > 1 && GTK.gtk_tree_path_up(parentPath) && GTK.gtk_tree_path_compare(currentPath, parentPath) == 0) {
            isParent = true;
        }
        GTK.gtk_tree_path_free(currentPath);
        GTK.gtk_tree_path_free(parentPath);
        if (!isParent) {
            return index;
        }
        int path = GTK.gtk_tree_model_get_path(this.parent.modelHandle, item.handle);
        if (depth > 1 && (indices = GTK.gtk_tree_path_get_indices(path)) != 0) {
            int[] temp = new int[depth];
            C.memmove(temp, indices, 4 * temp.length);
            index = temp[temp.length - 1];
        }
        GTK.gtk_tree_path_free(path);
        return index;
    }

    @Override
    void releaseChildren(boolean destroy) {
        if (destroy) {
            this.parent.releaseItems(this.handle);
        }
        super.releaseChildren(destroy);
    }

    @Override
    void releaseHandle() {
        if (this.handle != 0) {
            OS.g_free(this.handle);
        }
        this.handle = 0;
        super.releaseHandle();
        this.parent = null;
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        this.font = null;
        this.cellFont = null;
        this.strings = null;
    }

    public void removeAll() {
        this.checkWidget();
        int modelHandle = this.parent.modelHandle;
        int length = GTK.gtk_tree_model_iter_n_children(modelHandle, this.handle);
        if (length == 0) {
            return;
        }
        int iter = OS.g_malloc(GTK.GtkTreeIter_sizeof());
        if (iter == 0) {
            this.error(2);
        }
        if (this.parent.fixAccessibility()) {
            this.parent.ignoreAccessibility = true;
        }
        int selection = GTK.gtk_tree_view_get_selection(this.parent.handle);
        int[] value = new int[1];
        while (GTK.gtk_tree_model_iter_children(modelHandle, iter, this.handle)) {
            Widget item;
            GTK.gtk_tree_model_get(modelHandle, iter, 0, value, -1);
            Widget widget = item = value[0] != -1 ? this.parent.items[value[0]] : null;
            if (item != null && !item.isDisposed()) {
                item.dispose();
                continue;
            }
            OS.g_signal_handlers_block_matched(selection, 16, 0, 0, 0, 0, 6);
            GTK.gtk_tree_store_remove(modelHandle, iter);
            OS.g_signal_handlers_unblock_matched(selection, 16, 0, 0, 0, 0, 6);
        }
        if (this.parent.fixAccessibility()) {
            this.parent.ignoreAccessibility = false;
            OS.g_object_notify(this.parent.handle, OS.model);
        }
        OS.g_free(iter);
    }

    public void setBackground(Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            this.error(5);
        }
        if (this._getBackground().equals(color)) {
            return;
        }
        if (GTK.GTK3) {
            GdkRGBA gdkRGBA = color != null ? color.handleRGBA : null;
            GTK.gtk_tree_store_set(this.parent.modelHandle, this.handle, 4, gdkRGBA, -1);
        } else {
            GdkColor gdkColor = color != null ? color.handle : null;
            GTK.gtk_tree_store_set(this.parent.modelHandle, this.handle, 4, gdkColor, -1);
        }
        this.cached = true;
    }

    public void setBackground(int index, Color color) {
        int modelIndex;
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            this.error(5);
        }
        if (this._getBackground(index).equals(color)) {
            return;
        }
        int count = Math.max(1, this.parent.getColumnCount());
        if (index < 0 || index > count - 1) {
            return;
        }
        int n = modelIndex = this.parent.columnCount == 0 ? 6 : this.parent.columns[index].modelIndex;
        if (GTK.GTK3) {
            GdkRGBA gdkRGBA = color != null ? color.handleRGBA : null;
            GTK.gtk_tree_store_set(this.parent.modelHandle, this.handle, modelIndex + 3, gdkRGBA, -1);
        } else {
            GdkColor gdkColor = color != null ? color.handle : null;
            GTK.gtk_tree_store_set(this.parent.modelHandle, this.handle, modelIndex + 3, gdkColor, -1);
        }
        this.cached = true;
        this.updated = true;
        if (color != null) {
            boolean customDraw;
            boolean bl = customDraw = this.parent.columnCount == 0 ? this.parent.firstCustomDraw : this.parent.columns[index].customDraw;
            if (!customDraw) {
                if ((this.parent.style & 0x10000000) == 0) {
                    int parentHandle = this.parent.handle;
                    int column = 0;
                    column = this.parent.columnCount > 0 ? this.parent.columns[index].handle : GTK.gtk_tree_view_get_column(parentHandle, index);
                    if (column == 0) {
                        return;
                    }
                    int textRenderer = this.parent.getTextRenderer(column);
                    int imageRenderer = this.parent.getPixbufRenderer(column);
                    GTK.gtk_tree_view_column_set_cell_data_func(column, textRenderer, this.display.cellDataProc, parentHandle, 0);
                    GTK.gtk_tree_view_column_set_cell_data_func(column, imageRenderer, this.display.cellDataProc, parentHandle, 0);
                }
                if (this.parent.columnCount == 0) {
                    this.parent.firstCustomDraw = true;
                } else {
                    this.parent.columns[index].customDraw = true;
                }
            }
        }
    }

    public void setChecked(boolean checked) {
        this.checkWidget();
        if ((this.parent.style & 0x20) == 0) {
            return;
        }
        if (this._getChecked() == checked) {
            return;
        }
        GTK.gtk_tree_store_set(this.parent.modelHandle, this.handle, 1, checked, -1);
        GTK.gtk_tree_store_set(this.parent.modelHandle, this.handle, 2, !checked ? false : this.grayed, -1);
        this.cached = true;
    }

    public void setExpanded(boolean expanded) {
        this.checkWidget();
        int path = GTK.gtk_tree_model_get_path(this.parent.modelHandle, this.handle);
        if (expanded != GTK.gtk_tree_view_row_expanded(this.parent.handle, path)) {
            if (expanded) {
                OS.g_signal_handlers_block_matched(this.parent.handle, 16, 0, 0, 0, 0, 51);
                GTK.gtk_tree_view_expand_row(this.parent.handle, path, false);
                OS.g_signal_handlers_unblock_matched(this.parent.handle, 16, 0, 0, 0, 0, 51);
            } else {
                OS.g_signal_handlers_block_matched(this.parent.handle, 16, 0, 0, 0, 0, 50);
                GTK.gtk_widget_realize(this.parent.handle);
                GTK.gtk_tree_view_collapse_row(this.parent.handle, path);
                OS.g_signal_handlers_unblock_matched(this.parent.handle, 16, 0, 0, 0, 0, 50);
            }
        }
        GTK.gtk_tree_path_free(path);
        this.isExpanded = expanded;
    }

    public void setFont(Font font) {
        Font oldFont;
        this.checkWidget();
        if (font != null && font.isDisposed()) {
            this.error(5);
        }
        if ((oldFont = this.font) == font) {
            return;
        }
        this.font = font;
        if (oldFont != null && oldFont.equals(font)) {
            return;
        }
        int fontHandle = font != null ? font.handle : 0;
        GTK.gtk_tree_store_set(this.parent.modelHandle, this.handle, 5, fontHandle, -1);
        this.cached = true;
    }

    public void setFont(int index, Font font) {
        Font oldFont;
        this.checkWidget();
        if (font != null && font.isDisposed()) {
            this.error(5);
        }
        int count = Math.max(1, this.parent.getColumnCount());
        if (index < 0 || index > count - 1) {
            return;
        }
        if (this.cellFont == null) {
            if (font == null) {
                return;
            }
            this.cellFont = new Font[count];
        }
        if ((oldFont = this.cellFont[index]) == font) {
            return;
        }
        this.cellFont[index] = font;
        if (oldFont != null && oldFont.equals(font)) {
            return;
        }
        int modelIndex = this.parent.columnCount == 0 ? 6 : this.parent.columns[index].modelIndex;
        int fontHandle = font != null ? font.handle : 0;
        GTK.gtk_tree_store_set(this.parent.modelHandle, this.handle, modelIndex + 4, fontHandle, -1);
        this.cached = true;
        if (font != null) {
            boolean customDraw;
            boolean bl = customDraw = this.parent.columnCount == 0 ? this.parent.firstCustomDraw : this.parent.columns[index].customDraw;
            if (!customDraw) {
                if ((this.parent.style & 0x10000000) == 0) {
                    int parentHandle = this.parent.handle;
                    int column = 0;
                    column = this.parent.columnCount > 0 ? this.parent.columns[index].handle : GTK.gtk_tree_view_get_column(parentHandle, index);
                    if (column == 0) {
                        return;
                    }
                    int textRenderer = this.parent.getTextRenderer(column);
                    int imageRenderer = this.parent.getPixbufRenderer(column);
                    GTK.gtk_tree_view_column_set_cell_data_func(column, textRenderer, this.display.cellDataProc, parentHandle, 0);
                    GTK.gtk_tree_view_column_set_cell_data_func(column, imageRenderer, this.display.cellDataProc, parentHandle, 0);
                }
                if (this.parent.columnCount == 0) {
                    this.parent.firstCustomDraw = true;
                } else {
                    this.parent.columns[index].customDraw = true;
                }
            }
        }
    }

    public void setForeground(Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            this.error(5);
        }
        if (this._getForeground().equals(color)) {
            return;
        }
        if (GTK.GTK3) {
            GdkRGBA gdkRGBA = color != null ? color.handleRGBA : null;
            GTK.gtk_tree_store_set(this.parent.modelHandle, this.handle, 3, gdkRGBA, -1);
        } else {
            GdkColor gdkColor = color != null ? color.handle : null;
            GTK.gtk_tree_store_set(this.parent.modelHandle, this.handle, 3, gdkColor, -1);
        }
        this.cached = true;
    }

    public void setForeground(int index, Color color) {
        int modelIndex;
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            this.error(5);
        }
        if (this._getForeground(index).equals(color)) {
            return;
        }
        int count = Math.max(1, this.parent.getColumnCount());
        if (index < 0 || index > count - 1) {
            return;
        }
        int n = modelIndex = this.parent.columnCount == 0 ? 6 : this.parent.columns[index].modelIndex;
        if (GTK.GTK3) {
            GdkRGBA gdkRGBA = color != null ? color.handleRGBA : null;
            GTK.gtk_tree_store_set(this.parent.modelHandle, this.handle, modelIndex + 2, gdkRGBA, -1);
        } else {
            GdkColor gdkColor = color != null ? color.handle : null;
            GTK.gtk_tree_store_set(this.parent.modelHandle, this.handle, modelIndex + 2, gdkColor, -1);
        }
        this.cached = true;
        this.updated = true;
        if (color != null) {
            boolean customDraw;
            boolean bl = customDraw = this.parent.columnCount == 0 ? this.parent.firstCustomDraw : this.parent.columns[index].customDraw;
            if (!customDraw) {
                if ((this.parent.style & 0x10000000) == 0) {
                    int parentHandle = this.parent.handle;
                    int column = 0;
                    column = this.parent.columnCount > 0 ? this.parent.columns[index].handle : GTK.gtk_tree_view_get_column(parentHandle, index);
                    if (column == 0) {
                        return;
                    }
                    int textRenderer = this.parent.getTextRenderer(column);
                    int imageRenderer = this.parent.getPixbufRenderer(column);
                    GTK.gtk_tree_view_column_set_cell_data_func(column, textRenderer, this.display.cellDataProc, parentHandle, 0);
                    GTK.gtk_tree_view_column_set_cell_data_func(column, imageRenderer, this.display.cellDataProc, parentHandle, 0);
                }
                if (this.parent.columnCount == 0) {
                    this.parent.firstCustomDraw = true;
                } else {
                    this.parent.columns[index].customDraw = true;
                }
            }
        }
    }

    public void setGrayed(boolean grayed) {
        this.checkWidget();
        if ((this.parent.style & 0x20) == 0) {
            return;
        }
        if (this.grayed == grayed) {
            return;
        }
        this.grayed = grayed;
        int[] ptr = new int[1];
        GTK.gtk_tree_model_get(this.parent.modelHandle, this.handle, 1, ptr, -1);
        GTK.gtk_tree_store_set(this.parent.modelHandle, this.handle, 2, ptr[0] == 0 ? false : grayed, -1);
        this.cached = true;
    }

    public void setImage(int index, Image image) {
        int column;
        int parentHandle;
        int modelIndex;
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        if (image != null && image.type == 1 && image.equals(this._getImage(index))) {
            return;
        }
        int count = Math.max(1, this.parent.getColumnCount());
        if (index < 0 || index > count - 1) {
            return;
        }
        int pixbuf = 0;
        if (image != null) {
            int imageIndex;
            ImageList imageList = this.parent.imageList;
            if (imageList == null) {
                imageList = this.parent.imageList = new ImageList();
            }
            if ((imageIndex = imageList.indexOf(image)) == -1) {
                imageIndex = imageList.add(image);
            }
            pixbuf = imageList.getPixbuf(imageIndex);
        }
        int n = modelIndex = this.parent.columnCount == 0 ? 6 : this.parent.columns[index].modelIndex;
        if (GTK.GTK3) {
            if (DPIUtil.useCairoAutoScale() && !this.parent.ownerDraw && image != null && DPIUtil.getDeviceZoom() != 100) {
                Rectangle imgSize = image.getBounds();
                int scaledPixbuf = GDK.gdk_pixbuf_scale_simple(pixbuf, imgSize.width, imgSize.height, 2);
                if (scaledPixbuf != 0) {
                    pixbuf = scaledPixbuf;
                }
            }
            parentHandle = this.parent.handle;
            column = GTK.gtk_tree_view_get_column(parentHandle, index);
            int pixbufRenderer = this.parent.getPixbufRenderer(column);
            int[] currentWidth = new int[1];
            int[] currentHeight = new int[1];
            GTK.gtk_cell_renderer_get_fixed_size(pixbufRenderer, currentWidth, currentHeight);
            if (!this.parent.pixbufSizeSet) {
                if (image != null) {
                    int iHeight;
                    int iWidth;
                    if (DPIUtil.useCairoAutoScale()) {
                        iWidth = image.getBounds().width;
                        iHeight = image.getBounds().height;
                    } else {
                        iWidth = image.getBoundsInPixels().width;
                        iHeight = image.getBoundsInPixels().height;
                    }
                    if (iWidth > currentWidth[0] || iHeight > currentHeight[0]) {
                        GTK.gtk_cell_renderer_set_fixed_size(pixbufRenderer, iWidth, iHeight);
                        this.parent.pixbufSizeSet = true;
                        this.parent.pixbufHeight = iHeight;
                        this.parent.pixbufWidth = iWidth;
                        if ((this.parent.style & 0x10000000) != 0) {
                            boolean check = modelIndex == 6 && (this.parent.style & 0x20) != 0;
                            this.parent.createRenderers(column, modelIndex, check, this.parent.style);
                        }
                    }
                }
            } else if (this.parent.pixbufWidth > Math.max(currentWidth[0], 0) || this.parent.pixbufHeight > Math.max(currentHeight[0], 0)) {
                GTK.gtk_cell_renderer_set_fixed_size(pixbufRenderer, this.parent.pixbufWidth, this.parent.pixbufHeight);
            }
        }
        GTK.gtk_tree_store_set(this.parent.modelHandle, this.handle, modelIndex + 0, pixbuf, -1);
        if ((this.parent.style & 0x10000000) != 0 && this.parent.currentItem == null && image != null) {
            parentHandle = this.parent.handle;
            column = GTK.gtk_tree_view_get_column(parentHandle, index);
            int[] w = new int[1];
            int pixbufRenderer = this.parent.getPixbufRenderer(column);
            this.gtk_tree_view_column_cell_get_position(column, pixbufRenderer, null, w);
            int iWidth = GTK.GTK3 && DPIUtil.useCairoAutoScale() ? image.getBounds().width : image.getBoundsInPixels().width;
            if (w[0] < iWidth && !GTK.GTK3) {
                int style = GTK.gtk_widget_get_modifier_style(parentHandle);
                this.parent.modifyStyle(parentHandle, style);
            }
        }
        this.cached = true;
        this.updated = true;
    }

    @Override
    public void setImage(Image image) {
        this.checkWidget();
        this.setImage(0, image);
    }

    public void setImage(Image[] images) {
        this.checkWidget();
        if (images == null) {
            this.error(4);
        }
        int i = 0;
        while (i < images.length) {
            this.setImage(i, images[i]);
            ++i;
        }
    }

    public void setItemCount(int count) {
        this.checkWidget();
        count = Math.max(0, count);
        this.parent.setItemCount(this.handle, count);
    }

    public void setText(int index, String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (this.strings == null ? this._getText(index).equals(string) : this.getText(index).equals(string)) {
            return;
        }
        int count = Math.max(1, this.parent.getColumnCount());
        if (index < 0 || index > count - 1) {
            return;
        }
        if (index >= 0 && index < count) {
            if (this.strings == null) {
                this.strings = new String[count];
            }
            if (string.equals(this.strings[index])) {
                return;
            }
            this.strings[index] = string;
        }
        if (string != null && string.length() > 8192) {
            string = String.valueOf(string.substring(0, 8192 - "...".length())) + "...";
        }
        byte[] buffer = Converter.wcsToMbcs(string, true);
        int modelIndex = this.parent.columnCount == 0 ? 6 : this.parent.columns[index].modelIndex;
        GTK.gtk_tree_store_set(this.parent.modelHandle, this.handle, modelIndex + 1, buffer, -1);
        this.cached = true;
        this.updated = true;
    }

    @Override
    public void setText(String string) {
        this.checkWidget();
        this.setText(0, string);
    }

    public void setText(String[] strings) {
        this.checkWidget();
        if (strings == null) {
            this.error(4);
        }
        int i = 0;
        while (i < strings.length) {
            String string = strings[i];
            if (string != null) {
                this.setText(i, string);
            }
            ++i;
        }
    }
}

