/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.css.swt.properties.custom;

import org.eclipse.e4.ui.css.core.dom.properties.Gradient;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.swt.helpers.CSSSWTColorHelper;
import org.eclipse.e4.ui.css.swt.properties.AbstractCSSPropertySWTHandler;
import org.eclipse.e4.ui.internal.css.swt.ICTabRendering;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolderRenderer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Listener;
import org.w3c.dom.css.CSSValue;

public class CSSPropertyUnselectedTabsSWTHandler
extends AbstractCSSPropertySWTHandler {
    private static final String UNSELECTED_TABS_COLOR_PROP = "swt-unselected-tabs-color";
    private static final String DEPRECATED_UNSELECTED_TABS_COLOR_PROP = "unselected-tabs-color";
    private static final String RESIZE_LISTENER = "CSSPropertyUnselectedTabsSWTHandler.resizeListener";

    @Override
    protected void applyCSSProperty(Control control, String property, CSSValue value, String pseudo, CSSEngine engine) throws Exception {
        if (!(control instanceof CTabFolder) || !this.isUnselectedTabsColorProp(property)) {
            return;
        }
        CTabFolder folder = (CTabFolder)control;
        CTabFolderRenderer renderer = folder.getRenderer();
        if (!(renderer instanceof ICTabRendering)) {
            return;
        }
        if (value.getCssValueType() == 1) {
            Color color = (Color)engine.convert(value, Color.class, (Object)control.getDisplay());
            ((ICTabRendering)renderer).setUnselectedTabsColor(color);
            folder.setBackground(color);
            this.removeResizeEventListener(folder);
            return;
        }
        if (value.getCssValueType() == 2) {
            Gradient grad = (Gradient)engine.convert(value, Gradient.class, (Object)control.getDisplay());
            if (grad == null) {
                return;
            }
            Color[] colors = null;
            int[] percents = null;
            if (!grad.getValues().isEmpty()) {
                colors = CSSSWTColorHelper.getSWTColors(grad, control.getDisplay(), engine);
                percents = CSSSWTColorHelper.getPercents(grad);
            }
            ((ICTabRendering)renderer).setUnselectedTabsColor(colors, percents);
            folder.setBackground(colors, percents, true);
            this.appendResizeEventListener(folder);
        }
    }

    @Override
    protected String retrieveCSSProperty(Control control, String property, String pseudo, CSSEngine engine) throws Exception {
        return null;
    }

    private boolean isUnselectedTabsColorProp(String property) {
        return UNSELECTED_TABS_COLOR_PROP.equals(property) || DEPRECATED_UNSELECTED_TABS_COLOR_PROP.equals(property);
    }

    private void appendResizeEventListener(CTabFolder folder) {
        if (this.hasResizeEventListener(folder)) {
            return;
        }
        final Listener resizeListener = event -> {
            CTabFolder folder1 = (CTabFolder)event.widget;
            Control[] controlArray = folder1.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                if (this.isReskinRequired(child)) {
                    child.reskin(0);
                }
                ++n2;
            }
        };
        folder.addListener(11, resizeListener);
        folder.setData(RESIZE_LISTENER, (Object)resizeListener);
        folder.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                e.widget.removeListener(11, resizeListener);
            }
        });
    }

    private void removeResizeEventListener(CTabFolder folder) {
        Object obj = folder.getData(RESIZE_LISTENER);
        if (obj instanceof Listener) {
            folder.removeListener(11, (Listener)obj);
            folder.setData(RESIZE_LISTENER, null);
        }
    }

    private boolean hasResizeEventListener(CTabFolder folder) {
        return folder.getData(RESIZE_LISTENER) instanceof Listener;
    }

    private boolean isReskinRequired(Control control) {
        if (control instanceof Composite) {
            Composite composite = (Composite)control;
            return composite.isVisible() && composite.getChildren().length > 0;
        }
        return false;
    }
}

