/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edit.ui.provider;

import java.util.Collection;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Display;

public class NotifyChangedToViewerRefresh {
    public static void handleNotifyChanged(final Viewer viewer, final Object object, final int eventType, final Object feature, final Object oldValue, final Object newValue, final int index) {
        if (viewer.getControl() == null || viewer.getControl().isDisposed()) {
            return;
        }
        Display d = viewer.getControl().getDisplay();
        if (d != Display.getCurrent()) {
            d.asyncExec(new Runnable(){

                public void run() {
                    if (viewer.getControl() != null && !viewer.getControl().isDisposed()) {
                        new NotifyChangedToViewerRefresh().refresh(viewer, object, eventType, feature, oldValue, newValue, index);
                    }
                }
            });
        } else {
            new NotifyChangedToViewerRefresh().refresh(viewer, object, eventType, feature, oldValue, newValue, index);
        }
    }

    public void refresh(Viewer viewer, Object object, int eventType, Object feature, Object oldValue, Object newValue, int index) {
        if (viewer instanceof TreeViewer) {
            this.refreshTreeViewer((TreeViewer)viewer, object, eventType, feature, oldValue, newValue, index);
        } else if (viewer instanceof TableViewer) {
            this.refreshTableViewer((TableViewer)viewer, object, eventType, feature, oldValue, newValue, index);
        } else if (viewer instanceof ListViewer) {
            this.refreshListViewer((ListViewer)viewer, object, eventType, feature, oldValue, newValue, index);
        } else {
            this.refreshViewer(viewer, object, eventType, feature, oldValue, newValue, index);
        }
    }

    public void refreshTreeViewer(TreeViewer viewer, Object object, int eventType, Object feature, Object oldValue, Object newValue, int index) {
        switch (eventType) {
            default: 
        }
        this.refreshAbstractTreeViewer((AbstractTreeViewer)viewer, object, eventType, feature, oldValue, newValue, index);
    }

    public void refreshListViewer(ListViewer viewer, Object object, int eventType, Object feature, Object oldValue, Object newValue, int index) {
        switch (eventType) {
            case 3: {
                viewer.add(newValue);
                break;
            }
            case 5: {
                viewer.add(((Collection)newValue).toArray());
                break;
            }
            case 4: {
                viewer.remove(oldValue);
                break;
            }
            case 6: {
                viewer.remove(((Collection)oldValue).toArray());
                break;
            }
            case 7: {
                viewer.refresh();
            }
            default: {
                this.refreshStructuredViewer((StructuredViewer)viewer, object, eventType, feature, oldValue, newValue, index);
            }
        }
    }

    public void refreshTableViewer(TableViewer viewer, Object object, int eventType, Object feature, Object oldValue, Object newValue, int index) {
        switch (eventType) {
            case 3: {
                viewer.insert(newValue, index);
                break;
            }
            case 5: {
                if (index == -1) {
                    viewer.add(((Collection)newValue).toArray());
                    break;
                }
                for (Object value : (Collection)newValue) {
                    viewer.insert(value, index++);
                }
                break;
            }
            case 4: {
                viewer.remove(oldValue);
                break;
            }
            case 6: {
                viewer.remove(((Collection)oldValue).toArray());
                break;
            }
            default: {
                this.refreshStructuredViewer((StructuredViewer)viewer, object, eventType, feature, oldValue, newValue, index);
            }
        }
    }

    public void refreshAbstractTreeViewer(AbstractTreeViewer viewer, Object object, int eventType, Object feature, Object oldValue, Object newValue, int index) {
        switch (eventType) {
            case 3: {
                if (newValue == null) {
                    viewer.refresh(object);
                    break;
                }
                viewer.add(object, newValue);
                break;
            }
            case 5: {
                viewer.add(object, ((Collection)newValue).toArray());
                break;
            }
            case 4: {
                if (oldValue == null) {
                    viewer.refresh(object);
                    break;
                }
                viewer.remove(oldValue);
                break;
            }
            case 6: {
                viewer.remove(((Collection)oldValue).toArray());
                break;
            }
            default: {
                this.refreshStructuredViewer((StructuredViewer)viewer, object, eventType, feature, oldValue, newValue, index);
            }
        }
    }

    public void refreshStructuredViewer(StructuredViewer viewer, Object object, int eventType, Object feature, Object oldValue, Object newValue, int index) {
        switch (eventType) {
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                viewer.refresh(object);
                break;
            }
            case 1: 
            case 2: {
                String[] stringArray;
                if (feature instanceof EReference) {
                    viewer.refresh(object);
                    break;
                }
                if (feature instanceof ENamedElement) {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = ((ENamedElement)feature).getName();
                } else {
                    stringArray = null;
                }
                viewer.update(object, stringArray);
                break;
            }
            default: {
                this.refreshViewer((Viewer)viewer, object, eventType, feature, oldValue, newValue, index);
            }
        }
    }

    public void refreshViewer(Viewer viewer, Object object, int eventType, Object feature, Object oldValue, Object newValue, int index) {
        switch (eventType) {
            case 9: {
                break;
            }
            default: {
                viewer.refresh();
            }
        }
    }
}

