/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.transport.ecf;

import java.io.FileNotFoundException;
import java.net.ConnectException;
import java.net.URI;
import java.net.UnknownHostException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.ecf.core.identity.IDCreateException;
import org.eclipse.ecf.filetransfer.BrowseFileTransferException;
import org.eclipse.ecf.filetransfer.IncomingFileTransferException;
import org.eclipse.equinox.internal.p2.repository.DownloadStatus;
import org.eclipse.equinox.internal.p2.transport.ecf.Messages;
import org.eclipse.osgi.util.NLS;

public class RepositoryStatus {
    public static String codeToMessage(int code, String toDownload) {
        switch (code) {
            case 400: {
                return NLS.bind((String)Messages.TransportErrorTranslator_400, (Object)toDownload);
            }
            case 401: {
                return NLS.bind((String)Messages.TransportErrorTranslator_401, (Object)toDownload);
            }
            case 402: {
                return NLS.bind((String)Messages.TransportErrorTranslator_402, (Object)toDownload);
            }
            case 403: {
                return NLS.bind((String)Messages.TransportErrorTranslator_403, (Object)toDownload);
            }
            case 404: {
                return NLS.bind((String)Messages.TransportErrorTranslator_404, (Object)toDownload);
            }
            case 405: {
                return NLS.bind((String)Messages.TransportErrorTranslator_405, (Object)toDownload);
            }
            case 406: {
                return NLS.bind((String)Messages.TransportErrorTranslator_406, (Object)toDownload);
            }
            case 407: {
                return NLS.bind((String)Messages.TransportErrorTranslator_407, (Object)toDownload);
            }
            case 408: {
                return NLS.bind((String)Messages.TransportErrorTranslator_408, (Object)toDownload);
            }
            case 409: {
                return NLS.bind((String)Messages.TransportErrorTranslator_409, (Object)toDownload);
            }
            case 410: {
                return NLS.bind((String)Messages.TransportErrorTranslator_410, (Object)toDownload);
            }
            case 411: {
                return NLS.bind((String)Messages.TransportErrorTranslator_411, (Object)toDownload);
            }
            case 412: {
                return NLS.bind((String)Messages.TransportErrorTranslator_412, (Object)toDownload);
            }
            case 413: {
                return NLS.bind((String)Messages.TransportErrorTranslator_413, (Object)toDownload);
            }
            case 414: {
                return NLS.bind((String)Messages.TransportErrorTranslator_414, (Object)toDownload);
            }
            case 415: {
                return NLS.bind((String)Messages.TransportErrorTranslator_415, (Object)toDownload);
            }
            case 416: {
                return NLS.bind((String)Messages.TransportErrorTranslator_416, (Object)toDownload);
            }
            case 417: {
                return NLS.bind((String)Messages.TransportErrorTranslator_417, (Object)toDownload);
            }
            case 418: {
                return NLS.bind((String)Messages.TransportErrorTranslator_418, (Object)toDownload);
            }
            case 422: {
                return NLS.bind((String)Messages.TransportErrorTranslator_422, (Object)toDownload);
            }
            case 423: {
                return NLS.bind((String)Messages.TransportErrorTranslator_423, (Object)toDownload);
            }
            case 424: {
                return NLS.bind((String)Messages.TransportErrorTranslator_424, (Object)toDownload);
            }
            case 425: {
                return NLS.bind((String)Messages.TransportErrorTranslator_425, (Object)toDownload);
            }
            case 426: {
                return NLS.bind((String)Messages.TransportErrorTranslator_426, (Object)toDownload);
            }
            case 449: {
                return NLS.bind((String)Messages.TransportErrorTranslator_449, (Object)toDownload);
            }
            case 450: {
                return NLS.bind((String)Messages.TransportErrorTranslator_450, (Object)toDownload);
            }
            case 500: {
                return NLS.bind((String)Messages.TransportErrorTranslator_500, (Object)toDownload);
            }
            case 501: {
                return NLS.bind((String)Messages.TransportErrorTranslator_501, (Object)toDownload);
            }
            case 502: {
                return NLS.bind((String)Messages.TransportErrorTranslator_502, (Object)toDownload);
            }
            case 503: {
                return NLS.bind((String)Messages.TransportErrorTranslator_503, (Object)toDownload);
            }
            case 504: {
                return NLS.bind((String)Messages.TransportErrorTranslator_504, (Object)toDownload);
            }
            case 505: {
                return NLS.bind((String)Messages.TransportErrorTranslator_505, (Object)toDownload);
            }
            case 506: {
                return NLS.bind((String)Messages.TransportErrorTranslator_506, (Object)toDownload);
            }
            case 507: {
                return NLS.bind((String)Messages.TransportErrorTranslator_507, (Object)toDownload);
            }
            case 508: {
                return NLS.bind((String)Messages.TransportErrorTranslator_508, (Object)toDownload);
            }
            case 510: {
                return NLS.bind((String)Messages.TransportErrorTranslator_510, (Object)toDownload);
            }
        }
        return NLS.bind((String)Messages.TransportErrorTranslator_UnknownErrorCode, (Object)Integer.toString(code), (Object)toDownload);
    }

    public static DownloadStatus forStatus(IStatus original, URI toDownload) {
        Throwable t = original.getException();
        return RepositoryStatus.forException(t, toDownload);
    }

    public static DownloadStatus forException(Throwable t, URI toDownload) {
        if (t instanceof FileNotFoundException || t instanceof IncomingFileTransferException && ((IncomingFileTransferException)t).getErrorCode() == 404) {
            return new DownloadStatus(4, "org.eclipse.equinox.p2.transport.ecf", 1200, NLS.bind((String)Messages.artifact_not_found, (Object)toDownload), t);
        }
        if (t instanceof ConnectException) {
            return new DownloadStatus(4, "org.eclipse.equinox.p2.transport.ecf", 1002, NLS.bind((String)Messages.TransportErrorTranslator_UnableToConnectToRepository_0, (Object)toDownload), t);
        }
        if (t instanceof UnknownHostException) {
            return new DownloadStatus(4, "org.eclipse.equinox.p2.transport.ecf", 1006, NLS.bind((String)Messages.TransportErrorTranslator_UnknownHost, (Object)toDownload), t);
        }
        if (t instanceof IDCreateException) {
            IStatus status = ((IDCreateException)t).getStatus();
            if (status != null && status.getException() != null) {
                t = status.getException();
            }
            return new DownloadStatus(4, "org.eclipse.equinox.p2.transport.ecf", 1006, NLS.bind((String)Messages.TransportErrorTranslator_MalformedRemoteFileReference, (Object)toDownload), t);
        }
        int code = 0;
        int provisionCode = 1002;
        if (t instanceof IncomingFileTransferException) {
            code = ((IncomingFileTransferException)t).getErrorCode();
        } else if (t instanceof BrowseFileTransferException) {
            code = ((BrowseFileTransferException)t).getErrorCode();
        }
        if (code == 401) {
            provisionCode = 1007;
        } else if (code == 404) {
            provisionCode = 1200;
        }
        return new DownloadStatus(4, "org.eclipse.equinox.p2.transport.ecf", provisionCode, code == 0 ? NLS.bind((String)Messages.io_failedRead, (Object)toDownload) : RepositoryStatus.codeToMessage(code, toDownload.toString()), t);
    }
}

