/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.css.swt.properties.css2;

import java.lang.reflect.Method;
import org.eclipse.e4.ui.css.core.dom.properties.css2.AbstractCSSPropertyPaddingHandler;
import org.eclipse.e4.ui.css.core.dom.properties.css2.CSS2PaddingPropertiesImpl;
import org.eclipse.e4.ui.css.core.dom.properties.css2.ICSSPropertyPaddingHandler;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.swt.helpers.SWTElementHelpers;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolderRenderer;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Widget;
import org.w3c.css.sac.CSSException;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.CSSValue;
import org.w3c.dom.css.CSSValueList;

public class CSSPropertyPaddingSWTHandler
extends AbstractCSSPropertyPaddingHandler {
    public static final ICSSPropertyPaddingHandler INSTANCE = new CSSPropertyPaddingSWTHandler();

    public boolean applyCSSProperty(Object element, String property, CSSValue value, String pseudo, CSSEngine engine) throws Exception {
        Widget widget = SWTElementHelpers.getWidget(element);
        if (widget == null) {
            return false;
        }
        super.applyCSSProperty(element, property, value, pseudo, engine);
        return true;
    }

    public void applyCSSPropertyPadding(Object element, CSSValue value, String pseudo, CSSEngine engine) throws Exception {
        CSS2PaddingPropertiesImpl padding = new CSS2PaddingPropertiesImpl();
        if (value.getCssValueType() == 1) {
            padding.left = padding.right = value;
            padding.bottom = padding.right;
            padding.top = padding.right;
            this.setPadding(element, (CSSValue)padding, pseudo);
            return;
        }
        if (value.getCssValueType() == 2) {
            CSSValueList valueList = (CSSValueList)value;
            int length = valueList.getLength();
            if (length < 2 || length > 4) {
                throw new CSSException("Invalid padding property list length");
            }
            switch (length) {
                case 4: {
                    padding.top = valueList.item(0);
                    padding.right = valueList.item(1);
                    padding.bottom = valueList.item(2);
                    padding.left = valueList.item(3);
                    break;
                }
                case 3: {
                    padding.top = valueList.item(0);
                    padding.right = valueList.item(1);
                    padding.bottom = valueList.item(2);
                    padding.left = valueList.item(1);
                    break;
                }
                case 2: {
                    padding.top = valueList.item(0);
                    padding.right = valueList.item(1);
                    padding.bottom = valueList.item(0);
                    padding.left = valueList.item(1);
                }
            }
        } else {
            throw new CSSException("Invalid padding property value");
        }
        this.setPadding(element, (CSSValue)padding, pseudo);
    }

    public void applyCSSPropertyPaddingTop(Object element, CSSValue value, String pseudo, CSSEngine engine) throws Exception {
        CSS2PaddingPropertiesImpl padding = new CSS2PaddingPropertiesImpl();
        if (value.getCssValueType() == 1) {
            padding.top = value;
            this.setPadding(element, (CSSValue)padding, pseudo);
        }
    }

    public void applyCSSPropertyPaddingRight(Object element, CSSValue value, String pseudo, CSSEngine engine) throws Exception {
        CSS2PaddingPropertiesImpl padding = new CSS2PaddingPropertiesImpl();
        if (value.getCssValueType() == 1) {
            padding.right = value;
            this.setPadding(element, (CSSValue)padding, pseudo);
        }
    }

    public void applyCSSPropertyPaddingBottom(Object element, CSSValue value, String pseudo, CSSEngine engine) throws Exception {
        CSS2PaddingPropertiesImpl padding = new CSS2PaddingPropertiesImpl();
        if (value.getCssValueType() == 1) {
            padding.bottom = value;
            this.setPadding(element, (CSSValue)padding, pseudo);
        }
    }

    public void applyCSSPropertyPaddingLeft(Object element, CSSValue value, String pseudo, CSSEngine engine) throws Exception {
        CSS2PaddingPropertiesImpl padding = new CSS2PaddingPropertiesImpl();
        if (value.getCssValueType() == 1) {
            padding.left = value;
            this.setPadding(element, (CSSValue)padding, pseudo);
        }
    }

    public String retrieveCSSPropertyPadding(Object element, String pseudo, CSSEngine engine) throws Exception {
        return null;
    }

    public String retrieveCSSPropertyPaddingTop(Object element, String pseudo, CSSEngine engine) throws Exception {
        return null;
    }

    public String retrieveCSSPropertyPaddingRight(Object element, String pseudo, CSSEngine engine) throws Exception {
        return null;
    }

    public String retrieveCSSPropertyPaddingBottom(Object element, String pseudo, CSSEngine engine) throws Exception {
        return null;
    }

    public String retrieveCSSPropertyPaddingLeft(Object element, String pseudo, CSSEngine engine) throws Exception {
        return null;
    }

    private void setPadding(Object element, CSSValue value, String pseudo) {
        Widget widget = SWTElementHelpers.getWidget(element);
        if (widget instanceof CTabFolder) {
            CTabFolder folder = (CTabFolder)widget;
            CTabFolderRenderer renderer = folder.getRenderer();
            if (renderer == null) {
                return;
            }
            try {
                Method m = renderer.getClass().getMethod("getPadding", new Class[0]);
                Rectangle pad = (Rectangle)m.invoke((Object)renderer, new Object[0]);
                CSS2PaddingPropertiesImpl padding = (CSS2PaddingPropertiesImpl)value;
                CSSValue vTop = padding.top;
                CSSValue vRight = padding.right;
                CSSValue vBottom = padding.bottom;
                CSSValue vLeft = padding.left;
                int top = pad.x;
                int right = pad.y;
                int bottom = pad.width;
                int left = pad.height;
                if (vTop != null && vTop.getCssValueType() == 1 && ((CSSPrimitiveValue)vTop).getPrimitiveType() == 5) {
                    top = (int)((CSSPrimitiveValue)vTop).getFloatValue((short)5);
                }
                if (vRight != null && vRight.getCssValueType() == 1 && ((CSSPrimitiveValue)vRight).getPrimitiveType() == 5) {
                    right = (int)((CSSPrimitiveValue)vRight).getFloatValue((short)5);
                }
                if (vBottom != null && vBottom.getCssValueType() == 1 && ((CSSPrimitiveValue)vBottom).getPrimitiveType() == 5) {
                    bottom = (int)((CSSPrimitiveValue)vBottom).getFloatValue((short)5);
                }
                if (vLeft != null && vLeft.getCssValueType() == 1 && ((CSSPrimitiveValue)vLeft).getPrimitiveType() == 5) {
                    left = (int)((CSSPrimitiveValue)vLeft).getFloatValue((short)5);
                }
                if (top != pad.x || right != pad.y || bottom != pad.width || left != pad.height) {
                    Method m2 = renderer.getClass().getMethod("setPadding", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
                    m2.invoke((Object)renderer, left, right, top, bottom);
                }
            }
            catch (Exception exception) {}
        }
    }
}

