/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.garbagecollector;

import java.util.Map;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.equinox.internal.p2.garbagecollector.GCActivator;
import org.eclipse.equinox.internal.p2.garbagecollector.GarbageCollector;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.IProvisioningAgentProvider;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProfileRegistry;

public class Application
implements IApplication {
    private String profileId;
    private IProvisioningAgent agent;

    private IProfile getProfile(String id) {
        IProfileRegistry profileRegistry = (IProfileRegistry)this.agent.getService(IProfileRegistry.SERVICE_NAME);
        return profileRegistry == null ? null : profileRegistry.getProfile(id);
    }

    public Object start(IApplicationContext context) throws Exception {
        Map allArgs = context.getArguments();
        String[] args = (String[])allArgs.get("application.args");
        this.processArguments(args);
        if (this.profileId == null) {
            this.profileId = "_SELF_";
        }
        this.initializeServices();
        IProfile profile = this.getProfile(this.profileId);
        if (profile == null) {
            throw new IllegalArgumentException("\"" + this.profileId + "\" is not a valid profile identifier.");
        }
        GarbageCollector gc = (GarbageCollector)this.agent.getService(GarbageCollector.SERVICE_NAME);
        gc.runGC(profile);
        this.agent.stop();
        return null;
    }

    private void initializeServices() throws ProvisionException {
        IProvisioningAgentProvider provider = GCActivator.getService(IProvisioningAgentProvider.class);
        this.agent = provider.createAgent(null);
    }

    public void stop() {
    }

    public void processArguments(String[] args) throws Exception {
        if (args == null) {
            return;
        }
        int i = 0;
        while (i < args.length) {
            String opt = args[i];
            if (i != args.length - 1 && !args[i + 1].startsWith("-")) {
                String arg = args[++i];
                if (opt.equalsIgnoreCase("-profile")) {
                    this.profileId = arg;
                }
            }
            ++i;
        }
    }
}

