/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.internal;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.concurrent.atomic.AtomicReference;
import org.ops4j.pax.web.service.spi.ServletEvent;
import org.ops4j.pax.web.service.spi.ServletListener;
import org.ops4j.pax.web.service.spi.WebEvent;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventAdminHandler
implements ServletListener,
ServiceTrackerCustomizer<EventAdmin, EventAdmin> {
    private static final Logger LOG = LoggerFactory.getLogger(EventAdminHandler.class);
    private AtomicReference<EventAdmin> eventAdminReference = new AtomicReference();
    private final BundleContext bundleContext;

    public EventAdminHandler(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    @Override
    public void servletEvent(ServletEvent servletEvent) {
        EventAdmin eventAdmin = this.eventAdminReference.get();
        if (eventAdmin != null) {
            String topic;
            switch (servletEvent.getType()) {
                case 1: {
                    topic = WebEvent.WebTopic.DEPLOYING.toString();
                    break;
                }
                case 2: {
                    topic = WebEvent.WebTopic.DEPLOYED.toString();
                    break;
                }
                case 3: {
                    topic = WebEvent.WebTopic.UNDEPLOYING.toString();
                    break;
                }
                case 4: {
                    topic = WebEvent.WebTopic.UNDEPLOYED.toString();
                    break;
                }
                default: {
                    topic = WebEvent.WebTopic.FAILED.toString();
                }
            }
            Hashtable<String, Object> properties = new Hashtable<String, Object>();
            ((Dictionary)properties).put("servlet.alias", servletEvent.getAlias() == null ? "" : servletEvent.getAlias());
            ((Dictionary)properties).put("servlet.name", servletEvent.getServletName() == null ? "" : servletEvent.getServletName());
            ((Dictionary)properties).put("servlet.urlparameter", servletEvent.getUrlParameter() == null ? "" : servletEvent.getUrlParameter());
            if (servletEvent.getServlet() != null) {
                ((Dictionary)properties).put("servlet.servlet", servletEvent.getServlet());
            }
            ((Dictionary)properties).put("timestamp", servletEvent.getTimestamp());
            if (servletEvent.getHttpContext() != null) {
                ((Dictionary)properties).put("servlet.httpcontext", servletEvent.getHttpContext());
            }
            Event event = new Event(topic, properties);
            eventAdmin.postEvent(event);
        }
    }

    public EventAdmin addingService(ServiceReference<EventAdmin> reference) {
        if (reference.isAssignableTo(this.bundleContext.getBundle(), "org.osgi.service.event.EventAdmin")) {
            EventAdmin eventService = (EventAdmin)this.bundleContext.getService(reference);
            try {
                if (eventService instanceof EventAdmin) {
                    EventAdmin old = this.eventAdminReference.getAndSet(eventService);
                    if (old != null) {
                        LOG.debug("replace old EventAdmin instance {} by an instance of {}", (Object)old.getClass().getName(), (Object)eventService.getClass().getName());
                    }
                    return eventService;
                }
            }
            catch (NoClassDefFoundError e) {
                LOG.warn("An EventAdmin service was found, but the corresponding class can't be loaded, make sure to have a compatible org.osgi.service.event package exported with version range [1.3,2.0)");
            }
            this.bundleContext.ungetService(reference);
        } else {
            LOG.warn("An EventAdmin service was found, but it is not assignable to this bundle, make sure to have a compatible org.osgi.service.event package exported with version range [1.3,2.0)");
        }
        return null;
    }

    public void modifiedService(ServiceReference<EventAdmin> reference, EventAdmin service) {
    }

    public void removedService(ServiceReference<EventAdmin> reference, EventAdmin service) {
        this.bundleContext.ungetService(reference);
        try {
            if (service instanceof EventAdmin) {
                this.eventAdminReference.compareAndSet(service, null);
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }
}

