/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.spi.util;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import org.apache.commons.collections4.map.LRUMap;
import org.ops4j.pax.swissbox.core.BundleClassLoader;
import org.osgi.framework.Bundle;

public class ResourceDelegatingBundleClassLoader
extends BundleClassLoader {
    private List<Bundle> bundles;
    private int cacheSize = 100;
    private static ThreadLocal<LRUMap<String, Enumeration<URL>>> lruCache = new ThreadLocal();

    public ResourceDelegatingBundleClassLoader(List<Bundle> bundles) {
        super(bundles.get(0));
        this.bundles = bundles;
    }

    public ResourceDelegatingBundleClassLoader(List<Bundle> bundles, ClassLoader parent) {
        super(bundles.get(0), parent);
        this.bundles = bundles;
    }

    public void addBundle(Bundle bundle) {
        this.bundles.add(bundle);
    }

    public List<Bundle> getBundles() {
        return this.bundles;
    }

    @Override
    protected URL findResource(String name) {
        for (Bundle delegate : this.bundles) {
            try {
                URL resource = delegate.getResource(name);
                if (resource == null) continue;
                return resource;
            }
            catch (IllegalStateException exc) {
            }
        }
        return null;
    }

    @Override
    protected Enumeration<URL> findResources(String name) throws IOException {
        Enumeration<URL> url = this.getFromCache(name);
        if (url != null) {
            return url;
        }
        Vector resources = new Vector();
        for (Bundle delegate : this.bundles) {
            try {
                Enumeration urls = delegate.getResources(name);
                if (urls == null) continue;
                while (urls.hasMoreElements()) {
                    resources.add(urls.nextElement());
                }
            }
            catch (IllegalStateException exc) {
            }
        }
        url = resources.elements();
        this.addToCache(name, url);
        return url;
    }

    protected void addToCache(String name, Enumeration<URL> urls) {
        if (lruCache.get() == null) {
            lruCache.set(new LRUMap(this.cacheSize));
        }
        lruCache.get().put(name, urls);
    }

    protected Enumeration<URL> getFromCache(String name) {
        Enumeration<URL> url = null;
        if (lruCache.get() != null) {
            url = lruCache.get().get(name);
        }
        return url;
    }
}

