/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.adapter.p2.internal.servlet;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.packagedrone.repo.MetaKey;
import org.eclipse.packagedrone.repo.channel.ArtifactInformation;

public final class MavenLocator {
    public static final MetaKey KEY_GROUP_ID = new MetaKey("mvn", "groupId");
    public static final MetaKey KEY_ARTIFACT_ID = new MetaKey("mvn", "artifactId");
    public static final MetaKey KEY_VERSION = new MetaKey("mvn", "version");
    public static final MetaKey KEY_SNAPSHOT_VERSION = new MetaKey("mvn", "snapshotVersion");
    public static final MetaKey KEY_EXTENSION = new MetaKey("mvn", "extension");
    public static final MetaKey KEY_CLASSIFIER = new MetaKey("mvn", "classifier");

    private MavenLocator() {
    }

    public static List<ArtifactInformation> findByMavenCoordinates(@NonNull Collection<ArtifactInformation> artifacts, @Nullable String groupId, @Nullable String artifactId, @Nullable String version, @Nullable String snapshotVersion, @Nullable String extension, @Nullable String classifier) {
        Stream<ArtifactInformation> s = MavenLocator.filterByCoordinates(artifacts.stream(), groupId, artifactId, version, snapshotVersion, extension, classifier);
        return s.collect(Collectors.toList());
    }

    public static <T extends ArtifactInformation> @NonNull Stream<T> filterByCoordinates(@NonNull Stream<T> s, @Nullable String groupId, @Nullable String artifactId, @Nullable String version, @Nullable String snapshotVersion, @Nullable String extension, @Nullable String classifier) {
        s = s.filter(art -> MavenLocator.has(art, KEY_GROUP_ID, groupId));
        s = s.filter(art -> MavenLocator.has(art, KEY_ARTIFACT_ID, artifactId));
        s = s.filter(art -> MavenLocator.has(art, KEY_VERSION, version));
        s = s.filter(art -> MavenLocator.has(art, KEY_SNAPSHOT_VERSION, snapshotVersion));
        s = s.filter(art -> MavenLocator.has(art, KEY_EXTENSION, extension));
        s = s.filter(art -> MavenLocator.has(art, KEY_CLASSIFIER, classifier));
        return s;
    }

    private static boolean has(ArtifactInformation art, MetaKey key, String expectedValue) {
        String actualValue = (String)art.getMetaData().get(key);
        if (actualValue == expectedValue) {
            return true;
        }
        if (actualValue == null) {
            return false;
        }
        return actualValue.equals(expectedValue);
    }

    private static @Nullable String get(@NonNull ArtifactInformation art, MetaKey key) {
        Objects.requireNonNull(art);
        return (String)art.getMetaData().get(key);
    }

    public static @Nullable String getGroupId(@NonNull ArtifactInformation art) {
        return MavenLocator.get(art, KEY_GROUP_ID);
    }

    public static @Nullable String getArtifactId(@NonNull ArtifactInformation art) {
        return MavenLocator.get(art, KEY_ARTIFACT_ID);
    }

    public static @Nullable String getVersion(@NonNull ArtifactInformation art) {
        return MavenLocator.get(art, KEY_VERSION);
    }

    public static @Nullable String getSnapshotVersion(@NonNull ArtifactInformation art) {
        return MavenLocator.get(art, KEY_SNAPSHOT_VERSION);
    }

    public static @Nullable String getExtension(@NonNull ArtifactInformation art) {
        return MavenLocator.get(art, KEY_EXTENSION);
    }

    public static @Nullable String getClassifier(@NonNull ArtifactInformation art) {
        return MavenLocator.get(art, KEY_CLASSIFIER);
    }
}

