/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.manage.usage;

import java.time.Instant;
import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.eclipse.packagedrone.VersionInformation;
import org.eclipse.packagedrone.repo.MetaKey;
import org.eclipse.packagedrone.repo.channel.ChannelService;
import org.eclipse.packagedrone.repo.channel.stats.ChannelStatistics;
import org.eclipse.packagedrone.repo.manage.core.CoreService;
import org.eclipse.packagedrone.repo.manage.usage.Pinger;
import org.eclipse.packagedrone.repo.manage.usage.Statistics;
import org.eclipse.packagedrone.utils.scheduler.ScheduledTask;

public class PingJob
implements ScheduledTask {
    private static final MetaKey PROP_ID = new MetaKey("core", "random-id");
    private static final MetaKey PROP_TS = new MetaKey("core", "random-id-timestamp");
    private static final long MAX_DIFF = TimeUnit.DAYS.toMillis(7L);
    private ChannelService channelService;
    private CoreService coreService;
    private Instant lastPing;

    public void setCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    public void setChannelService(ChannelService channelService) {
        this.channelService = channelService;
    }

    public void run() throws Exception {
        if (this.isActive()) {
            new Pinger(this.buildStatistics()).start();
            this.lastPing = Instant.now();
        }
    }

    public Instant getLastPing() {
        return this.lastPing;
    }

    private String makeId() {
        String id = this.coreService.getCoreProperty(PROP_ID);
        if (id == null) {
            return this.setNewId();
        }
        Long ts = null;
        try {
            ts = Long.parseLong(this.coreService.getCoreProperty(PROP_TS));
        }
        catch (Exception exception) {}
        if (ts == null || System.currentTimeMillis() - ts > MAX_DIFF) {
            return this.setNewId();
        }
        return id;
    }

    private String setNewId() {
        String id = UUID.randomUUID().toString();
        HashMap<MetaKey, String> map = new HashMap<MetaKey, String>(2);
        map.put(PROP_ID, id);
        map.put(PROP_TS, "" + System.currentTimeMillis());
        this.coreService.setCoreProperties(map);
        return id;
    }

    public Statistics buildStatistics() {
        Statistics result = new Statistics();
        ChannelStatistics serviceStats = this.channelService.getStatistics();
        result.setRandomId(this.makeId());
        result.setVersion(VersionInformation.VERSION);
        result.setNumberOfArtifacts(serviceStats.getTotalNumberOfArtifacts());
        result.setNumberOfBytes(serviceStats.getTotalNumberOfBytes());
        return result;
    }

    public boolean isActive() {
        return !Boolean.getBoolean("drone.usage.disable");
    }
}

