/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.channel.apm.aspect;

import java.io.OutputStream;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Map;
import org.eclipse.packagedrone.repo.MetaKey;
import org.eclipse.packagedrone.repo.aspect.virtual.Virtualizer;
import org.eclipse.packagedrone.repo.channel.ArtifactInformation;
import org.eclipse.packagedrone.repo.channel.apm.aspect.ArtifactType;
import org.eclipse.packagedrone.repo.channel.apm.aspect.AspectContextImpl;
import org.eclipse.packagedrone.repo.channel.apm.aspect.AspectableContext;
import org.eclipse.packagedrone.repo.generator.GenerationContext;
import org.eclipse.packagedrone.utils.Exceptions;
import org.eclipse.packagedrone.utils.io.IOConsumer;

public class VirtualizerContextImpl
implements Virtualizer.Context,
GenerationContext {
    private final String virtualizerAspectId;
    private final Path tmp;
    private final ArtifactInformation artifact;
    private final AspectableContext context;
    private final AspectContextImpl.ArtifactCreator creator;
    private final ArtifactType type;

    public VirtualizerContextImpl(String virtualizerAspectId, Path tmp, ArtifactInformation artifact, AspectableContext context, AspectContextImpl.ArtifactCreator creator, ArtifactType type) {
        this.virtualizerAspectId = virtualizerAspectId;
        this.tmp = tmp;
        this.artifact = artifact;
        this.context = context;
        this.creator = creator;
        this.type = type;
    }

    public Map<MetaKey, String> getProvidedChannelMetaData() {
        return this.context.getChannelProvidedMetaData();
    }

    public ArtifactInformation getOtherArtifactInformation(String artifactId) {
        return this.context.getArtifacts().get(artifactId);
    }

    public Collection<ArtifactInformation> getChannelArtifacts() {
        return this.context.getArtifacts().values();
    }

    public Path getFile() {
        return this.tmp;
    }

    public ArtifactInformation getArtifactInformation() {
        return this.artifact;
    }

    public void createVirtualArtifact(String name, IOConsumer<OutputStream> stream, Map<MetaKey, String> providedMetaData) {
        Exceptions.wrapException(() -> this.creator.internalCreateArtifact(this.artifact.getId(), stream, name, providedMetaData, this.type, this.virtualizerAspectId));
    }
}

