/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.web.common.table;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.function.Function;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.packagedrone.web.common.table.ContentProvider;
import org.eclipse.packagedrone.web.common.table.TableColumn;
import org.eclipse.packagedrone.web.common.table.TableDescriptor;

public interface TableColumnProvider {
    public @NonNull TableColumn getColumn();

    public void provideContent(@NonNull TableDescriptor var1, Object var2, @NonNull PrintWriter var3) throws IOException;

    public static <T> TableColumnProvider stringProvider(@NonNull TableColumn column, @NonNull Class<T> clazz, @NonNull Function<T, String> func) {
        return TableColumnProvider.provider(column, clazz, (item, out) -> {
            String value = (String)func.apply(item);
            if (value != null) {
                out.write(value);
            }
        });
    }

    public static <T> TableColumnProvider provider(final @NonNull TableColumn column, final @NonNull Class<T> clazz, final @NonNull ContentProvider<T> provider) {
        return new TableColumnProvider(){

            @Override
            public @NonNull TableColumn getColumn() {
                return column;
            }

            @Override
            public void provideContent(@NonNull TableDescriptor descriptor, Object object, @NonNull PrintWriter out) throws IOException {
                if (object == null) {
                    return;
                }
                if (clazz.isAssignableFrom(object.getClass())) {
                    @NonNull T value = clazz.cast(object);
                    provider.provide(value, out);
                }
            }
        };
    }
}

