/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.adapter.maven;

import org.eclipse.packagedrone.repo.MetaKeyBinding;

public class MavenInformation {
    @MetaKeyBinding(namespace="mvn", key="groupId")
    private String groupId;
    @MetaKeyBinding(namespace="mvn", key="artifactId")
    private String artifactId;
    @MetaKeyBinding(namespace="mvn", key="version")
    private String version;
    @MetaKeyBinding(namespace="mvn", key="classifier")
    private String classifier;
    @MetaKeyBinding(namespace="mvn", key="extension")
    private String extension;
    @MetaKeyBinding(namespace="mvn", key="snapshotVersion")
    private String snapshotVersion;
    @MetaKeyBinding(namespace="mvn", key="buildNumber")
    private Long buildNumber;

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public void setClassifier(String classifier) {
        this.classifier = classifier;
    }

    public String getExtension() {
        return this.extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public String getSnapshotVersion() {
        return this.snapshotVersion;
    }

    public void setSnapshotVersion(String snapshotVersion) {
        this.snapshotVersion = snapshotVersion;
    }

    public void setBuildNumber(Long buildNumber) {
        this.buildNumber = buildNumber;
    }

    public Long getBuildNumber() {
        return this.buildNumber;
    }

    public String makePath() {
        StringBuilder sb = new StringBuilder();
        this.appendPath(sb);
        sb.append('/');
        this.appendFile(sb, false);
        return sb.toString();
    }

    public String makeName() {
        StringBuilder sb = new StringBuilder();
        this.appendFile(sb, false);
        return sb.toString();
    }

    public String makePlainName() {
        StringBuilder sb = new StringBuilder();
        this.appendFile(sb, true);
        return sb.toString();
    }

    public boolean isPrimary() {
        return this.classifier == null || this.classifier.isEmpty();
    }

    protected void appendFile(StringBuilder sb, boolean ignoreClassifier) {
        sb.append(this.artifactId);
        sb.append('-');
        if (this.snapshotVersion != null) {
            sb.append(this.snapshotVersion);
        } else {
            sb.append(this.version);
        }
        if (this.classifier != null && !ignoreClassifier) {
            sb.append('-');
            sb.append(this.classifier);
        }
        sb.append('.');
        sb.append(this.extension);
    }

    protected void appendPath(StringBuilder sb) {
        sb.append(this.groupId);
        sb.append('/');
        sb.append(this.artifactId);
        sb.append('/');
        sb.append(this.version);
    }

    public boolean isSnapshot() {
        return this.version != null && this.version.endsWith("-SNAPSHOT");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.groupId);
        sb.append('/');
        this.appendFile(sb, false);
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.artifactId == null ? 0 : this.artifactId.hashCode());
        result = 31 * result + (this.buildNumber == null ? 0 : this.buildNumber.hashCode());
        result = 31 * result + (this.classifier == null ? 0 : this.classifier.hashCode());
        result = 31 * result + (this.extension == null ? 0 : this.extension.hashCode());
        result = 31 * result + (this.groupId == null ? 0 : this.groupId.hashCode());
        result = 31 * result + (this.snapshotVersion == null ? 0 : this.snapshotVersion.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MavenInformation)) {
            return false;
        }
        MavenInformation other = (MavenInformation)obj;
        if (this.artifactId == null ? other.artifactId != null : !this.artifactId.equals(other.artifactId)) {
            return false;
        }
        if (this.buildNumber == null ? other.buildNumber != null : !this.buildNumber.equals(other.buildNumber)) {
            return false;
        }
        if (this.classifier == null ? other.classifier != null : !this.classifier.equals(other.classifier)) {
            return false;
        }
        if (this.extension == null ? other.extension != null : !this.extension.equals(other.extension)) {
            return false;
        }
        if (this.groupId == null ? other.groupId != null : !this.groupId.equals(other.groupId)) {
            return false;
        }
        if (this.snapshotVersion == null ? other.snapshotVersion != null : !this.snapshotVersion.equals(other.snapshotVersion)) {
            return false;
        }
        return !(this.version == null ? other.version != null : !this.version.equals(other.version));
    }
}

