/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.aspect.mvnosgi.web;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.annotation.HttpConstraint;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.eclipse.packagedrone.repo.MetaKeys;
import org.eclipse.packagedrone.repo.aspect.mvnosgi.web.Configuration;
import org.eclipse.packagedrone.repo.channel.ChannelInformation;
import org.eclipse.packagedrone.repo.channel.ChannelService;
import org.eclipse.packagedrone.repo.channel.ModifiableChannel;
import org.eclipse.packagedrone.repo.channel.ReadableChannel;
import org.eclipse.packagedrone.repo.web.utils.Channels;
import org.eclipse.packagedrone.sec.web.controller.HttpContraintControllerInterceptor;
import org.eclipse.packagedrone.sec.web.controller.Secured;
import org.eclipse.packagedrone.sec.web.controller.SecuredControllerInterceptor;
import org.eclipse.packagedrone.web.Controller;
import org.eclipse.packagedrone.web.LinkTarget;
import org.eclipse.packagedrone.web.ModelAndView;
import org.eclipse.packagedrone.web.RequestMapping;
import org.eclipse.packagedrone.web.RequestMethod;
import org.eclipse.packagedrone.web.ViewResolver;
import org.eclipse.packagedrone.web.common.CommonController;
import org.eclipse.packagedrone.web.common.InterfaceExtender;
import org.eclipse.packagedrone.web.common.menu.MenuEntry;
import org.eclipse.packagedrone.web.controller.ControllerInterceptor;
import org.eclipse.packagedrone.web.controller.ControllerInterceptors;
import org.eclipse.packagedrone.web.controller.binding.BindingResult;
import org.eclipse.packagedrone.web.controller.binding.PathVariable;
import org.eclipse.packagedrone.web.controller.form.FormData;

@Controller
@RequestMapping(value={"/aspect/mvnosgi/{channelId}"})
@ViewResolver(value="/WEB-INF/views/aspect/%s.jsp")
@Secured
@ControllerInterceptors(value={@ControllerInterceptor(value=SecuredControllerInterceptor.class), @ControllerInterceptor(value=HttpContraintControllerInterceptor.class)})
@HttpConstraint(rolesAllowed={"MANAGER"})
public class AspectController
implements InterfaceExtender {
    private ChannelService service;

    public void setService(ChannelService service) {
        this.service = service;
    }

    @RequestMapping(value={"/config"})
    public ModelAndView config(@PathVariable(value="channelId") String channelId) {
        return Channels.withChannel((ChannelService)this.service, (String)channelId, ReadableChannel.class, channel -> {
            HashMap<String, Object> model = new HashMap<String, Object>();
            model.put("channel", channel.getInformation());
            Configuration data = new Configuration();
            try {
                MetaKeys.bind((Object)data, (Map)channel.getMetaData());
                model.put("command", data);
            }
            catch (Exception exception) {}
            return new ModelAndView("config", model);
        });
    }

    @RequestMapping(value={"/config"}, method={RequestMethod.POST})
    public ModelAndView configPost(@PathVariable(value="channelId") String channelId, @FormData(value="command") @Valid Configuration data, BindingResult result) {
        return Channels.withChannel((ChannelService)this.service, (String)channelId, ModifiableChannel.class, channel -> {
            if (!result.hasErrors()) {
                try {
                    channel.applyMetaData(MetaKeys.unbind((Object)data));
                }
                catch (Exception e) {
                    return CommonController.createError((String)"Error", (String)"Failed to update", (Throwable)e);
                }
            }
            HashMap<String, ChannelInformation> model = new HashMap<String, ChannelInformation>();
            model.put("channel", channel.getInformation());
            return new ModelAndView("config", model);
        });
    }

    public List<MenuEntry> getActions(HttpServletRequest request, Object object) {
        if (!(object instanceof ChannelInformation)) {
            return null;
        }
        ChannelInformation channel = (ChannelInformation)object;
        if (!channel.hasAspect("mvnosgi")) {
            return null;
        }
        if (!request.isUserInRole("MANAGER")) {
            return null;
        }
        LinkedList<MenuEntry> result = new LinkedList<MenuEntry>();
        Map<String, String> model = Collections.singletonMap("channelId", channel.getId());
        result.add(new MenuEntry("Edit", Integer.MAX_VALUE, "Maven POM Creator", 1001, LinkTarget.createFromController(AspectController.class, (String)"config").expand(model), null, null));
        return result;
    }
}

