/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.manage.todo;

import java.util.Comparator;
import org.eclipse.packagedrone.repo.manage.todo.PriorityComparator;
import org.eclipse.packagedrone.web.LinkTarget;
import org.eclipse.packagedrone.web.RequestMethod;
import org.eclipse.packagedrone.web.common.Button;
import org.eclipse.packagedrone.web.common.Modifier;

public interface Task {
    public static final Button DEFAULT_BUTTON = new Button("Link", null, Modifier.LINK);
    public static final Comparator<Task> PRIORITY_COMPARATOR = PriorityComparator.INSTANCE;

    public State getState();

    public String getTitle();

    public String getDescription();

    public LinkTarget getTarget();

    default public RequestMethod getTargetRequestMethod() {
        return RequestMethod.GET;
    }

    default public Button getButton() {
        return DEFAULT_BUTTON;
    }

    public int getPriority();

    default public boolean isDone() {
        return this.getState() == State.DONE;
    }

    default public boolean isOpen() {
        return this.getState() != State.DONE;
    }

    public static enum State {
        TODO,
        FAILED,
        DONE;

    }
}

