/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.web.sitemap.servlet;

import java.io.IOException;
import java.io.Writer;
import java.util.Optional;
import java.util.function.Supplier;
import javax.servlet.http.HttpServletResponse;
import javax.xml.stream.XMLOutputFactory;
import org.eclipse.packagedrone.repo.web.sitemap.SitemapGenerator;
import org.eclipse.packagedrone.repo.web.sitemap.SitemapIndexContext;
import org.eclipse.packagedrone.repo.web.sitemap.SitemapIndexWriter;
import org.eclipse.packagedrone.repo.web.sitemap.UrlSetContext;
import org.eclipse.packagedrone.repo.web.sitemap.UrlSetContextCreator;
import org.eclipse.packagedrone.repo.web.sitemap.UrlSetWriter;
import org.eclipse.packagedrone.utils.Exceptions;
import org.osgi.framework.FrameworkUtil;
import org.osgi.util.tracker.ServiceTracker;

public class SitemapProcessor {
    private final Supplier<String> prefixSupplier;
    private final String sitemapUrl;
    private final XMLOutputFactory outputFactory;
    private final ServiceTracker<SitemapGenerator, SitemapGenerator> tracker;

    public SitemapProcessor(Supplier<String> prefixSupplier, String sitemapUrl, XMLOutputFactory outputFactory) {
        this.prefixSupplier = prefixSupplier;
        this.sitemapUrl = sitemapUrl;
        this.outputFactory = outputFactory;
        this.tracker = new ServiceTracker(FrameworkUtil.getBundle(SitemapProcessor.class).getBundleContext(), SitemapGenerator.class, null);
        this.tracker.open();
    }

    public void dispose() {
        this.tracker.close();
    }

    public boolean process(HttpServletResponse response, String path) throws IOException {
        if (path == null || path.isEmpty()) {
            this.processRoot(response);
            return true;
        }
        return this.processSub(response, path);
    }

    private void processRoot(HttpServletResponse response) throws IOException {
        String prefix = String.valueOf(Optional.ofNullable(this.prefixSupplier.get()).orElse("http://localhost")) + this.sitemapUrl;
        response.setContentType("text/xml");
        Throwable throwable = null;
        Object var4_5 = null;
        try (SitemapIndexWriter writer = new SitemapIndexWriter((Writer)response.getWriter(), prefix, this.outputFactory);){
            for (SitemapGenerator generator : this.tracker.getTracked().values()) {
                generator.gatherRoots((SitemapIndexContext)writer);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private boolean processSub(HttpServletResponse response, String path) throws IOException {
        ContextCreator creator = new ContextCreator(response);
        for (SitemapGenerator generator : this.tracker.getTracked().values()) {
            generator.render(path, (UrlSetContextCreator)creator);
            if (!creator.isUsed()) continue;
            creator.finish();
            return true;
        }
        return false;
    }

    private class ContextCreator
    implements UrlSetContextCreator {
        private final HttpServletResponse response;
        private boolean used;
        private Exceptions.ThrowingRunnable finish;

        public ContextCreator(HttpServletResponse response) {
            this.response = response;
        }

        public boolean isUsed() {
            return this.used;
        }

        public UrlSetContext createUrlSet() {
            if (this.used) {
                throw new IllegalStateException("Context creator may only be used once");
            }
            this.used = true;
            try {
                String prefix = Optional.ofNullable((String)SitemapProcessor.this.prefixSupplier.get()).orElse("http://localhost");
                this.response.setContentType("text/xml");
                UrlSetWriter result = new UrlSetWriter((Writer)this.response.getWriter(), prefix, SitemapProcessor.this.outputFactory);
                this.finish = () -> ((UrlSetWriter)result).finish();
                return result;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public void finish() {
            if (this.finish != null) {
                try {
                    this.finish.run();
                }
                catch (Exception exception) {}
            }
        }
    }
}

