/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.signing.pgp.web;

import java.io.IOException;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.packagedrone.repo.signing.SigningService;
import org.eclipse.packagedrone.repo.signing.pgp.web.AddEntry;
import org.eclipse.packagedrone.repo.signing.pgp.web.InformationEntry;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

public class ServiceManager {
    private static final String ID = "pgp.signer";
    public static final Object ACTION_TAG_PGP = new Object();
    private ConfigurationAdmin configAdmin;
    private final BundleContext context = FrameworkUtil.getBundle(ServiceManager.class).getBundleContext();

    public void setConfigAdmin(ConfigurationAdmin configAdmin) {
        this.configAdmin = configAdmin;
    }

    public List<InformationEntry> list() throws IOException, InvalidSyntaxException {
        LinkedList<InformationEntry> result = new LinkedList<InformationEntry>();
        Configuration[] list = this.configAdmin.listConfigurations(String.format("(%s=%s)", "service.factoryPid", ID));
        if (list != null) {
            Configuration[] configurationArray = list;
            int n = list.length;
            int n2 = 0;
            while (n2 < n) {
                Configuration cfg = configurationArray[n2];
                InformationEntry info = new InformationEntry();
                info.setId(cfg.getPid());
                Collection refs = this.context.getServiceReferences(SigningService.class, String.format("(%s=%s)", "service.pid", cfg.getPid()));
                info.setServicePresent(!refs.isEmpty());
                info.setKeyring(this.makeString(cfg.getProperties().get("keyring")));
                info.setKeyId(this.makeString(cfg.getProperties().get("key.id")));
                info.setLabel(this.makeString(cfg.getProperties().get("description")));
                result.add(info);
                ++n2;
            }
        }
        return result;
    }

    private String makeString(Object object) {
        if (object instanceof String) {
            return (String)object;
        }
        return null;
    }

    public void add(AddEntry data) throws IOException {
        Configuration cfg = this.configAdmin.createFactoryConfiguration(ID, null);
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ((Dictionary)properties).put("keyring", data.getKeyring());
        ((Dictionary)properties).put("key.id", data.getKeyId());
        ((Dictionary)properties).put("key.passphrase", data.getKeyPassphrase());
        ((Dictionary)properties).put("description", data.getLabel());
        cfg.update(properties);
    }

    public void delete(String pid) throws IOException {
        Configuration cfg = this.configAdmin.getConfiguration(pid);
        if (cfg != null) {
            cfg.delete();
        }
    }
}

