/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.channel.search;

import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import org.eclipse.packagedrone.repo.channel.ArtifactInformation;
import org.eclipse.packagedrone.repo.channel.search.Predicate;
import org.eclipse.packagedrone.repo.channel.search.SearchOptions;

public interface ArtifactLocator {
    default public List<ArtifactInformation> search(Predicate predicate) {
        return this.search(predicate, SearchOptions.DEFAULT_OPTIONS);
    }

    default public List<ArtifactInformation> search(Predicate predicate, SearchOptions options) {
        LinkedList<ArtifactInformation> result = new LinkedList<ArtifactInformation>();
        this.search(predicate, options, stream -> stream.forEach(result::add));
        return result;
    }

    default public void search(Predicate predicate, Consumer<Stream<? extends ArtifactInformation>> consumer) {
        this.search(predicate, SearchOptions.DEFAULT_OPTIONS, consumer);
    }

    default public void search(Predicate predicate, SearchOptions options, Consumer<Stream<? extends ArtifactInformation>> consumer) {
        this.process(predicate, options, stream -> {
            consumer.accept((Stream<? extends ArtifactInformation>)stream);
            return null;
        });
    }

    default public <R> R process(Predicate predicate, Function<Stream<? extends ArtifactInformation>, R> function) {
        return this.process(predicate, SearchOptions.DEFAULT_OPTIONS, function);
    }

    public <R> R process(Predicate var1, SearchOptions var2, Function<Stream<? extends ArtifactInformation>, R> var3);
}

