/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.channel.util;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.eclipse.packagedrone.repo.channel.ChannelInformation;
import org.eclipse.packagedrone.web.LinkTarget;
import org.eclipse.packagedrone.web.common.Modifier;
import org.eclipse.packagedrone.web.common.menu.MenuEntry;

public class RepositoryLinks {
    public static void fillRepoLinks(ChannelInformation channel, List<MenuEntry> links, String baseName, int basePriority, LinkTarget linkTemplate) {
        RepositoryLinks.fillRepoLinks(channel, links, baseName, basePriority, baseName, 10000, linkTemplate);
    }

    public static void fillRepoLinks(ChannelInformation channel, List<MenuEntry> links, String baseName, int basePriority, String prefix, int priorityOffset, LinkTarget linkTemplate) {
        Objects.requireNonNull(linkTemplate, "'linkTemplate' must not be null");
        RepositoryLinks.fillRepoLinks(channel, links, baseName, basePriority, prefix, priorityOffset, (String idOrName) -> RepositoryLinks.makeDefaultRepoLink(linkTemplate, idOrName));
    }

    public static void fillRepoLinks(ChannelInformation channel, List<MenuEntry> links, String baseName, int basePriority, String prefix, int priorityOffset, Function<String, LinkTarget> targetFunction) {
        Objects.requireNonNull(channel, "'channel' must not be null");
        Objects.requireNonNull(links, "'links' must not be null");
        Objects.requireNonNull(baseName, "'baseName' must not be null");
        Objects.requireNonNull(prefix, "'prefix' must not be null");
        Objects.requireNonNull(targetFunction, "'targetFunction' must not be null");
        links.add(new MenuEntry(baseName, basePriority, String.valueOf(prefix) + " (by ID)", priorityOffset, targetFunction.apply(channel.getId()), Modifier.LINK, null));
        int i = 1;
        for (String name : channel.getNames()) {
            LinkTarget target = targetFunction.apply(name);
            if (target != null) {
                links.add(new MenuEntry(baseName, basePriority, String.format("%s (name: %s)", prefix, name), priorityOffset + i, target, Modifier.LINK, null));
            }
            ++i;
        }
    }

    private static LinkTarget makeDefaultRepoLink(LinkTarget linkTemplate, String idOrName) {
        return linkTemplate.expand(Collections.singletonMap("idOrName", idOrName));
    }
}

