/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.web;

import java.io.IOException;
import java.util.Optional;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.packagedrone.utils.profiler.Profile;
import org.eclipse.packagedrone.web.ErrorHandler;
import org.eclipse.packagedrone.web.RequestHandler;
import org.eclipse.packagedrone.web.RequestHandlerFactory;
import org.eclipse.packagedrone.web.controller.ControllerTracker;
import org.eclipse.packagedrone.web.interceptor.Interceptor;
import org.eclipse.packagedrone.web.interceptor.InterceptorLocator;
import org.eclipse.packagedrone.web.interceptor.InterceptorTracker;
import org.eclipse.packagedrone.web.resources.ResourceTracker;
import org.eclipse.packagedrone.web.util.Responses;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DispatcherServlet
extends HttpServlet {
    private static final Logger logger = LoggerFactory.getLogger(DispatcherServlet.class);
    private static final long serialVersionUID = 1L;
    private RequestHandlerFactory resourceLocator;
    private RequestHandlerFactory controllerLocator;
    private InterceptorLocator interceptorLocator;
    private Optional<ErrorHandler> errorHandler = Optional.empty();

    public void init() throws ServletException {
        super.init();
        BundleContext context = FrameworkUtil.getBundle(DispatcherServlet.class).getBundleContext();
        this.resourceLocator = new ResourceTracker(context);
        this.controllerLocator = new ControllerTracker(context);
        this.interceptorLocator = new InterceptorTracker(context);
    }

    public void destroy() {
        if (this.resourceLocator != null) {
            this.resourceLocator.close();
            this.resourceLocator = null;
        }
        if (this.controllerLocator != null) {
            this.controllerLocator.close();
            this.controllerLocator = null;
        }
        if (this.interceptorLocator != null) {
            this.interceptorLocator.close();
            this.interceptorLocator = null;
        }
        super.destroy();
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = Optional.ofNullable(errorHandler);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        logger.trace("service - {} - {} ({})", new Object[]{request.getMethod(), request.getServletPath(), request});
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try {
                Profile.Handle handle = Profile.start((String)DispatcherServlet.makeOperationName(request));
                try {
                    Interceptor[] interceptors = this.interceptorLocator.getInterceptors();
                    this.runPreProcess(interceptors, request, response);
                    if (response.isCommitted()) {
                        return;
                    }
                    Exception ex = null;
                    try {
                        try {
                            Throwable throwable2 = null;
                            Object var9_15 = null;
                            try (RequestHandler requestHandler = this.mapRequest(request, response);){
                                if (requestHandler != null) {
                                    this.runPostProcess(interceptors, request, response, requestHandler);
                                    requestHandler.process(request, response);
                                    return;
                                }
                                Responses.notFound(request, response);
                                return;
                            }
                            catch (Throwable throwable3) {
                                if (throwable2 == null) {
                                    throwable2 = throwable3;
                                    throw throwable2;
                                }
                                if (throwable2 == throwable3) throw throwable2;
                                throwable2.addSuppressed(throwable3);
                                throw throwable2;
                            }
                        }
                        catch (ServletException e) {
                            throw e;
                        }
                        catch (Exception e) {
                            ex = e;
                            throw new ServletException((Throwable)e);
                        }
                    }
                    finally {
                        this.runAfterCompletion(interceptors, request, response, ex);
                    }
                }
                finally {
                    if (handle == null) return;
                    handle.close();
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                    throw throwable;
                }
                if (throwable == throwable4) throw throwable;
                throwable.addSuppressed(throwable4);
                throw throwable;
            }
        }
        catch (Exception e) {
            this.errorHandler.orElse(ErrorHandler.DEFAULT).handleError(request, response, e);
        }
    }

    private static String makeOperationName(HttpServletRequest request) {
        return String.format("%s|%s", request.getRequestURI(), request.getMethod());
    }

    protected void runAfterCompletion(Interceptor[] interceptors, HttpServletRequest request, HttpServletResponse response, Exception ex) throws Exception {
        Interceptor[] interceptorArray = interceptors;
        int n = interceptors.length;
        int n2 = 0;
        while (n2 < n) {
            Interceptor i = interceptorArray[n2];
            i.afterCompletion(request, response, ex);
            ++n2;
        }
    }

    protected void runPostProcess(Interceptor[] interceptors, HttpServletRequest request, HttpServletResponse response, RequestHandler result) throws Exception {
        Interceptor[] interceptorArray = interceptors;
        int n = interceptors.length;
        int n2 = 0;
        while (n2 < n) {
            Interceptor i = interceptorArray[n2];
            i.postHandle(request, response, result);
            ++n2;
        }
    }

    protected boolean runPreProcess(Interceptor[] interceptors, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Interceptor[] interceptorArray = interceptors;
        int n = interceptors.length;
        int n2 = 0;
        while (n2 < n) {
            Interceptor i = interceptorArray[n2];
            if (!i.preHandle(request, response)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    protected RequestHandler mapRequest(HttpServletRequest request, HttpServletResponse response) {
        RequestHandler handler = this.resourceLocator.handleRequest(request, response);
        if (handler != null) {
            return handler;
        }
        handler = this.controllerLocator.handleRequest(request, response);
        if (handler != null) {
            return handler;
        }
        return null;
    }
}

