/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.web.controller.binding;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.packagedrone.web.controller.binding.BindingError;
import org.eclipse.packagedrone.web.controller.binding.BindingManager;
import org.eclipse.packagedrone.web.controller.binding.BindingResult;

public class SimpleBindingResult
implements BindingResult {
    private final Map<String, BindingResult> children = new HashMap<String, BindingResult>();
    private final List<BindingError> errors = new LinkedList<BindingError>();
    private final Set<String> markers = new HashSet<String>();

    public void addMarkers(Set<String> markers) {
        this.markers.addAll(markers);
    }

    @Override
    public boolean hasErrors() {
        if (!this.errors.isEmpty()) {
            return true;
        }
        for (BindingResult br : this.children.values()) {
            if (!br.hasErrors()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasMarker(String marker) {
        if (this.markers.contains(marker)) {
            return true;
        }
        for (BindingResult br : this.children.values()) {
            if (!br.hasMarker(marker)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addChild(String name, BindingResult bindingResult) {
        this.children.put(name, bindingResult);
    }

    @Override
    public BindingResult getChild(String name) {
        return this.children.get(name);
    }

    @Override
    public BindingResult getChildOrAdd(String name) {
        BindingResult child = this.children.get(name);
        if (child == null) {
            child = new BindingManager.Result();
            this.children.put(name, child);
        }
        return child;
    }

    @Override
    public Map<String, BindingResult> getChildren() {
        return Collections.unmodifiableMap(this.children);
    }

    public void addErrors(String name, List<BindingError> errors) {
        BindingResult br = name == null || name.isEmpty() ? this : this.getChildOrAdd(name);
        br.addErrors(errors);
    }

    @Override
    public void addError(BindingError error) {
        this.errors.add(error);
    }

    @Override
    public void addErrors(Collection<BindingError> errors) {
        this.errors.addAll(errors);
    }

    @Override
    public List<BindingError> getErrors() {
        LinkedList<BindingError> result = new LinkedList<BindingError>(this.errors);
        for (BindingResult br : this.children.values()) {
            result.addAll(br.getErrors());
        }
        return result;
    }

    @Override
    public List<BindingError> getLocalErrors() {
        return Collections.unmodifiableList(this.errors);
    }
}

