/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.manage.setup.web;

import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.packagedrone.repo.manage.setup.web.internal.Activator;
import org.eclipse.packagedrone.web.interceptor.ModelAndViewInterceptorAdapter;
import org.eclipse.packagedrone.web.util.Requests;
import org.osgi.util.tracker.ServiceTracker;

public class SetupInterceptor
extends ModelAndViewInterceptorAdapter {
    private final ServiceTracker<?, ?> tracker;
    private final Set<String> ignoredPrefixes = new HashSet<String>();

    public SetupInterceptor() {
        this.ignoredPrefixes.add("/setup");
        this.ignoredPrefixes.add("/login");
        this.ignoredPrefixes.add("/logout");
        this.ignoredPrefixes.add("/resources");
        this.ignoredPrefixes.add("/system/backup");
        this.tracker = Activator.getTracker();
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String current = Requests.getOriginalPath((HttpServletRequest)request);
        if (current == null) {
            response.sendRedirect(String.valueOf(request.getContextPath()) + "/setup");
            return false;
        }
        for (String prefix : this.ignoredPrefixes) {
            if (!current.startsWith(prefix)) continue;
            return super.preHandle(request, response);
        }
        if (current.startsWith("/config") && request.getUserPrincipal() != null) {
            return super.preHandle(request, response);
        }
        if (this.tracker.getService() == null) {
            response.sendRedirect(String.valueOf(request.getContextPath()) + "/setup");
            return false;
        }
        return super.preHandle(request, response);
    }
}

