/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.adapter.maven;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import org.eclipse.packagedrone.repo.adapter.maven.ChannelData;

public class NodeAdapter
implements JsonSerializer<ChannelData.Node>,
JsonDeserializer<ChannelData.Node> {
    public JsonElement serialize(ChannelData.Node node, Type type, JsonSerializationContext ctx) {
        if (node == null) {
            return JsonNull.INSTANCE;
        }
        JsonObject o = new JsonObject();
        if (node instanceof ChannelData.ContentNode && !(node instanceof ChannelData.DataNode)) {
            ChannelData.ContentNode cnode = (ChannelData.ContentNode)node;
            o.addProperty("type", ChannelData.DataNode.class.getSimpleName());
            o.add("node", ctx.serialize((Object)new ChannelData.DataNode(cnode.getData(), cnode.getMimeType())));
        } else {
            o.addProperty("type", node.getClass().getSimpleName());
            o.add("node", ctx.serialize((Object)node));
        }
        return o;
    }

    public ChannelData.Node deserialize(JsonElement element, Type type, JsonDeserializationContext ctx) throws JsonParseException {
        JsonObject o = element.getAsJsonObject();
        String typeString = o.get("type").getAsString();
        JsonObject val = o.get("node").getAsJsonObject();
        switch (typeString) {
            case "DirectoryNode": {
                return (ChannelData.Node)ctx.deserialize((JsonElement)val, ChannelData.DirectoryNode.class);
            }
            case "DataNode": {
                return (ChannelData.Node)ctx.deserialize((JsonElement)val, ChannelData.DataNode.class);
            }
            case "ArtifactNode": {
                return (ChannelData.Node)ctx.deserialize((JsonElement)val, ChannelData.ArtifactNode.class);
            }
        }
        return null;
    }
}

