/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.aspect.mvnosgi.internal;

import java.io.IOException;
import java.util.Map;
import org.eclipse.packagedrone.repo.MetaKey;
import org.eclipse.packagedrone.repo.aspect.common.osgi.OsgiAspectFactory;
import org.eclipse.packagedrone.repo.aspect.mvnosgi.internal.Pom;
import org.eclipse.packagedrone.repo.aspect.virtual.Virtualizer;
import org.eclipse.packagedrone.repo.channel.ArtifactInformation;
import org.eclipse.packagedrone.repo.utils.osgi.bundle.BundleInformation;
import org.osgi.framework.Version;

public class VirtualizerImpl
implements Virtualizer {
    public void virtualize(Virtualizer.Context context) {
        try {
            this.processVirtualize(context);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void processVirtualize(Virtualizer.Context context) throws Exception {
        ArtifactInformation art;
        BundleInformation bi;
        String groupId = null;
        Map channelMetaData = context.getProvidedChannelMetaData();
        for (Map.Entry entry : channelMetaData.entrySet()) {
            MetaKey metaKey = (MetaKey)entry.getKey();
            if (!metaKey.getNamespace().equals("mvnosgi")) continue;
            switch (metaKey.getKey()) {
                case "groupId": {
                    groupId = (String)entry.getValue();
                    break;
                }
            }
        }
        if (groupId == null || groupId.isEmpty()) {
            groupId = "mvnosgi";
        }
        if ((bi = OsgiAspectFactory.fetchBundleInformation((Map)(art = context.getArtifactInformation()).getMetaData())) != null) {
            Version version = bi.getVersion();
            Pom pom = new Pom(groupId, bi.getId(), version.toString());
            this.createArtifact(context, pom);
            return;
        }
    }

    private void createArtifact(Virtualizer.Context context, Pom pom) throws IOException {
        String name = this.makeName(context.getArtifactInformation().getName());
        context.createVirtualArtifact(name, pom::writePom, null);
    }

    private String makeName(String name) {
        if (name == null) {
            return "mvnosgi.pom";
        }
        int idx = name.lastIndexOf(46);
        if (idx < 0 || idx >= name.length()) {
            return "mvnosgi.pom";
        }
        return String.valueOf(name.substring(0, idx)) + "-mvnosgi.pom";
    }
}

