/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.utils.osgi.feature;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.packagedrone.repo.MetaKey;
import org.eclipse.packagedrone.repo.utils.osgi.ParserHelper;
import org.eclipse.packagedrone.repo.utils.osgi.TranslatedInformation;
import org.eclipse.packagedrone.utils.Filters;
import org.osgi.framework.Version;
import org.osgi.framework.VersionRange;
import org.w3c.dom.Element;

public class FeatureInformation
implements TranslatedInformation {
    public static final MetaKey META_KEY = new MetaKey("osgi", "feature-information");
    private String id;
    private Version version;
    private String label;
    private String provider;
    private String plugin;
    private Map<String, Properties> localization = new HashMap<String, Properties>();
    private String description;
    private String descriptionUrl;
    private String copyright;
    private String copyrightUrl;
    private String license;
    private String licenseUrl;
    private Qualifiers qualifiers;
    private Set<Requirement> requirements = new HashSet<Requirement>();
    private Set<FeatureInclude> includedFeatures = new HashSet<FeatureInclude>();
    private Set<PluginInclude> includedPlugins = new HashSet<PluginInclude>();

    public void setQualifiers(Qualifiers qualifiers) {
        this.qualifiers = qualifiers;
    }

    public Qualifiers getQualifiers() {
        return this.qualifiers;
    }

    public void setIncludedPlugins(Set<PluginInclude> includedPlugins) {
        this.includedPlugins = includedPlugins;
    }

    public Set<PluginInclude> getIncludedPlugins() {
        return this.includedPlugins;
    }

    public void setRequirements(Set<Requirement> requirements) {
        this.requirements = requirements;
    }

    public Set<Requirement> getRequirements() {
        return this.requirements;
    }

    public void setIncludedFeatures(Set<FeatureInclude> includedFeatures) {
        this.includedFeatures = includedFeatures;
    }

    public Set<FeatureInclude> getIncludedFeatures() {
        return this.includedFeatures;
    }

    public void setLocalization(Map<String, Properties> localization) {
        this.localization = localization;
    }

    @Override
    public Map<String, Properties> getLocalization() {
        return this.localization;
    }

    public void setPlugin(String plugin) {
        this.plugin = plugin;
    }

    public String getPlugin() {
        return this.plugin;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public Version getVersion() {
        return this.version;
    }

    public void setVersion(Version version) {
        this.version = version;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescriptionUrl() {
        return this.descriptionUrl;
    }

    public void setDescriptionUrl(String descriptionUrl) {
        this.descriptionUrl = descriptionUrl;
    }

    public String getCopyright() {
        return this.copyright;
    }

    public void setCopyright(String copyright) {
        this.copyright = copyright;
    }

    public String getCopyrightUrl() {
        return this.copyrightUrl;
    }

    public void setCopyrightUrl(String copyrightUrl) {
        this.copyrightUrl = copyrightUrl;
    }

    public String getLicense() {
        return this.license;
    }

    public void setLicense(String license) {
        this.license = license;
    }

    public String getLicenseUrl() {
        return this.licenseUrl;
    }

    public void setLicenseUrl(String licenseUrl) {
        this.licenseUrl = licenseUrl;
    }

    public String toString() {
        return String.format("[Feature: %s]", this.id);
    }

    public static FeatureInformation fromJson(String string) {
        return FeatureInformation.fromJson(string, FeatureInformation.class);
    }

    public static <T extends FeatureInformation> T fromJson(String string, Class<T> clazz) {
        if (string == null) {
            return null;
        }
        return (T)((FeatureInformation)ParserHelper.newGson().fromJson(string, clazz));
    }

    public String toJson() {
        return ParserHelper.newGson().toJson((Object)this);
    }

    public static class FeatureInclude
    implements Comparable<FeatureInclude> {
        private final String id;
        private final Version version;
        private final String name;
        private final boolean optional;
        private final Qualifiers qualifiers;

        public FeatureInclude(String id, Version version, String name, boolean optional, Qualifiers qualifiers) {
            this.id = id;
            this.version = version;
            this.name = name;
            this.optional = optional;
            this.qualifiers = qualifiers;
        }

        public String getId() {
            return this.id;
        }

        public Version getVersion() {
            return this.version;
        }

        public String getName() {
            return this.name;
        }

        public boolean isOptional() {
            return this.optional;
        }

        public Qualifiers getQualifiers() {
            return this.qualifiers;
        }

        public VersionRange makeVersionRange() {
            if (this.version == null) {
                return new VersionRange("0.0.0");
            }
            return new VersionRange('[', this.version, this.version, ']');
        }

        @Override
        public int compareTo(FeatureInclude o) {
            int rc = this.id.compareTo(o.id);
            if (rc != 0) {
                return rc;
            }
            return this.version.compareTo(o.version);
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
            result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FeatureInclude other = (FeatureInclude)obj;
            if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
                return false;
            }
            return !(this.version == null ? other.version != null : !this.version.equals((Object)other.version));
        }
    }

    public static class PluginInclude
    implements Comparable<PluginInclude> {
        private String id;
        private Version version;
        private boolean unpack;
        private Qualifiers qualifiers;

        public PluginInclude(String id, Version version, boolean unpack, Qualifiers qualifiers) {
            this.id = id;
            this.version = version;
            this.unpack = unpack;
            this.qualifiers = qualifiers;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public Version getVersion() {
            return this.version;
        }

        public void setVersion(Version version) {
            this.version = version;
        }

        public boolean isUnpack() {
            return this.unpack;
        }

        public void setUnpack(boolean unpack) {
            this.unpack = unpack;
        }

        public Qualifiers getQualifiers() {
            return this.qualifiers;
        }

        public void setQualifiers(Qualifiers qualifiers) {
            this.qualifiers = qualifiers;
        }

        public VersionRange makeVersionRange() {
            if (this.version == null) {
                return new VersionRange("0.0.0");
            }
            return new VersionRange('[', this.version, this.version, ']');
        }

        @Override
        public int compareTo(PluginInclude o) {
            int rc = this.id.compareTo(o.id);
            if (rc != 0) {
                return rc;
            }
            return this.version.compareTo(o.version);
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
            result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PluginInclude other = (PluginInclude)obj;
            if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
                return false;
            }
            return !(this.version == null ? other.version != null : !this.version.equals((Object)other.version));
        }
    }

    public static class Qualifiers {
        private Set<String> operatingSystems = new TreeSet<String>();
        private Set<String> windowSystems = new TreeSet<String>();
        private Set<String> architectures = new TreeSet<String>();
        private Set<String> languages = new TreeSet<String>();

        public Set<String> getOperatingSystems() {
            return this.operatingSystems;
        }

        public void setOperatingSystems(Set<String> operatingSystems) {
            this.operatingSystems = operatingSystems;
        }

        public Set<String> getWindowSystems() {
            return this.windowSystems;
        }

        public void setWindowSystems(Set<String> windowSystems) {
            this.windowSystems = windowSystems;
        }

        public Set<String> getArchitectures() {
            return this.architectures;
        }

        public void setArchitectures(Set<String> architectures) {
            this.architectures = architectures;
        }

        public Set<String> getLanguages() {
            return this.languages;
        }

        public void setLanguages(Set<String> languages) {
            this.languages = languages;
        }

        public static Qualifiers parse(Element ele) {
            String os = ele.getAttribute("os");
            String ws = ele.getAttribute("ws");
            String arch = ele.getAttribute("arch");
            String nl = ele.getAttribute("nl");
            Qualifiers q = new Qualifiers();
            q.getOperatingSystems().addAll(Qualifiers.makeList(os));
            q.getWindowSystems().addAll(Qualifiers.makeList(ws));
            q.getArchitectures().addAll(Qualifiers.makeList(arch));
            q.getLanguages().addAll(Qualifiers.makeList(nl));
            return q;
        }

        private static List<String> makeList(String string) {
            if (string == null || string.isEmpty()) {
                return Collections.emptyList();
            }
            return Arrays.asList(string.split("\\s*,\\s*"));
        }

        public String toFilterString() {
            if (this.isEmpty()) {
                return null;
            }
            Filters.Multi and = new Filters.Multi("&");
            and.addNode((Filters.Node)this.expand("|", "osgi.os", this.operatingSystems));
            and.addNode((Filters.Node)this.expand("|", "osgi.ws", this.windowSystems));
            and.addNode((Filters.Node)this.expand("|", "osgi.arch", this.architectures));
            and.addNode((Filters.Node)this.expand("|", "osgi.nl", this.languages));
            return and.toString();
        }

        private Filters.Multi expand(String oper, String key, Set<String> values) {
            Filters.Multi m = new Filters.Multi("|");
            for (String v : values) {
                m.addNode((Filters.Node)new Filters.Pair(key, v));
            }
            return m;
        }

        public boolean isEmpty() {
            return this.operatingSystems.isEmpty() && this.windowSystems.isEmpty() && this.architectures.isEmpty() && this.languages.isEmpty();
        }
    }

    public static class Requirement
    implements Comparable<Requirement> {
        private final Type type;
        private final String id;
        private final Version version;
        private final MatchRule matchRule;

        public Requirement(Type type, String id, Version version, MatchRule matchRule) {
            this.type = type;
            this.id = id;
            this.version = version;
            this.matchRule = matchRule;
        }

        public Type getType() {
            return this.type;
        }

        public String getId() {
            return this.id;
        }

        public Version getVersion() {
            return this.version;
        }

        public MatchRule getMatchRule() {
            return this.matchRule;
        }

        @Override
        public int compareTo(Requirement o) {
            int rc = this.id.compareTo(o.id);
            return rc;
        }

        public static enum MatchRule {
            DEFAULT("default"){

                @Override
                public VersionRange makeRange(Version version) {
                    return new VersionRange("0.0.0");
                }
            }
            ,
            EQUIVALENT("equivalent"){

                @Override
                public VersionRange makeRange(Version version) {
                    Version endVersion = new Version(version.getMajor(), version.getMinor() + 1, 0);
                    return new VersionRange('[', version, endVersion, ')');
                }
            }
            ,
            COMPATIBLE("compatible"){

                @Override
                public VersionRange makeRange(Version version) {
                    Version endVersion = new Version(version.getMajor() + 1, 0, 0);
                    return new VersionRange('[', version, endVersion, ')');
                }
            }
            ,
            PERFECT("perfect"){

                @Override
                public VersionRange makeRange(Version version) {
                    return new VersionRange('[', version, version, ']');
                }
            }
            ,
            GREATER_OR_EQUAL("greaterOrEqual"){

                @Override
                public VersionRange makeRange(Version version) {
                    return new VersionRange(version.toString());
                }
            };

            private String id;

            private MatchRule(String id) {
                this.id = id;
            }

            public String getId() {
                return this.id;
            }

            public static MatchRule findById(String id) {
                MatchRule[] matchRuleArray = MatchRule.values();
                int n = matchRuleArray.length;
                int n2 = 0;
                while (n2 < n) {
                    MatchRule mr = matchRuleArray[n2];
                    if (mr.getId().equals(id)) {
                        return mr;
                    }
                    ++n2;
                }
                return null;
            }

            public abstract VersionRange makeRange(Version var1);
        }

        public static enum Type {
            FEATURE,
            PLUGIN;

        }
    }
}

