/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.web.dispatcher.internal.internal.jsp;

import java.util.Enumeration;
import javax.servlet.ServletException;
import org.eclipse.packagedrone.web.dispatcher.internal.internal.jsp.JspBundle;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;
import org.osgi.service.http.NamespaceException;
import org.osgi.util.tracker.BundleTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JspBundleCustomizer
implements BundleTrackerCustomizer<JspBundle> {
    private static final Logger logger = LoggerFactory.getLogger(JspBundleCustomizer.class);
    private final HttpService service;
    private final HttpContext context;

    public JspBundleCustomizer(HttpService service, HttpContext context) {
        this.service = service;
        this.context = context;
    }

    public JspBundle addingBundle(Bundle bundle, BundleEvent event) {
        Enumeration result = bundle.getEntryPaths("/WEB-INF");
        if (result != null && result.hasMoreElements()) {
            try {
                return new JspBundle(bundle, this.service, this.context);
            }
            catch (ServletException | NamespaceException e) {
                logger.warn("Failed to register JSP bundle: " + bundle.getSymbolicName(), e);
                return null;
            }
        }
        return null;
    }

    public void modifiedBundle(Bundle bundle, BundleEvent event, JspBundle jspBundle) {
    }

    public void removedBundle(Bundle bundle, BundleEvent event, JspBundle jspBundle) {
        jspBundle.dispose();
    }
}

