/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.channel.web.deploy;

import com.google.common.net.UrlEscapers;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.annotation.HttpConstraint;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.eclipse.packagedrone.repo.channel.deploy.DeployAuthService;
import org.eclipse.packagedrone.repo.channel.deploy.DeployGroup;
import org.eclipse.packagedrone.repo.channel.deploy.DeployKey;
import org.eclipse.packagedrone.repo.channel.web.breadcrumbs.Breadcrumbs;
import org.eclipse.packagedrone.repo.channel.web.deploy.DeployGroupBean;
import org.eclipse.packagedrone.repo.channel.web.deploy.DeployKeyBean;
import org.eclipse.packagedrone.sec.web.controller.HttpConstraints;
import org.eclipse.packagedrone.sec.web.controller.HttpContraintControllerInterceptor;
import org.eclipse.packagedrone.sec.web.controller.Secured;
import org.eclipse.packagedrone.sec.web.controller.SecuredControllerInterceptor;
import org.eclipse.packagedrone.web.Controller;
import org.eclipse.packagedrone.web.LinkTarget;
import org.eclipse.packagedrone.web.ModelAndView;
import org.eclipse.packagedrone.web.RequestMapping;
import org.eclipse.packagedrone.web.RequestMethod;
import org.eclipse.packagedrone.web.ViewResolver;
import org.eclipse.packagedrone.web.common.CommonController;
import org.eclipse.packagedrone.web.common.InterfaceExtender;
import org.eclipse.packagedrone.web.common.Modifier;
import org.eclipse.packagedrone.web.common.menu.MenuEntry;
import org.eclipse.packagedrone.web.common.page.Pagination;
import org.eclipse.packagedrone.web.controller.ControllerInterceptor;
import org.eclipse.packagedrone.web.controller.ControllerInterceptors;
import org.eclipse.packagedrone.web.controller.binding.BindingResult;
import org.eclipse.packagedrone.web.controller.binding.PathVariable;
import org.eclipse.packagedrone.web.controller.binding.RequestParameter;
import org.eclipse.packagedrone.web.controller.form.FormData;

@Controller
@RequestMapping(value={"/deploy/auth"})
@ViewResolver(value="/WEB-INF/views/deploy/auth/%s.jsp")
@Secured
@ControllerInterceptors(value={@ControllerInterceptor(value=SecuredControllerInterceptor.class), @ControllerInterceptor(value=HttpContraintControllerInterceptor.class)})
@HttpConstraint(rolesAllowed={"MANAGER"})
public class DeployAuthController
implements InterfaceExtender {
    public static final Object GROUP_ACTION_TAG = new Object();
    private static final int PAGE_SIZE = 25;
    private static final LinkTarget.ControllerMethod METHOD_LIST_GROUPS = LinkTarget.getControllerMethod(DeployAuthController.class, (String)"listGroups");
    private static final LinkTarget.ControllerMethod METHOD_ADD_GROUP = LinkTarget.getControllerMethod(DeployAuthController.class, (String)"addGroup");
    private DeployAuthService service;

    public void setService(DeployAuthService service) {
        this.service = service;
    }

    public List<MenuEntry> getMainMenuEntries(HttpServletRequest request) {
        LinkedList<MenuEntry> result = new LinkedList<MenuEntry>();
        if (HttpConstraints.isCallAllowed((LinkTarget.ControllerMethod)METHOD_LIST_GROUPS, (HttpServletRequest)request)) {
            result.add(new MenuEntry("Administration", 10000, "Deploy Keys", 2000, LinkTarget.createFromController((LinkTarget.ControllerMethod)METHOD_LIST_GROUPS), null, null));
        }
        return result;
    }

    public List<MenuEntry> getActions(HttpServletRequest request, Object object) {
        LinkedList<MenuEntry> result = new LinkedList<MenuEntry>();
        if (HttpConstraints.isCallAllowed((LinkTarget.ControllerMethod)METHOD_ADD_GROUP, (HttpServletRequest)request)) {
            if (GROUP_ACTION_TAG.equals(object)) {
                result.add(new MenuEntry("Add group", 2000, LinkTarget.createFromController((LinkTarget.ControllerMethod)METHOD_ADD_GROUP), Modifier.PRIMARY, null));
            } else if (object instanceof DeployGroup) {
                DeployGroup dg = (DeployGroup)object;
                HashMap<String, String> model = new HashMap<String, String>();
                model.put("groupId", dg.getId());
                result.add(new MenuEntry("Create key", 2000, LinkTarget.createFromController(DeployAuthController.class, (String)"createDeployKey").expand(model), Modifier.PRIMARY, null));
                result.add(new MenuEntry("Edit", 3000, LinkTarget.createFromController(DeployAuthController.class, (String)"editGroup").expand(model), Modifier.DEFAULT, null));
                result.add(new MenuEntry("Delete", 4000, LinkTarget.createFromController(DeployAuthController.class, (String)"deleteGroup").expand(model), Modifier.DANGER, "trash"));
            }
        }
        return result;
    }

    protected void addBreadcrumbs(String action, String groupId, Map<String, Object> model) {
        LinkedList<Breadcrumbs.Entry> entries = new LinkedList<Breadcrumbs.Entry>();
        entries.add(new Breadcrumbs.Entry("Home", "/"));
        entries.add(Breadcrumbs.create("Deploy Groups", DeployAuthController.class, "listGroups"));
        if (groupId != null) {
            entries.add(Breadcrumbs.create("Group", DeployAuthController.class, "viewGroup", Collections.singletonMap("groupId", groupId)));
        }
        entries.add(new Breadcrumbs.Entry(action));
        model.put("breadcrumbs", new Breadcrumbs(entries));
    }

    @RequestMapping(value={"/group"}, method={RequestMethod.GET})
    public ModelAndView listGroups(@RequestParameter(required=false, value="start") Integer position) {
        ModelAndView result = new ModelAndView("listGroups");
        result.put("groups", (Object)Pagination.paginate((Integer)position, (int)25, (arg_0, arg_1) -> ((DeployAuthService)this.service).listGroups(arg_0, arg_1)));
        return result;
    }

    @RequestMapping(value={"/key"}, method={RequestMethod.GET})
    public ModelAndView listKeys(@RequestParameter(required=false, value="position") Integer position) {
        boolean next;
        boolean prev;
        ModelAndView result = new ModelAndView("listKeys");
        if (position == null) {
            position = 0;
        }
        List list = this.service.listGroups(position.intValue(), 26);
        boolean bl = prev = position > 0;
        if (list.size() > 25) {
            next = true;
            list.remove(list.size() - 1);
        } else {
            next = false;
        }
        result.put("keys", (Object)list);
        result.put("prev", (Object)prev);
        result.put("next", (Object)next);
        result.put("position", (Object)position);
        result.put("pageSize", (Object)25);
        return result;
    }

    @RequestMapping(value={"/key/{keyId}/delete"}, method={RequestMethod.GET})
    public ModelAndView deleteKeyForGroup(@PathVariable(value="keyId") String keyId) {
        DeployKey key = this.service.deleteDeployKey(keyId);
        if (key != null && key.getGroup().getId() != null) {
            return new ModelAndView("redirect:/deploy/auth/group/" + UrlEscapers.urlPathSegmentEscaper().escape(key.getGroup().getId()) + "/view");
        }
        return new ModelAndView("redirect:/deploy/auth/key");
    }

    @RequestMapping(value={"/addGroup"}, method={RequestMethod.GET})
    public ModelAndView addGroup() {
        HashMap<String, Object> model = new HashMap<String, Object>();
        this.addBreadcrumbs("Add group", null, model);
        return new ModelAndView("addGroup", model);
    }

    @RequestMapping(value={"/group/{groupId}/delete"}, method={RequestMethod.GET})
    public String deleteGroup(@PathVariable(value="groupId") String groupId) {
        this.service.deleteGroup(groupId);
        return "redirect:/deploy/auth/group";
    }

    @RequestMapping(value={"/addGroup"}, method={RequestMethod.POST})
    public ModelAndView addGroupPost(@RequestParameter(value="name") String name) {
        try {
            this.service.createGroup(name);
        }
        catch (Exception e) {
            return CommonController.createError((String)"Create deploy group", (String)"Failed to create deploy group", (Throwable)e);
        }
        return new ModelAndView("redirect:/deploy/auth/group");
    }

    @RequestMapping(value={"/group/{groupId}/view"})
    public ModelAndView viewGroup(@PathVariable(value="groupId") String groupId) {
        DeployGroup group = this.service.getGroup(groupId);
        if (group == null) {
            return CommonController.createNotFound((String)"Deploy Group", (String)groupId);
        }
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("group", group);
        this.addBreadcrumbs("View", null, model);
        return new ModelAndView("viewGroup", model);
    }

    @RequestMapping(value={"/group/{groupId}/edit"})
    public ModelAndView editGroup(@PathVariable(value="groupId") String groupId) {
        DeployGroup group = this.service.getGroup(groupId);
        if (group == null) {
            return CommonController.createNotFound((String)"Deploy Group", (String)groupId);
        }
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("command", DeployGroupBean.fromGroup(group));
        this.addBreadcrumbs("Edit", groupId, model);
        return new ModelAndView("editGroup", model);
    }

    @RequestMapping(value={"/group/{groupId}/edit"}, method={RequestMethod.POST})
    public ModelAndView editGroupPost(@PathVariable(value="groupId") String groupId, @Valid @FormData(value="command") DeployGroupBean group, BindingResult result) {
        HashMap<String, Object> model = new HashMap<String, Object>(1);
        if (!result.hasErrors()) {
            this.service.updateGroup(groupId, group.getName());
        }
        model.put("command", group);
        this.addBreadcrumbs("Edit", groupId, model);
        return new ModelAndView("editGroup", model);
    }

    @RequestMapping(value={"/key/{keyId}/edit"})
    public ModelAndView editKey(@PathVariable(value="keyId") String keyId) {
        DeployKey key = this.service.getDeployKey(keyId);
        if (key == null) {
            return CommonController.createNotFound((String)"Deploy Key", (String)keyId);
        }
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("id", key.getId());
        model.put("groupId", key.getGroup().getId());
        model.put("command", DeployKeyBean.fromKey(key));
        return new ModelAndView("editKey", model);
    }

    @RequestMapping(value={"/key/{keyId}/edit"}, method={RequestMethod.POST})
    public ModelAndView editKeyPost(@PathVariable(value="keyId") String keyId, @Valid @FormData(value="command") DeployKeyBean key, BindingResult result) {
        DeployKey dk;
        if (!result.hasErrors() && (dk = this.service.updateDeployKey(keyId, key.getName())) != null && dk.getGroup().getId() != null) {
            return new ModelAndView("redirect:/deploy/auth/group/" + UrlEscapers.urlPathSegmentEscaper().escape(dk.getGroup().getId()) + "/view");
        }
        return new ModelAndView("editKey", Collections.singletonMap("command", key));
    }

    @RequestMapping(value={"/group/{groupId}/createKey"})
    public ModelAndView createDeployKey(@PathVariable(value="groupId") String groupId) {
        DeployGroup group = this.service.getGroup(groupId);
        if (group == null) {
            return CommonController.createNotFound((String)"Deploy Group", (String)groupId);
        }
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("group", group);
        this.addBreadcrumbs("Create key", groupId, model);
        return new ModelAndView("createDeployKey", model);
    }

    @RequestMapping(value={"/group/{groupId}/createKey"}, method={RequestMethod.POST})
    public ModelAndView createDeployKeyPost(@PathVariable(value="groupId") String groupId, @RequestParameter(value="name", required=false) String name) {
        try {
            this.service.createDeployKey(groupId, name);
            return new ModelAndView("redirect:/deploy/auth/group/" + UrlEscapers.urlPathSegmentEscaper().escape(groupId) + "/view");
        }
        catch (Exception e) {
            return CommonController.createError((String)"Create deploy key", (String)"Failed to create deploy key", (Throwable)e);
        }
    }
}

