/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.utils.deb;

import java.io.IOException;

public enum FieldFormatter {
    SINGLE{

        @Override
        public void appendValue(String value, Appendable appendable) throws IOException {
            if (value == null) {
                return;
            }
            value = value.replaceAll("[\\n\\r]", "");
            appendable.append(value);
        }

        @Override
        public void append(String key, String value, Appendable appendable) throws IOException {
            if (key == null || value == null) {
                return;
            }
            appendable.append(key).append(':');
            if (!value.isEmpty()) {
                appendable.append(' ');
            }
            this.appendValue(value, appendable);
        }
    }
    ,
    MULTI{

        @Override
        public void append(String key, String value, Appendable appendable) throws IOException {
            if (key == null || value == null) {
                return;
            }
            appendable.append(key).append(':');
            String[] lines = value.split("\\n");
            if (lines.length > 0 && !lines[0].isEmpty()) {
                appendable.append(' ');
            }
            this.appendLines(appendable, lines);
        }

        @Override
        public void appendValue(String value, Appendable appendable) throws IOException {
            if (value == null) {
                return;
            }
            String[] lines = value.split("\\n");
            this.appendLines(appendable, lines);
        }

        private void appendLines(Appendable appendable, String[] lines) throws IOException {
            int i = 0;
            while (i < lines.length) {
                String line = lines[i];
                if (line.isEmpty() && i > 0) {
                    appendable.append(" .");
                } else if (!line.isEmpty()) {
                    if (i > 0) {
                        appendable.append(' ');
                    }
                    appendable.append(line);
                }
                if (i < lines.length - 1) {
                    appendable.append('\n');
                }
                ++i;
            }
        }
    };


    private FieldFormatter() {
    }

    public abstract void appendValue(String var1, Appendable var2) throws IOException;

    public abstract void append(String var1, String var2, Appendable var3) throws IOException;

    public String format(String key, String value) {
        StringBuilder sb = new StringBuilder();
        try {
            this.append(key, value, sb);
        }
        catch (IOException iOException) {}
        return sb.toString();
    }

    public String formatValue(String value) {
        StringBuilder sb = new StringBuilder();
        try {
            this.appendValue(value, sb);
        }
        catch (IOException iOException) {}
        return sb.toString();
    }

    /* synthetic */ FieldFormatter(String string, int n, FieldFormatter fieldFormatter) {
        this();
    }
}

