/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.utils.converter.impl;

import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.packagedrone.utils.converter.ConversionContext;
import org.eclipse.packagedrone.utils.converter.Converter;

public class StringToSetConverter
implements Converter {
    public static final StringToSetConverter INSTANCE = new StringToSetConverter();

    @Override
    public boolean canConvert(Class<?> from, Class<?> to) {
        return !(!from.equals(String[].class) && !from.equals(String.class) || !to.equals(Set.class) && !to.equals(SortedSet.class));
    }

    @Override
    public SortedSet<?> convertTo(Object value, Class<?> clazz, ConversionContext context) {
        if (value == null) {
            return null;
        }
        if (value instanceof String[]) {
            return this.convertFromArray((String[])value);
        }
        return this.convertFromValue(value.toString());
    }

    private SortedSet<?> convertFromValue(String string) {
        return new TreeSet<String>(Collections.singleton(string));
    }

    private SortedSet<?> convertFromArray(String[] value) {
        return new TreeSet<String>(Arrays.asList(value));
    }
}

