/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.web;

import com.google.common.io.ByteStreams;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.packagedrone.web.RequestHandler;
import org.eclipse.packagedrone.web.util.Requests;
import org.eclipse.packagedrone.web.util.Responses;

public class ResourceRequestHandler
implements RequestHandler {
    private final URL url;
    private final long lastModified;

    public ResourceRequestHandler(URL url, long lastModified) {
        Objects.requireNonNull(url, "'url' must not be null");
        this.url = url;
        this.lastModified = lastModified;
    }

    @Override
    public void process(HttpServletRequest request, HttpServletResponse response) throws IOException {
        boolean isGet = request.getMethod().equalsIgnoreCase("get");
        if (!isGet && request.getMethod().equalsIgnoreCase("head")) {
            if (Requests.isNotModified(request, this.lastModified)) {
                return;
            }
            isGet = true;
        }
        if (!isGet) {
            Responses.methodNotAllowed(request, response);
            return;
        }
        try {
            Throwable throwable = null;
            Object var5_6 = null;
            try (InputStream in = this.url.openStream();){
                response.setDateHeader("Last-Modified", this.lastModified);
                ByteStreams.copy((InputStream)in, (OutputStream)response.getOutputStream());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            Responses.notFound(request, response);
        }
    }
}

