/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.trigger.common.unique;

import org.eclipse.packagedrone.repo.channel.AddingContext;
import org.eclipse.packagedrone.repo.trigger.Processor;
import org.eclipse.packagedrone.repo.trigger.ProcessorFactory;
import org.eclipse.packagedrone.repo.trigger.common.unique.UniqueArtifactConfiguration;
import org.eclipse.packagedrone.repo.trigger.common.unique.UniqueArtifactConfigurationController;
import org.eclipse.packagedrone.repo.trigger.common.unique.UniqueArtifactProcessor;
import org.eclipse.packagedrone.web.LinkTarget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UniqueArtifactProcessorFactory
implements ProcessorFactory {
    static final Class<?>[] SUPPORTED_CONTEXTS = new Class[]{AddingContext.class};
    private static final Logger logger = LoggerFactory.getLogger(UniqueArtifactProcessorFactory.class);
    public static final String ID = "unique.artifact";

    public Class<?>[] getSupportedContexts() {
        return SUPPORTED_CONTEXTS;
    }

    public Processor create(String configuration) {
        return new UniqueArtifactProcessor(UniqueArtifactConfiguration.fromJson(configuration));
    }

    public String getLabel() {
        return "Unique artifacts";
    }

    public String getDescription() {
        return "Ensure the uniqueness of artifacts.";
    }

    public String getConfigurationUrl() {
        try {
            return LinkTarget.createFromController(UniqueArtifactConfigurationController.class, (String)"configure").getUrl();
        }
        catch (Exception e) {
            logger.warn("Failed to generate configuration url", (Throwable)e);
            return null;
        }
    }
}

