/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.storage.apm;

import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.eclipse.packagedrone.repo.MetaKey;
import org.eclipse.packagedrone.storage.apm.ModelInitializationException;
import org.eclipse.packagedrone.storage.apm.StorageContext;
import org.eclipse.packagedrone.storage.apm.StorageModelProvider;
import org.eclipse.packagedrone.storage.apm.StorageRegistration;

public class StorageManager {
    private static final ThreadLocal<Deque<State>> lockStates = ThreadLocal.withInitial(LinkedList::new);
    private long counter;
    private final ReadWriteLock modelLock = new ReentrantReadWriteLock(false);
    private final Map<Long, Entry> modelIdMap = new HashMap<Long, Entry>();
    private final Map<MetaKey, Entry> modelKeyMap = new HashMap<MetaKey, Entry>();
    private final StorageContext context;
    private boolean closed;

    private static State getSameParent(State parent, MetaKey key) {
        State current = parent;
        while (current != null) {
            if (current.key.equals((Object)key)) {
                return current;
            }
            current = current.parent;
        }
        return null;
    }

    public StorageManager(final Path basePath) {
        this.validateBasePath(basePath);
        this.context = new StorageContext(){

            @Override
            public Path getBasePath() {
                return basePath;
            }
        };
    }

    private void validateBasePath(Path basePath) {
        if (Files.exists(basePath, new LinkOption[0])) {
            if (!Files.isDirectory(basePath, new LinkOption[0])) {
                throw new IllegalStateException(String.format("Base path '%s' already exists but is not a directory", basePath.toString()));
            }
            if (!Files.isWritable(basePath)) {
                throw new IllegalStateException(String.format("Base path '%s' already exists but is not writable", basePath.toString()));
            }
        } else {
            try {
                Files.createDirectories(basePath, new FileAttribute[0]);
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to create base path", e);
            }
        }
    }

    public StorageRegistration registerModel(long lockPriority, MetaKey key, StorageModelProvider<?, ?> storageProvider) throws ModelInitializationException {
        this.modelLock.writeLock().lock();
        try {
            this.testClosed();
            if (this.modelKeyMap.containsKey(key)) {
                throw new IllegalArgumentException(String.format("A provider for '%s' is already registered", key));
            }
            try {
                storageProvider.start(this.context);
            }
            catch (Exception e) {
                throw new ModelInitializationException("Failed to start model provider: " + key, e);
            }
            final long id = this.counter++;
            Entry entry = new Entry(id, lockPriority, key, storageProvider);
            this.modelIdMap.put(id, entry);
            this.modelKeyMap.put(key, entry);
            StorageRegistration storageRegistration = new StorageRegistration(){

                @Override
                public void unregister() {
                    StorageManager.this.unregisterModel(id);
                }
            };
            return storageRegistration;
        }
        finally {
            this.modelLock.writeLock().unlock();
        }
    }

    protected void unregisterModel(long id) {
        Entry entry;
        this.modelLock.writeLock().lock();
        try {
            if (this.closed) {
                return;
            }
            entry = this.modelIdMap.remove(id);
            if (entry != null) {
                this.modelKeyMap.remove(entry.key);
            }
        }
        finally {
            this.modelLock.writeLock().unlock();
        }
        if (entry == null) {
            return;
        }
        entry.lock.writeLock().lock();
        try {
            entry.storageProvider.stop();
        }
        finally {
            entry.lock.writeLock().unlock();
        }
    }

    public <T, M> T accessCall(MetaKey modelKey, Class<M> modelClazz, Function<M, T> function) {
        return (T)this.doWithModel(LockType.READ, modelKey, entry -> entry.lock.readLock(), (entry, state) -> this.performAccessOperation((Entry)entry, (State)state, modelClazz, modelKey, function));
    }

    public <T, M> T modifyCall(MetaKey modelKey, Class<M> modelClazz, Function<M, T> function) {
        return (T)this.doWithModel(LockType.WRITE, modelKey, entry -> entry.lock.writeLock(), (entry, state) -> this.performModifyOperation((Entry)entry, modelClazz, function));
    }

    private <T, M> T performAccessOperation(Entry entry, State state, Class<M> modelClazz, MetaKey modelKey, Function<M, T> function) {
        State same = state.sameKeyParent;
        Object viewModel = same != null && same.writeModel != null ? entry.storageProvider.makeViewModel(same.writeModel) : entry.storageProvider.getViewModel();
        if (viewModel == null || modelClazz.isAssignableFrom(viewModel.getClass())) {
            return function.apply(modelClazz.cast(viewModel));
        }
        throw new IllegalStateException(String.format("View model of '%s' is not of type '%s'", modelKey, modelClazz.getName()));
    }

    private <T, M> T performModifyOperation(Entry entry, Class<M> modelClazz, Function<M, T> function) {
        StorageModelProvider<?, ?> sp = entry.storageProvider;
        State current = StorageManager.getCurrent();
        State same = current.sameKeyParent;
        M writeModel = same == null ? StorageManager.cast(entry, modelClazz, sp.cloneWriteModel()) : StorageManager.cast(entry, modelClazz, same.getWriteModel());
        current.setWriteModel(writeModel);
        try {
            T result = function.apply(writeModel);
            if (same == null) {
                try {
                    sp.persistWriteModel(writeModel);
                }
                catch (Exception e) {
                    throw new RuntimeException(String.format("Failed to persist model of %s", entry.key), e);
                }
                current.runAfterTasks();
            }
            T t = result;
            return t;
        }
        finally {
            if (same == null) {
                sp.closeWriteModel(writeModel);
            }
        }
    }

    private static <T> T cast(Entry entry, Class<T> clazz, Object o) {
        if (o == null || clazz.isAssignableFrom(o.getClass())) {
            return clazz.cast(o);
        }
        throw new IllegalStateException(String.format("Model of '%s' is not of type '%s'", entry.key, clazz.getName()));
    }

    protected <T> T doWithModel(LockType type, MetaKey modelKey, Function<Entry, Lock> lockSupplier, BiFunction<Entry, State, T> function) {
        StateWrapper wrapper;
        Lock lock;
        Entry entry;
        Lock modelWithModel = this.modelLock.readLock();
        modelWithModel.lock();
        try {
            this.testClosed();
            entry = this.modelKeyMap.get(modelKey);
            if (entry == null) {
                throw new IllegalArgumentException(String.format("Model '%s' could not be found", modelKey));
            }
            lock = lockSupplier.apply(entry);
            wrapper = new StateWrapper(entry, type);
            lock.lock();
        }
        finally {
            this.modelLock.readLock().unlock();
        }
        try {
            T t;
            try {
                t = function.apply(entry, wrapper.state);
                wrapper.dispose();
            }
            catch (Throwable throwable) {
                wrapper.dispose();
                throw throwable;
            }
            return t;
        }
        finally {
            lock.unlock();
        }
    }

    protected static State getCurrent() {
        Deque<State> stack = lockStates.get();
        return stack.peekLast();
    }

    public StorageContext getContext() {
        this.testClosed();
        return this.context;
    }

    public <M> void accessRun(MetaKey modelKey, Class<M> modelClazz, Consumer<M> consumer) {
        this.accessCall(modelKey, modelClazz, model -> {
            consumer.accept(model);
            return null;
        });
    }

    public <M> void modifyRun(MetaKey modelKey, Class<M> modelClazz, Consumer<M> consumer) {
        this.modifyCall(modelKey, modelClazz, model -> {
            consumer.accept(model);
            return null;
        });
    }

    public static void executeAfterPersist(Runnable runnable) {
        State parent;
        State state = StorageManager.getCurrent();
        if (state == null) {
            runnable.run();
            return;
        }
        MetaKey key = state.key;
        if (key == null) {
            runnable.run();
            return;
        }
        State state2 = parent = state.sameKeyParent == null ? state : state.sameKeyParent;
        if (parent.type == LockType.READ) {
            runnable.run();
            return;
        }
        parent.addAfterTask(runnable);
    }

    public void close() {
        ArrayList<Entry> providers;
        this.modelLock.writeLock().lock();
        try {
            if (this.closed) {
                return;
            }
            providers = new ArrayList<Entry>(this.modelIdMap.values());
            this.closed = true;
            this.modelIdMap.clear();
            this.modelKeyMap.clear();
        }
        finally {
            this.modelLock.writeLock().unlock();
        }
        LinkedList<Exception> allErrors = new LinkedList<Exception>();
        for (Entry entry : providers) {
            try {
                entry.storageProvider.stop();
            }
            catch (Exception e) {
                allErrors.add(e);
            }
        }
        StorageManager.handleErrors("Failed to close provider", allErrors);
    }

    private static void handleErrors(String message, LinkedList<Exception> allErrors) {
        if (allErrors == null) {
            return;
        }
        if (!allErrors.isEmpty()) {
            RuntimeException e = new RuntimeException(message, allErrors.poll());
            allErrors.forEach(e::addSuppressed);
            throw e;
        }
    }

    protected void testClosed() {
        if (this.closed) {
            throw new IllegalStateException("Storage is already closed");
        }
    }

    static /* synthetic */ ThreadLocal access$2() {
        return lockStates;
    }

    private static class Entry {
        long id;
        long lockPriority;
        MetaKey key;
        StorageModelProvider<?, ?> storageProvider;
        ReadWriteLock lock = new ReentrantReadWriteLock(false);

        public Entry(long id, long lockPriority, MetaKey key, StorageModelProvider<?, ?> storageProvider) {
            this.id = id;
            this.lockPriority = lockPriority;
            this.key = key;
            this.storageProvider = storageProvider;
        }
    }

    private static enum LockType {
        READ,
        WRITE;

    }

    private static class State {
        private final State parent;
        private final State sameKeyParent;
        private final long priority;
        private final MetaKey key;
        private final State highestState;
        private final LockType type;
        private Object writeModel;
        private List<Runnable> afterTasks;

        public State(State parent, LockType type, long priority, MetaKey key) {
            this.parent = parent;
            this.priority = priority;
            this.key = key;
            this.type = type;
            State sameParent = StorageManager.getSameParent(parent, key);
            this.sameKeyParent = sameParent != null && sameParent.sameKeyParent != null ? sameParent.sameKeyParent : sameParent;
            this.highestState = parent == null ? this : (State.compareTwo(priority, key, parent.priority, parent.key) > 0 ? this : parent);
        }

        public void setWriteModel(Object writeModel) {
            this.writeModel = writeModel;
        }

        public Object getWriteModel() {
            return this.writeModel;
        }

        public static int compareTo(State state1, State state2) {
            return State.compareTwo(state1.priority, state1.key, state2.priority, state2.key);
        }

        private static int compareTwo(long priority1, MetaKey key1, long priority2, MetaKey key2) {
            int rc = Long.compare(priority1, priority2);
            if (rc != 0) {
                return rc;
            }
            return key1.compareTo(key2);
        }

        public State getHighestState() {
            return this.highestState;
        }

        public String toString() {
            return String.format("%s -> %s|%s", this.parent != null ? this.parent : "ROOT", this.priority, this.key);
        }

        public boolean isLocked(MetaKey key) {
            return StorageManager.getSameParent(this, key) != null;
        }

        public boolean isReadLocked(MetaKey key) {
            State current = this;
            while (current != null) {
                if (current.key.equals((Object)key) && current.type == LockType.READ) {
                    return true;
                }
                current = current.parent;
            }
            return false;
        }

        public void addAfterTask(Runnable runnable) {
            if (this.afterTasks == null) {
                this.afterTasks = new LinkedList<Runnable>();
            }
            this.afterTasks.add(runnable);
        }

        public void runAfterTasks() {
            if (this.afterTasks == null) {
                return;
            }
            LinkedList<Exception> errors = null;
            for (Runnable runnable : this.afterTasks) {
                try {
                    runnable.run();
                }
                catch (Exception e) {
                    if (errors == null) {
                        errors = new LinkedList<Exception>();
                    }
                    errors.add(e);
                }
            }
            this.afterTasks.clear();
            StorageManager.handleErrors("Failed to run 'after' tasks", errors);
        }
    }

    private static class StateWrapper {
        private final Deque<State> stack = (Deque)StorageManager.access$2().get();
        private final State state;

        public StateWrapper(Entry entry, LockType type) {
            State current = this.stack.peekLast();
            State next = new State(current, type, entry.lockPriority, entry.key);
            if (current != null) {
                if (type == LockType.WRITE && current.isReadLocked(entry.key)) {
                    throw new IllegalStateException(String.format("%s is already read locked. Upgrading read locks to write locks is not supported! (State: %s)", entry.key, current));
                }
                if (!current.isLocked(entry.key) && State.compareTo(current.getHighestState(), next) >= 0) {
                    throw new IllegalStateException(String.format("Lock is lower or equal in priority than previous lock: %s -> %s", current, next));
                }
            }
            this.stack.addLast(next);
            this.state = next;
        }

        public void dispose() {
            this.stack.removeLast();
        }
    }
}

