/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.api;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import io.swagger.annotations.AuthorizationScope;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.eclipse.packagedrone.repo.api.ChannelInformation;
import org.eclipse.packagedrone.repo.api.ChannelListResult;
import org.eclipse.packagedrone.repo.api.CreateChannel;
import org.eclipse.packagedrone.repo.api.ErrorInformation;

@Path(value="/channels")
@Api(tags={"Repository"})
public interface Channels {
    @GET
    @ApiOperation(value="List all channels")
    @Produces(value={"application/json"})
    @ApiResponses(value={@ApiResponse(code=500, response=ErrorInformation.class, message="An internal error")})
    public ChannelListResult list();

    @PUT
    @ApiOperation(value="Create a new channel", authorizations={@Authorization(value="access_token", scopes={@AuthorizationScope(scope="MANAGER", description="Manager the repository")})})
    @ApiResponses(value={@ApiResponse(code=500, response=ErrorInformation.class, message="An internal error")})
    @Produces(value={"application/json"})
    @Path(value="/create")
    @RolesAllowed(value={"MANAGER"})
    public ChannelInformation createChannel(@ApiParam(required=true, value="The new channel information") CreateChannel var1);
}

