/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.launcher;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.internal.debug.ui.launcher.IClasspathViewer;
import org.eclipse.jdt.internal.debug.ui.launcher.IEntriesChangedListener;
import org.eclipse.jdt.internal.debug.ui.launcher.RuntimeClasspathEntryLabelProvider;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class RuntimeClasspathViewer
extends TableViewer
implements IClasspathViewer {
    private boolean fEnabled = true;
    private ListenerList fListeners = new ListenerList();
    protected List<IRuntimeClasspathEntry> fEntries = new ArrayList<IRuntimeClasspathEntry>();

    public RuntimeClasspathViewer(Composite parent) {
        super(parent);
        this.setContentProvider((IContentProvider)new ContentProvider());
        RuntimeClasspathEntryLabelProvider lp = new RuntimeClasspathEntryLabelProvider();
        this.setLabelProvider((IBaseLabelProvider)lp);
        this.setInput(this.fEntries);
        this.getTable().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (RuntimeClasspathViewer.this.isEnabled() && event.character == '\u007f' && event.stateMask == 0) {
                    List selection = RuntimeClasspathViewer.this.getSelectionFromWidget();
                    RuntimeClasspathViewer.this.fEntries.removeAll(selection);
                    RuntimeClasspathViewer.this.setInput(RuntimeClasspathViewer.this.fEntries);
                    RuntimeClasspathViewer.this.notifyChanged();
                }
            }
        });
    }

    @Override
    public void setEntries(IRuntimeClasspathEntry[] entries) {
        this.fEntries.clear();
        int i = 0;
        while (i < entries.length) {
            this.fEntries.add(entries[i]);
            ++i;
        }
        this.setInput(this.fEntries);
        this.notifyChanged();
    }

    @Override
    public IRuntimeClasspathEntry[] getEntries() {
        return this.fEntries.toArray(new IRuntimeClasspathEntry[this.fEntries.size()]);
    }

    @Override
    public void addEntries(IRuntimeClasspathEntry[] entries) {
        IStructuredSelection sel = (IStructuredSelection)this.getSelection();
        if (sel.isEmpty()) {
            int i = 0;
            while (i < entries.length) {
                if (!this.fEntries.contains(entries[i])) {
                    this.fEntries.add(entries[i]);
                }
                ++i;
            }
        } else {
            int index = this.fEntries.indexOf(sel.getFirstElement());
            int i = 0;
            while (i < entries.length) {
                if (!this.fEntries.contains(entries[i])) {
                    this.fEntries.add(index, entries[i]);
                    ++index;
                }
                ++i;
            }
        }
        this.setSelection((ISelection)new StructuredSelection((Object[])entries));
        this.refresh();
        this.notifyChanged();
    }

    public void setEnabled(boolean enabled) {
        this.fEnabled = enabled;
        this.setSelection(this.getSelection());
    }

    @Override
    public boolean isEnabled() {
        return this.fEnabled;
    }

    public void setLaunchConfiguration(ILaunchConfiguration configuration) {
        if (this.getLabelProvider() != null) {
            ((RuntimeClasspathEntryLabelProvider)this.getLabelProvider()).setLaunchConfiguration(configuration);
        }
    }

    public void addEntriesChangedListener(IEntriesChangedListener listener) {
        this.fListeners.add((Object)listener);
    }

    public void removeEntriesChangedListener(IEntriesChangedListener listener) {
        this.fListeners.remove((Object)listener);
    }

    @Override
    public void notifyChanged() {
        Object[] listeners = this.fListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((IEntriesChangedListener)listeners[i]).entriesChanged(this);
            ++i;
        }
    }

    @Override
    public int indexOf(IRuntimeClasspathEntry entry) {
        return this.fEntries.indexOf(entry);
    }

    @Override
    public Shell getShell() {
        return this.getControl().getShell();
    }

    @Override
    public boolean updateSelection(int actionType, IStructuredSelection selection) {
        return this.isEnabled();
    }

    class ContentProvider
    implements IStructuredContentProvider {
        ContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return RuntimeClasspathViewer.this.getEntries();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

