/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.code.flow;

import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.ConditionalExpression;
import org.eclipse.jdt.core.dom.DoStatement;
import org.eclipse.jdt.core.dom.EnhancedForStatement;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.SwitchExpression;
import org.eclipse.jdt.core.dom.SwitchStatement;
import org.eclipse.jdt.core.dom.WhileStatement;
import org.eclipse.jdt.internal.corext.dom.Selection;
import org.eclipse.jdt.internal.corext.refactoring.code.flow.DoWhileFlowInfo;
import org.eclipse.jdt.internal.corext.refactoring.code.flow.EnhancedForFlowInfo;
import org.eclipse.jdt.internal.corext.refactoring.code.flow.FlowAnalyzer;
import org.eclipse.jdt.internal.corext.refactoring.code.flow.FlowContext;
import org.eclipse.jdt.internal.corext.refactoring.code.flow.FlowInfo;
import org.eclipse.jdt.internal.corext.refactoring.code.flow.ForFlowInfo;
import org.eclipse.jdt.internal.corext.refactoring.code.flow.GenericConditionalFlowInfo;
import org.eclipse.jdt.internal.corext.refactoring.code.flow.GenericSequentialFlowInfo;
import org.eclipse.jface.text.IRegion;

public class InputFlowAnalyzer
extends FlowAnalyzer {
    private Selection fSelection;
    private boolean fDoLoopReentrance;

    public InputFlowAnalyzer(FlowContext context, Selection selection, boolean doLoopReentrance) {
        super(context);
        this.fSelection = selection;
        Assert.isNotNull((Object)this.fSelection);
        this.fDoLoopReentrance = doLoopReentrance;
    }

    public FlowInfo perform(BodyDeclaration node) {
        Assert.isTrue((!(node instanceof AbstractTypeDeclaration) ? 1 : 0) != 0);
        node.accept((ASTVisitor)this);
        return this.getFlowInfo((ASTNode)node);
    }

    @Override
    protected boolean traverseNode(ASTNode node) {
        return node.getStartPosition() + node.getLength() > this.fSelection.getInclusiveEnd();
    }

    @Override
    protected boolean createReturnFlowInfo(ReturnStatement node) {
        return node.getStartPosition() >= this.fSelection.getInclusiveEnd();
    }

    @Override
    public void endVisit(ConditionalExpression node) {
        if (this.skipNode((ASTNode)node)) {
            return;
        }
        Expression thenPart = node.getThenExpression();
        Expression elsePart = node.getElseExpression();
        if (thenPart != null && this.fSelection.coveredBy((ASTNode)thenPart) || elsePart != null && this.fSelection.coveredBy((ASTNode)elsePart)) {
            GenericSequentialFlowInfo info = this.createSequential();
            this.setFlowInfo((ASTNode)node, info);
            this.endVisitConditional(info, (ASTNode)node.getExpression(), new ASTNode[]{thenPart, elsePart});
        } else {
            super.endVisit(node);
        }
    }

    @Override
    public void endVisit(DoStatement node) {
        super.endVisit(node);
        this.handleLoopReentrance((ASTNode)node);
    }

    @Override
    public void endVisit(IfStatement node) {
        if (this.skipNode((ASTNode)node)) {
            return;
        }
        Statement thenPart = node.getThenStatement();
        Statement elsePart = node.getElseStatement();
        if (thenPart != null && this.fSelection.coveredBy((ASTNode)thenPart) || elsePart != null && this.fSelection.coveredBy((ASTNode)elsePart)) {
            GenericSequentialFlowInfo info = this.createSequential();
            this.setFlowInfo((ASTNode)node, info);
            this.endVisitConditional(info, (ASTNode)node.getExpression(), new ASTNode[]{thenPart, elsePart});
        } else {
            super.endVisit(node);
        }
    }

    @Override
    public void endVisit(EnhancedForStatement node) {
        super.endVisit(node);
        this.handleLoopReentrance((ASTNode)node);
    }

    @Override
    public void endVisit(ForStatement node) {
        super.endVisit(node);
        this.handleLoopReentrance((ASTNode)node);
    }

    @Override
    public void endVisit(SwitchStatement node) {
        if (this.skipNode((ASTNode)node)) {
            return;
        }
        FlowAnalyzer.SwitchData data = this.preEndVisit((ASTNode)node, node.statements(), node.getExpression());
        if (data == null) {
            return;
        }
        super.endVisit(node, data);
    }

    @Override
    public void endVisit(SwitchExpression node) {
        if (this.skipNode((ASTNode)node)) {
            return;
        }
        FlowAnalyzer.SwitchData data = this.preEndVisit((ASTNode)node, node.statements(), node.getExpression());
        if (data == null) {
            return;
        }
        super.endVisit(node, data);
    }

    public FlowAnalyzer.SwitchData preEndVisit(ASTNode node, List<Statement> statements, Expression expression) {
        FlowAnalyzer.SwitchData data = this.createSwitchData(statements);
        IRegion[] ranges = data.getRanges();
        int i = 0;
        while (i < ranges.length) {
            IRegion range = ranges[i];
            if (this.fSelection.coveredBy(range)) {
                GenericSequentialFlowInfo info = this.createSequential();
                this.setFlowInfo(node, info);
                info.merge(this.getFlowInfo((ASTNode)expression), this.fFlowContext);
                info.merge(data.getInfo(i), this.fFlowContext);
                info.removeLabel(null);
                return null;
            }
            ++i;
        }
        return data;
    }

    @Override
    public void endVisit(WhileStatement node) {
        super.endVisit(node);
        this.handleLoopReentrance((ASTNode)node);
    }

    private void endVisitConditional(GenericSequentialFlowInfo info, ASTNode condition, ASTNode[] branches) {
        info.merge(this.getFlowInfo(condition), this.fFlowContext);
        ASTNode[] aSTNodeArray = branches;
        int n = branches.length;
        int n2 = 0;
        while (n2 < n) {
            ASTNode branch = aSTNodeArray[n2];
            if (branch != null && this.fSelection.coveredBy(branch)) {
                info.merge(this.getFlowInfo(branch), this.fFlowContext);
                break;
            }
            ++n2;
        }
    }

    private void handleLoopReentrance(ASTNode node) {
        if (this.fDoLoopReentrance && this.fSelection.coveredBy(node) && !this.fSelection.covers(node)) {
            LoopReentranceVisitor loopReentranceVisitor = new LoopReentranceVisitor(this.fFlowContext, this.fSelection, node);
            loopReentranceVisitor.process(node);
            GenericSequentialFlowInfo info = this.createSequential();
            info.merge(this.getFlowInfo(node), this.fFlowContext);
            info.merge(loopReentranceVisitor.getFlowInfo(node), this.fFlowContext);
            this.setFlowInfo(node, info);
        }
    }

    private static class LoopReentranceVisitor
    extends FlowAnalyzer {
        private Selection fSelection;
        private ASTNode fLoopNode;

        public LoopReentranceVisitor(FlowContext context, Selection selection, ASTNode loopNode) {
            super(context);
            this.fSelection = selection;
            this.fLoopNode = loopNode;
        }

        @Override
        protected boolean traverseNode(ASTNode node) {
            return true;
        }

        @Override
        protected boolean createReturnFlowInfo(ReturnStatement node) {
            return node.getStartPosition() + node.getLength() <= this.fSelection.getExclusiveEnd();
        }

        public void process(ASTNode node) {
            try {
                this.fFlowContext.setLoopReentranceMode(true);
                node.accept((ASTVisitor)this);
            }
            finally {
                this.fFlowContext.setLoopReentranceMode(false);
            }
        }

        @Override
        public void endVisit(DoStatement node) {
            if (this.skipNode((ASTNode)node)) {
                return;
            }
            DoWhileFlowInfo info = this.createDoWhile();
            this.setFlowInfo((ASTNode)node, info);
            info.mergeAction(this.getFlowInfo((ASTNode)node.getBody()), this.fFlowContext);
            info.removeLabel(null);
        }

        @Override
        public void endVisit(EnhancedForStatement node) {
            if (this.skipNode((ASTNode)node)) {
                return;
            }
            FlowInfo paramInfo = this.getFlowInfo((ASTNode)node.getParameter());
            FlowInfo expressionInfo = this.getFlowInfo((ASTNode)node.getExpression());
            FlowInfo actionInfo = this.getFlowInfo((ASTNode)node.getBody());
            EnhancedForFlowInfo forInfo = this.createEnhancedFor();
            this.setFlowInfo((ASTNode)node, forInfo);
            if (node == this.fLoopNode) {
                forInfo.mergeAction(actionInfo, this.fFlowContext);
            } else {
                forInfo.mergeExpression(expressionInfo, this.fFlowContext);
                forInfo.mergeParameter(paramInfo, this.fFlowContext);
                forInfo.mergeAction(actionInfo, this.fFlowContext);
            }
            forInfo.removeLabel(null);
        }

        @Override
        public void endVisit(ForStatement node) {
            if (this.skipNode((ASTNode)node)) {
                return;
            }
            GenericSequentialFlowInfo initInfo = this.createSequential(node.initializers());
            FlowInfo conditionInfo = this.getFlowInfo((ASTNode)node.getExpression());
            GenericSequentialFlowInfo incrementInfo = this.createSequential(node.updaters());
            FlowInfo actionInfo = this.getFlowInfo((ASTNode)node.getBody());
            ForFlowInfo forInfo = this.createFor();
            this.setFlowInfo((ASTNode)node, forInfo);
            if (node == this.fLoopNode) {
                forInfo.mergeIncrement(incrementInfo, this.fFlowContext);
                forInfo.mergeCondition(conditionInfo, this.fFlowContext);
                forInfo.mergeAction(actionInfo, this.fFlowContext);
            } else {
                GenericConditionalFlowInfo initIncr = new GenericConditionalFlowInfo();
                initIncr.merge(initInfo, this.fFlowContext);
                initIncr.merge(incrementInfo, this.fFlowContext);
                forInfo.mergeAccessModeSequential(initIncr, this.fFlowContext);
                forInfo.mergeCondition(conditionInfo, this.fFlowContext);
                forInfo.mergeAction(actionInfo, this.fFlowContext);
            }
            forInfo.removeLabel(null);
        }
    }
}

